/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.customize;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetShortcutPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuCustomizeShortcutsScreen
extends MenuBackground {
    MenuBox box;
    MenuButton back;
    MenuButton[] shortcuts = new MenuButton[9];
    MenuButton unequip;
    MenuScrollBar scrollBar;
    List<MenuButton> magics = new ArrayList<MenuButton>();
    int buttonsX = 0;
    private int selectedShortcut = 0;
    LinkedHashSet<ResourceLocation> allMagic = new LinkedHashSet();

    public MenuCustomizeShortcutsScreen(LinkedHashMap<String, int[]> knownMagic) {
        super("gui.menu.customize.shortcuts", new Color(0, 0, 255));
        knownMagic.forEach((s, ints) -> {
            if (ModMagic.registry.get().containsKey(new ResourceLocation(s))) {
                this.allMagic.add(new ResourceLocation(s));
            }
        });
        this.drawPlayerInfo = false;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                Minecraft.m_91087_().m_91152_((Screen)new MenuCustomizeScreen());
            }
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.init(0.0f, 0);
    }

    public void init(float scrollOffset, int handleY) {
        this.drawSeparately = true;
        float boxPosX = (float)this.f_96543_ * 0.25f;
        float boxWidth = (float)this.f_96543_ * 0.67f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.box = new MenuBox((int)boxPosX, (int)this.topBarHeight, (int)boxWidth, (int)this.middleHeight, 0.6f, new Color(4, 4, 68));
        this.buttonsX = this.box.m_252754_() + 10;
        this.f_169369_.clear();
        this.m_6702_().clear();
        this.magics.clear();
        for (int i = 0; i < this.shortcuts.length; ++i) {
            int j = i;
            this.shortcuts[i] = new MenuButton((int)this.buttonPosX, this.buttonPosY + i * 18, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.customize.shortcut", new Object[0]) + " " + (i + 1), MenuButton.ButtonType.BUTTON, e -> {
                this.selectedShortcut = j;
                this.init(this.scrollBar.scrollOffset, this.scrollBar.handleY);
            });
            this.m_142416_((GuiEventListener)this.shortcuts[i]);
        }
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        int totalMagics = 0;
        int magicLine = 0;
        this.unequip = new MenuButton((int)this.buttonPosX, this.buttonPosY - 18, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.customize.unequip", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.select(null, 0));
        this.m_142416_((GuiEventListener)this.unequip);
        for (ResourceLocation entry : this.allMagic) {
            Magic magic = (Magic)ModMagic.registry.get().getValue(entry);
            if (magic == null) continue;
            int level = playerData.getMagicLevel(entry);
            while (level >= 0) {
                int lvl = level;
                MenuButton button = new MenuButton((int)((float)((int)((float)this.f_96543_ * 0.32f)) + (float)level * (this.buttonWidth + 5.0f)), this.buttonPosY + magicLine * 18, (int)((double)this.buttonWidth * 0.8), Utils.translateToLocal(magic.getTranslationKey(level), new Object[0]), MenuButton.ButtonType.SUBBUTTON, e -> this.select(magic, lvl));
                this.magics.add(button);
                this.m_142416_((GuiEventListener)button);
                this.magics.get(totalMagics).setData(magic.getRegistryName().toString() + "," + level);
                --level;
                ++totalMagics;
            }
            ++magicLine;
        }
        int contentHeight = !this.magics.isEmpty() ? this.magics.get(this.magics.size() - 1).m_252907_() - this.magics.get(0).m_252907_() + 28 : 0;
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth) - 14 - 4, (int)this.topBarHeight + 2, (int)(this.topBarHeight + this.middleHeight) - 2, (int)this.middleHeight, contentHeight);
        this.m_142416_((GuiEventListener)this.scrollBar);
        this.scrollBar.scrollOffset = scrollOffset;
        this.scrollBar.setHandleY(handleY);
        for (MenuButton menuButton : this.magics) {
            if (menuButton == null) continue;
            menuButton.f_93623_ = !this.isMagicAlreadyEquipped(menuButton.getData());
            menuButton.offsetY = (int)this.scrollBar.scrollOffset;
        }
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY + 162, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.box.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        gui.m_280588_(this.box.m_252754_(), this.box.m_252907_(), this.box.m_252754_() + this.box.m_5711_(), this.box.m_252907_() + this.box.m_93694_());
        this.magics.forEach(menuButton -> menuButton.m_88315_(gui, mouseX, mouseY, partialTicks));
        gui.m_280618_();
        for (i = 0; i < this.shortcuts.length; ++i) {
            this.shortcuts[i].m_88315_(gui, mouseX, mouseY, partialTicks);
            this.shortcuts[i].f_93623_ = i != this.selectedShortcut;
        }
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.unequip.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.scrollBar.m_88315_(gui, mouseX, mouseY, partialTicks);
        for (i = 0; i < this.magics.size(); ++i) {
            if (this.magics.get(i) == null) continue;
            this.magics.get((int)i).f_93623_ = !this.isMagicAlreadyEquipped(this.magics.get(i).getData());
            this.magics.get((int)i).offsetY = (int)this.scrollBar.scrollOffset;
        }
    }

    private boolean isMagicAlreadyEquipped(String string) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        for (Map.Entry<Integer, String> entry : playerData.getShortcutsMap().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void select(Magic magic, int level) {
        if (magic == null) {
            PacketHandler.sendToServer(new CSSetShortcutPacket(this.selectedShortcut, level, ""));
        } else {
            PacketHandler.sendToServer(new CSSetShortcutPacket(this.selectedShortcut, level, magic.getRegistryName().toString()));
        }
        if (this.selectedShortcut < 8) {
            ++this.selectedShortcut;
            this.init(this.scrollBar.scrollOffset, this.scrollBar.handleY);
        }
    }

    public void updateScroll() {
        for (int i = 0; i < this.magics.size(); ++i) {
            if (this.magics.get(i) == null) continue;
            this.magics.get((int)i).offsetY = (int)this.scrollBar.scrollOffset;
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6375_(pMouseX, pMouseY, pButton);
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.scrollBar.m_6050_(pMouseX, pMouseY, pDelta);
        this.updateScroll();
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }
}

