/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.organization;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.organization.WeaponTreeSelectionScreen;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUnlockEquipOrgWeapon;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class WeaponUnlockScreen
extends Screen {
    IPlayerCapabilities playerData;
    Utils.OrgMember member;
    Button cancel;
    Button next;
    Button prev;
    Button select;
    final int CANCEL = 2;
    final int NEXT = 3;
    final int PREV = 4;
    final int SELECT = 5;
    List<Item> weapons;
    int current = 0;
    private final ResourceLocation GLOW = new ResourceLocation("kingdomkeys", "textures/gui/org/glow.png");
    int startCost = 1000;
    boolean unlock = true;

    public WeaponUnlockScreen(Utils.OrgMember member) {
        super((Component)Component.m_237115_((String)""));
        this.member = member;
        if (member == Utils.OrgMember.NONE) {
            throw new IllegalStateException("Tried to open Weapon Unlock screen with no Org Member");
        }
        this.weapons = Minecraft.m_91087_().f_91073_.m_9598_().m_255025_(Registries.f_256913_).m_254956_(Tags.getTagForMember(member)).m_203614_().map(Holder::m_203334_).toList();
        this.playerData = ModCapabilities.getPlayer((Player)Minecraft.m_91087_().f_91074_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.prev.f_93624_) {
            this.actionPerformed(4);
            return true;
        }
        if (delta < 0.0 && this.next.f_93624_) {
            this.actionPerformed(3);
            return true;
        }
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics gui, int p_render_1_, int p_render_2_, float p_render_3_) {
        PoseStack matrixStack = gui.m_280168_();
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        this.m_280273_(gui);
        String name = "";
        String weapon = "";
        int weapon_w = 128;
        int weapon_h = 128;
        this.m_280273_(gui);
        matrixStack.m_85836_();
        RenderSystem.enableBlend();
        gui.m_280218_(this.GLOW, this.f_96543_ / 2 - 128 - 5, this.f_96544_ / 2 - 128, 0, 0, 256, 256);
        gui.m_280488_(this.f_96547_, new ItemStack((ItemLike)this.weapons.get(this.current)).m_41786_().getString(), this.f_96543_ / 2 - 128 - 5, this.f_96544_ / 2 - 120, 0xFFFFFF);
        gui.m_280488_(this.f_96547_, "Hearts Cost: " + cost, this.f_96543_ / 2 - 128 - 5, this.f_96544_ / 2 - 110, 0xFF0000);
        gui.m_280488_(this.f_96547_, "Current Hearts: " + this.playerData.getHearts(), this.f_96543_ / 2 - 128 - 5, this.f_96544_ / 2 - 100, 0xFF0000);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_96543_ / 2 - 128 - 5 + 94), (float)(this.f_96544_ / 2 - 128 + 88), 0.0f);
        matrixStack.m_85841_(5.0f, 5.0f, 5.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientUtils.drawItemAsIcon(new ItemStack((ItemLike)this.weapons.get(this.current)), matrixStack, 0, 0, 16);
        matrixStack.m_85849_();
        super.m_88315_(gui, p_render_1_, p_render_2_, p_render_3_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.cancel = Button.m_253074_((Component)Component.m_237115_((String)"Back"), e -> this.actionPerformed(2)).m_252987_(0, 0, 50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancel);
        this.next = Button.m_253074_((Component)Component.m_237115_((String)">"), e -> this.actionPerformed(3)).m_252987_(0, 0, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.next);
        this.prev = Button.m_253074_((Component)Component.m_237115_((String)"<"), e -> this.actionPerformed(4)).m_252987_(0, 0, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prev);
        this.select = Button.m_253074_((Component)Component.m_237115_((String)"Unlock"), e -> this.actionPerformed(5)).m_252987_(0, 0, 50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.select);
        this.updateButtons();
    }

    public boolean m_7043_() {
        return false;
    }

    void actionPerformed(int ID) {
        switch (ID) {
            case 2: {
                Minecraft.m_91087_().m_91152_((Screen)new WeaponTreeSelectionScreen(this.member));
                break;
            }
            case 3: {
                if (this.current == this.weapons.size() - 1) {
                    this.current = 0;
                    break;
                }
                ++this.current;
                break;
            }
            case 4: {
                if (this.current == 0) {
                    this.current = this.weapons.size() - 1;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                ItemStack weapon = new ItemStack((ItemLike)this.weapons.get(this.current));
                this.playerData.getWeaponsUnlocked().forEach(itemStack -> {
                    if (itemStack.m_150930_(weapon.m_41720_())) {
                        weapon.m_41751_(itemStack.m_41783_());
                    }
                });
                if (this.unlock) {
                    this.playerData.unlockWeapon(weapon);
                    int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
                    this.playerData.removeHearts(cost);
                    PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon, cost));
                    break;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new EquipmentEvent.OrgWeapon((Player)this.f_96541_.f_91074_, this.playerData.getEquippedWeapon(), weapon))) break;
                this.playerData.equipWeapon(weapon);
                if (Utils.findSummoned(this.f_96541_.f_91074_.m_150109_(), this.playerData.getEquippedWeapon()) > -1) {
                    PacketHandler.sendToServer(new CSSummonKeyblade(true));
                }
                PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon));
            }
        }
        this.updateButtons();
    }

    public Item getStarterWeapon(Utils.OrgMember member) {
        return Tags.getFirstItemInTag((Level)Minecraft.m_91087_().f_91073_, Tags.getTagForMember(member));
    }

    public boolean canUnlock() {
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        if (this.playerData.getHearts() >= cost) {
            if (this.current == 0) {
                Utils.OrgMember rightMember = this.member == Utils.OrgMember.ROXAS ? Utils.OrgMember.XEMNAS : Utils.OrgMember.values()[this.member.ordinal() + 1];
                Utils.OrgMember leftMember = this.member == Utils.OrgMember.XEMNAS ? Utils.OrgMember.ROXAS : Utils.OrgMember.values()[this.member.ordinal() - 1];
                if (this.playerData.isWeaponUnlocked(this.getStarterWeapon(leftMember))) {
                    return true;
                }
                return this.playerData.isWeaponUnlocked(this.getStarterWeapon(rightMember));
            }
            return this.playerData.isWeaponUnlocked(this.weapons.get(this.current - 1));
        }
        return false;
    }

    public void updateButtons() {
        if (this.playerData.isWeaponUnlocked(this.weapons.get(this.current))) {
            this.unlock = false;
            this.select.m_93666_((Component)Component.m_237115_((String)"Equip"));
            if (this.playerData.getEquippedWeapon().m_41720_() == this.weapons.get(this.current)) {
                this.select.f_93623_ = false;
                this.select.m_93666_((Component)Component.m_237115_((String)"Equipped"));
            } else {
                this.select.f_93623_ = true;
                this.select.m_93666_((Component)Component.m_237115_((String)"Equip"));
            }
        } else {
            this.unlock = true;
            this.select.m_93666_((Component)Component.m_237115_((String)"Unlock"));
            this.select.f_93623_ = this.canUnlock();
        }
        this.next.f_93624_ = true;
        this.next.m_252865_(this.f_96543_ / 2 - this.next.m_5711_() / 2 + 128);
        this.next.m_253211_(this.f_96544_ / 2 - this.next.m_93694_() / 2);
        this.prev.f_93624_ = true;
        this.prev.m_252865_(this.f_96543_ / 2 - this.prev.m_5711_() / 2 - 128);
        this.prev.m_253211_(this.f_96544_ / 2 - this.prev.m_93694_() / 2);
        this.select.f_93624_ = true;
        this.select.m_252865_(this.f_96543_ / 2 - this.select.m_5711_() / 2);
        this.select.m_253211_(this.f_96544_ / 2 - this.select.m_93694_() / 2 + 90);
        this.cancel.f_93624_ = true;
        this.cancel.m_252865_(this.f_96543_ / 2 - this.select.m_5711_() / 2);
        this.cancel.m_253211_(this.f_96544_ / 2 - this.select.m_93694_() / 2 + 115);
    }
}

