/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class HPGui
extends OverlayBase {
    public static final HPGui INSTANCE = new HPGui();
    float hpBarWidth;
    float missingHpBarWidth;
    int guiHeight = 10;
    private float playerHealth;
    private long lastSystemTime;
    private float lastPlayerHealth;
    final ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/hpbar.png");

    private HPGui() {
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.render(gui, guiGraphics, partialTick, width, height);
        LocalPlayer player = this.minecraft.f_91074_;
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        int screenHeight = this.minecraft.m_91268_().m_85446_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 1.0f;
        switch ((Integer)this.minecraft.f_91066_.m_231928_().m_231551_()) {
            case 0: {
                scale = 0.85f;
            }
        }
        float scaleFactor = 1.5f * (float)ModConfigs.hpXScale / 100.0f;
        this.hpBarWidth = player.m_21223_() * scaleFactor;
        int hpBarMaxWidth = (int)(player.m_21233_() * scaleFactor);
        float i = player.m_21223_();
        long j = Util.m_137550_();
        if (i < this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = j;
        } else if (i > this.playerHealth && player.f_19802_ > 0) {
            this.lastSystemTime = j;
        }
        if (j - this.lastSystemTime > 1000L || this.playerHealth < player.m_21223_()) {
            this.playerHealth = i;
            this.lastPlayerHealth = i;
            this.lastSystemTime = j;
        }
        this.missingHpBarWidth = Math.max((this.lastPlayerHealth - player.m_21223_()) * scaleFactor, 0.0f);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        poseStack.m_252880_((float)ModConfigs.hpXPos, (float)ModConfigs.hpYPos, 0.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)screenWidth - (float)hpBarMaxWidth * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 2.0f * scale, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        this.drawHPBarBack(guiGraphics, 0, 0, hpBarMaxWidth, scale, (Player)player);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)screenWidth - this.hpBarWidth * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 1.0f * scale - 0.1f, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        this.drawHPBarTop(guiGraphics, 0, 0, this.hpBarWidth, scale, (Player)player);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)screenWidth - (this.hpBarWidth + this.missingHpBarWidth) * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 1.0f * scale - 0.1f, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        this.drawDamagedHPBarTop(guiGraphics, 0, 0, this.missingHpBarWidth, scale, (LivingEntity)player);
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public void drawHPBarBack(GuiGraphics gui, int posX, int posY, float width, float scale, Player player) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(scale * (float)posX, scale * (float)posY, 0.0f);
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(posX + 2) * scale, (float)posY * scale, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        int v = Utils.isPlayerLowHP(player) ? 8 : 2;
        this.blit(gui, this.texture, 0, 0, v, 0, 1, 12);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(posX + 2) * scale + width, scale * (float)posY, 0.0f);
        matrixStack.m_85841_(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    public void drawHPBarTop(GuiGraphics gui, int posX, int posY, float width, float scale, Player player) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(posX + 2) * scale, (float)(posY + 2) * scale, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, -1, 2, 12, 1, 8);
        matrixStack.m_85849_();
    }

    public void drawDamagedHPBarTop(GuiGraphics gui, int posX, int posY, float width, float scale, LivingEntity player) {
        PoseStack matrixStack = gui.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(posX + 2) * scale, (float)(posY + 2) * scale, 0.0f);
        matrixStack.m_85841_(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, -1, 2, 22, 1, 8);
        matrixStack.m_85849_();
    }
}

