/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.util.IDisabledAnimations;

@OnlyIn(value=Dist.CLIENT)
public class AeroLayerRenderer<T extends LivingEntity>
extends RenderLayer<T, PlayerModel<T>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/trident_riptide.png");
    public static final String BOX = "box";
    private final ModelPart box;

    public AeroLayerRenderer(RenderLayerParent<T, PlayerModel<T>> p_174540_, EntityModelSet p_174541_) {
        super(p_174540_);
        ModelPart modelpart = p_174541_.m_171103_(ModelLayers.f_171169_);
        this.box = modelpart.m_171324_(BOX);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn instanceof AbstractClientPlayer) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((AbstractClientPlayer)entitylivingbaseIn));
            if (!((IDisabledAnimations)renderer).isDisabled()) {
                this.renderEntity(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        } else {
            this.renderEntity(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public void renderEntity(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (ModCapabilities.getGlobal(entitylivingbaseIn) != null && entitylivingbaseIn.m_21023_((MobEffect)ModMobEffects.AERO.get())) {
            MobEffectInstance aero = entitylivingbaseIn.m_21124_((MobEffect)ModMobEffects.AERO.get());
            VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
            for (int i = 1; i <= aero.m_19564_() + 1; ++i) {
                matrixStackIn.m_85836_();
                float f = ageInTicks * 20.0f;
                if (i % 2 == 0) {
                    f *= -1.0f;
                }
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
                float scale = 1.0f;
                switch (aero.m_19564_()) {
                    case 0: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.75f * (float)i;
                            matrixStackIn.m_85841_(scale, scale * 1.2f, scale);
                            matrixStackIn.m_85837_(0.0, (double)(-0.4f + 0.8f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.35f * (float)i;
                        matrixStackIn.m_85841_(scale, scale, scale);
                        break;
                    }
                    case 1: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.85f * (float)i;
                            matrixStackIn.m_85841_(scale, scale * 1.0f, scale);
                            matrixStackIn.m_85837_(0.0, (double)(-0.8f + 0.8f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.45f * (float)i;
                        matrixStackIn.m_85841_(scale, scale, scale);
                        break;
                    }
                    case 2: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.7f * (float)i;
                            matrixStackIn.m_85841_(scale, scale * 0.6f, scale);
                            matrixStackIn.m_85837_(0.0, (double)(-1.2f + 0.6f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.55f * (float)i;
                        matrixStackIn.m_85841_(scale, scale * 0.6f, scale);
                    }
                }
                float[] color = new float[]{1.0f, 1.0f, 1.0f};
                if (((LivingEntity)entitylivingbaseIn).f_20916_ > 0) {
                    color = new float[]{0.4f, 1.0f, 1.0f};
                }
                this.box.m_104306_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
                matrixStackIn.m_85849_();
            }
        }
    }
}

