/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.magic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.model.entity.MagnetModel;
import online.kingdomkeys.kingdomkeys.entity.magic.MagnegaEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.MagneraEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.MagnetEntity;

@OnlyIn(value=Dist.CLIENT)
public class MagnetEntityRenderer
extends EntityRenderer<ThrowableProjectile> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("kingdomkeys", "textures/entity/models/magnet.png");
    MagnetModel magnetModel;
    float ticks = 0.0f;
    float prevRotationTicks = 0.0f;

    public MagnetEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.25f;
        this.magnetModel = new MagnetModel(context.m_174023_(MagnetModel.LAYER_LOCATION));
    }

    public void render(ThrowableProjectile entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float rotation = this.prevRotationTicks + (this.ticks - this.prevRotationTicks) * partialTicks;
        float speed = 0.0f;
        float scale = 0.0f;
        int maxTicks = 0;
        if (entity instanceof MagnetEntity) {
            MagnetEntity magnet = (MagnetEntity)entity;
            speed = 3.0f;
            scale = 2.0f;
            maxTicks = magnet.getMaxTicks();
        } else if (entity instanceof MagneraEntity) {
            MagneraEntity magnera = (MagneraEntity)entity;
            speed = 5.0f;
            scale = 3.0f;
            maxTicks = magnera.getMaxTicks();
        } else if (entity instanceof MagnegaEntity) {
            MagnegaEntity magnega = (MagnegaEntity)entity;
            speed = 8.0f;
            scale = 4.0f;
            maxTicks = magnega.getMaxTicks();
        }
        if ((float)entity.f_19797_ < scale * 10.0f) {
            scale = (float)entity.f_19797_ / 10.0f;
        }
        if ((float)entity.f_19797_ > (float)maxTicks - scale * 10.0f) {
            scale = (float)(maxTicks - entity.f_19797_) / 10.0f;
        }
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        matrixStackIn.m_252880_(0.0f, 1.0f, 0.0f);
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(rotation));
        this.magnetModel.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.prevRotationTicks = this.ticks;
        this.ticks += speed;
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(ThrowableProjectile entity) {
        return TEXTURE;
    }
}

