/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.command.ExpCommand;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class DriveLevelCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_DRIVE_FORMS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation location : ModDriveForms.registry.get().getKeys()) {
            if (location.toString().equals("kingdomkeys:form_anti") || location.toString().equals(DriveForm.NONE.toString()) || location.toString().equals(DriveForm.SYNCH_BLADE.toString())) continue;
            list.add(location.toString());
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"drivelevel").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"form", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DRIVE_FORMS).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)7)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(DriveLevelCommand::setValue))).executes(DriveLevelCommand::setValue))));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DriveLevelCommand.getPlayers(context, 5);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        String form = StringArgumentType.getString(context, (String)"form");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (level == 0) {
                playerData.setDriveFormLevel(form, 0);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
            } else {
                playerData.setDriveFormLevel(form, 1);
                playerData.setDriveFormExp((Player)player, form, 0);
                DriveForm drive = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(form));
                playerData.setNewKeychain(new ResourceLocation(form), ItemStack.f_41583_);
                playerData.getAbilityMap().remove(drive.getBaseAbilityForLevel(3));
                while (playerData.getDriveFormLevel(form) < level) {
                    int cost = drive.getLevelUpCost(playerData.getDriveFormLevel(form) + 1);
                    playerData.setDriveFormExp((Player)player, form, cost);
                }
            }
            ExpCommand.fix(playerData, (Player)player);
            DriveForm formInstance = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(form));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " for " + player.m_5446_().getString() + " to level " + level)), true);
            player.m_213846_((Component)Component.m_237115_((String)("Your " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " level is now " + level)));
        }
        return 1;
    }
}

