/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTagsGen
extends EntityTypeTagsProvider {
    public static final TagKey<EntityType<?>> HEARTLESS = EntityTagsGen.create("kingdomkeys:heartless");
    public static final TagKey<EntityType<?>> PUREBLOOD = EntityTagsGen.create("kingdomkeys:pureblood");
    public static final TagKey<EntityType<?>> EMBLEM = EntityTagsGen.create("kingdomkeys:emblem");
    public static final TagKey<EntityType<?>> NOBODY = EntityTagsGen.create("kingdomkeys:nobody");
    public static final TagKey<EntityType<?>> NPC = EntityTagsGen.create("kingdomkeys:npc");
    public static final TagKey<EntityType<?>> BOSS = EntityTagsGen.create("kingdomkeys:boss");

    public EntityTagsGen(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), lookupProvider, "kingdomkeys", existingFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider pProvider) {
        for (RegistryObject itemRegistryObject : ModEntities.ENTITIES.getEntries()) {
            @NotNull EntityType entityType = (EntityType)itemRegistryObject.get();
            String name = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType)).m_135815_();
            if (!entityType.m_142225_().isAssignableFrom(BaseKHEntity.class)) continue;
            IKHMob khenemy = (IKHMob)entityType;
            switch (khenemy.getKHMobType()) {
                case BOSS: {
                    this.add(BOSS, entityType);
                    break;
                }
                case HEARTLESS_EMBLEM: {
                    this.add(HEARTLESS, entityType);
                    this.add(EMBLEM, entityType);
                    break;
                }
                case HEARTLESS_PUREBLOOD: {
                    this.add(HEARTLESS, entityType);
                    this.add(PUREBLOOD, entityType);
                    break;
                }
                case NOBODY: {
                    this.add(NOBODY, entityType);
                    break;
                }
                case NPC: {
                    this.add(NPC, entityType);
                    break;
                }
            }
        }
    }

    public void add(TagKey<EntityType<?>> boss2, @NotNull EntityType<?> entity) {
        this.m_206424_(boss2).m_255245_(entity);
    }

    private static TagKey<EntityType<?>> create(String pName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(pName));
    }
}

