/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import online.kingdomkeys.kingdomkeys.datagen.builder.SynthesisRecipeBuilder;

public abstract class SynthesisRecipeProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final String modid;
    protected final Function<ResourceLocation, SynthesisRecipeBuilder> factory;
    @VisibleForTesting
    public final Map<ResourceLocation, SynthesisRecipeBuilder> generatedModels = new HashMap<ResourceLocation, SynthesisRecipeBuilder>();
    @VisibleForTesting
    public final ExistingFileHelper existingFileHelper;

    public SynthesisRecipeProvider(DataGenerator generator, String modid, Function<ResourceLocation, SynthesisRecipeBuilder> factory, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
        this.factory = factory;
    }

    public SynthesisRecipeProvider(DataGenerator generator, String modid, BiFunction<ResourceLocation, ExistingFileHelper, SynthesisRecipeBuilder> builderFromModId, ExistingFileHelper existingFileHelper) {
        this(generator, modid, (ResourceLocation loc) -> (SynthesisRecipeBuilder)((Object)((Object)builderFromModId.apply((ResourceLocation)loc, existingFileHelper))), existingFileHelper);
    }

    protected abstract void registerRecipe();

    public SynthesisRecipeBuilder getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path);
        return this.generatedModels.computeIfAbsent(outputLoc, this.factory);
    }

    protected void clear() {
        this.generatedModels.clear();
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.clear();
        this.registerRecipe();
        return this.generateAll(cache);
    }

    public String m_6055_() {
        return "Synthesis Recipes";
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        for (SynthesisRecipeBuilder model : this.generatedModels.values()) {
            Path target = this.getPath(model);
            list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)model.toJson(), (Path)target));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    private Path getPath(SynthesisRecipeBuilder model) {
        ResourceLocation loc = model.getLocation();
        return this.generator.getPackOutput().m_245269_(PackOutput.Target.DATA_PACK, "synthesis").m_245731_(loc);
    }
}

