/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class FireEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;
    LivingEntity lockOnEntity;

    public FireEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public FireEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_FIRE.get(), world);
    }

    public FireEntity(Level world, LivingEntity player, float dmgMult, LivingEntity lockOnEntity) {
        super((EntityType)ModEntities.TYPE_FIRE.get(), player, world);
        this.dmgMult = dmgMult;
        this.lockOnEntity = lockOnEntity;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.lockOnEntity != null && this.f_19797_ > 1) {
            double x = this.lockOnEntity.m_20185_() - this.m_20185_();
            double y = this.lockOnEntity.m_20186_() - this.m_20186_();
            double z = this.lockOnEntity.m_20189_() - this.m_20189_();
            this.m_6686_(this.m_20184_().f_82479_ + x / 100.0, this.m_20184_().f_82480_ + y / 100.0, this.m_20184_().f_82481_ + z / 100.0, 2.0f, 0.0f);
        }
        if (this.f_19797_ > 2) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_ && this.m_19749_() != null) {
            LivingEntity target;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.m_82443_() instanceof LivingEntity && (target = (LivingEntity)ertResult.m_82443_()) != this.m_19749_()) {
                if (target.m_21124_((MobEffect)ModMobEffects.FREEZE.get()) != null) {
                    target.m_21195_((MobEffect)ModMobEffects.FREEZE.get());
                }
                Party p = null;
                if (this.m_19749_() != null) {
                    p = ModCapabilities.getWorld(this.m_19749_().m_9236_()).getPartyFromMember(this.m_19749_().m_20148_());
                }
                if (p == null || p.getMember(target.m_20148_()) == null || p.getFriendlyFire()) {
                    target.m_20254_(5);
                    float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.2f : 2.0f;
                    target.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.FIRE, (Entity)this, this.m_19749_()), dmg * this.dmgMult);
                }
            }
            if (brtResult != null) {
                BlockPos blockpos = brtResult.m_82425_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (blockstate.m_60734_() == Blocks.f_50057_) {
                    this.m_9236_().m_46597_(blockpos, Blocks.f_50056_.m_49966_());
                }
                if (CampfireBlock.m_51321_((BlockState)blockstate) || CandleBlock.m_152845_((BlockState)blockstate) || CandleCakeBlock.m_152910_((BlockState)blockstate)) {
                    this.m_9236_().m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    protected void m_8097_() {
    }
}

