/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagneraEntity
extends ThrowableProjectile {
    int maxTicks = 130;
    float dmgMult = 1.0f;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(MagneraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public MagneraEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public MagneraEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_MAGNERA.get(), world);
    }

    public MagneraEntity(Level world, Player player, float dmgMult) {
        super((EntityType)ModEntities.TYPE_MAGNERA.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.dmgMult = dmgMult;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.m_9236_() == null || ModCapabilities.getWorld(this.m_9236_()) == null || this.getCaster() == null) {
            return;
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (this.f_19797_ >= 3) {
            float radius = 2.5f;
            if (this.f_19797_ < 25) {
                radius = (float)this.f_19797_ / 10.0f;
            }
            if (this.f_19797_ > this.maxTicks - 25) {
                radius = (float)(this.maxTicks - this.f_19797_) / 10.0f;
            }
            double X = this.m_20185_();
            double Y = this.m_20186_();
            double Z = this.m_20189_();
            for (int t = 1; t < 360; t += 30) {
                for (int s = 1; s < 360; s += 30) {
                    double x = X + (double)radius * Math.cos(Math.toRadians(s + this.f_19797_)) * Math.sin(Math.toRadians(t + this.f_19797_));
                    double z = Z + (double)radius * Math.sin(Math.toRadians(s + this.f_19797_)) * Math.sin(Math.toRadians(t + this.f_19797_));
                    double y = Y + (double)radius * Math.cos(Math.toRadians(t + this.f_19797_));
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y + 1.0, z, 0.0, 0.0, 0.0);
                }
            }
            this.m_20334_(0.0, 0.0, 0.0);
            this.f_19864_ = true;
            List<Entity> list = this.m_9236_().m_45933_((Entity)this.getCaster(), this.m_20191_().m_82377_((double)radius, (double)(radius * 2.0f), (double)radius));
            list = Utils.removePartyMembersFromList(this.getCaster(), list);
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = list.get(i);
                    double d = e.m_20185_() - this.m_20185_();
                    double d1 = e.m_20189_() - this.m_20189_();
                    if (e.m_20186_() < this.m_20186_() - 0.5) {
                        e.m_20334_(0.0, 0.5, 0.0);
                    }
                    e.m_20334_(d * -0.1, e.m_20184_().f_82480_, d1 * -0.1);
                    e.m_6469_(e.m_269291_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
                    if (this.f_19797_ + 2 <= this.maxTicks) continue;
                    if (Utils.isHostile(e)) {
                        float dmg = this.m_19749_() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.m_19749_()) * 0.3f : 2.0f;
                        e.m_6469_(e.m_269291_().m_269390_((Entity)this, this.m_19749_()), dmg * this.dmgMult);
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        }
        if (this.f_19797_ == this.maxTicks - 25) {
            this.getCaster().m_9236_().m_5594_(null, this.getCaster().m_20183_(), (SoundEvent)ModSounds.magnet2.get(), SoundSource.PLAYERS, 1.0f, 0.9f);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(Util.f_137441_));
    }
}

