/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.BlizzardEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;

public class BlueRhapsodyEntity
extends BaseElementalMusicalHeartlessEntity {
    public BlueRhapsodyEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public BlueRhapsodyEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_BLUE_RHAPSODY.get()), spawnEntity, world);
        this.f_21364_ = 8;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return BaseElementalMusicalHeartlessEntity.registerAttributes().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    protected Goal goalToUse() {
        return new BlueRhapsodyGoal(this);
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.BLIZZARD;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return new ResourceLocation("kingdomkeys", "textures/entity/mob/blue_rhapsody.png");
    }

    public boolean m_6469_(DamageSource source, float amount) {
        float multiplier = 1.0f;
        if (!this.m_9236_().f_46443_) {
            if (source.m_19385_().equals(KKResistanceType.fire.toString())) {
                multiplier = 2.0f;
            }
            if (source.m_19385_().equals(KKResistanceType.ice.toString())) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, 0.0);
                return false;
            }
        }
        return super.m_6469_(source, amount * multiplier);
    }

    class BlueRhapsodyGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private int whileAttackTimer;
        private int shotChargeTimer;

        public BlueRhapsodyGoal(BlueRhapsodyEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 5;
            this.shotChargeTimer = 40;
        }

        public boolean m_8036_() {
            if (this.f_26135_.m_5448_() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canUseAttack;
        }

        public void m_8056_() {
            this.canUseAttack = true;
            this.attackTimer = 20 + BlueRhapsodyEntity.this.m_9236_().f_46441_.m_188503_(5);
            EntityHelper.setState((Entity)this.f_26135_, 0);
            this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
            this.whileAttackTimer = 0;
        }

        public void m_8037_() {
            if (this.f_26135_.m_5448_() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                LivingEntity target = this.f_26135_.m_5448_();
                if (EntityHelper.getState((Entity)this.f_26135_) == 0) {
                    this.f_26135_.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    if ((double)BlueRhapsodyEntity.this.m_9236_().f_46441_.m_188503_(100) + BlueRhapsodyEntity.this.m_9236_().f_46441_.m_188500_() <= 75.0) {
                        EntityHelper.setState((Entity)this.f_26135_, 1);
                    } else if (this.f_26135_.m_20270_((Entity)this.f_26135_.m_5448_()) < 8.0f) {
                        EntityHelper.setState((Entity)this.f_26135_, 2);
                        this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.f_26135_, 4.0)) {
                            enemy.m_6469_(this.f_26135_.m_269291_().m_269333_((LivingEntity)this.f_26135_), 4.0f);
                        }
                    } else {
                        return;
                    }
                }
                if (EntityHelper.getState((Entity)this.f_26135_) == 2 && this.whileAttackTimer > 20) {
                    this.canUseAttack = false;
                    EntityHelper.setState((Entity)this.f_26135_, 0);
                    this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                } else if (EntityHelper.getState((Entity)this.f_26135_) == 1) {
                    if (this.shotChargeTimer > 0) {
                        --this.shotChargeTimer;
                        this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                        this.f_26135_.m_21563_().m_24960_((Entity)target, 0.0f, 0.0f);
                        ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.f_26135_.m_20185_(), this.f_26135_.m_20186_() + 2.5, this.f_26135_.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    } else {
                        this.f_26135_.m_21563_().m_24960_((Entity)target, 0.0f, 0.0f);
                        this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                        double d1 = this.f_26135_.m_5448_().m_20185_() - this.f_26135_.m_20185_();
                        double d2 = this.f_26135_.m_5448_().m_20191_().f_82289_ + (double)(this.f_26135_.m_5448_().m_20206_() / 2.0f) - (this.f_26135_.m_20186_() + (double)(this.f_26135_.m_20206_() / 2.0f));
                        double d3 = this.f_26135_.m_5448_().m_20189_() - this.f_26135_.m_20189_();
                        BlizzardEntity esfb = new BlizzardEntity(this.f_26135_.m_9236_(), (LivingEntity)this.f_26135_, (float)this.f_26135_.m_21051_(Attributes.f_22281_).m_22115_(), 200);
                        esfb.m_6686_(d1, d2, d3, 1.0f, 0.0f);
                        esfb.m_6034_(esfb.m_20185_(), this.f_26135_.m_20186_() + (double)(this.f_26135_.m_20206_() / 2.0f) + 0.5, esfb.m_20189_());
                        this.f_26135_.m_9236_().m_7967_((Entity)esfb);
                        if (this.whileAttackTimer > 50) {
                            this.shotChargeTimer = 40;
                            this.canUseAttack = false;
                            EntityHelper.setState((Entity)this.f_26135_, 0);
                            this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                        }
                    }
                }
            }
        }
    }
}

