/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import org.joml.Vector3f;

public class YellowOperaEntity
extends BaseElementalMusicalHeartlessEntity {
    public YellowOperaEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 6;
    }

    public YellowOperaEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_YELLOW_OPERA.get()), spawnEntity, world);
        this.f_21364_ = 6;
    }

    @Override
    protected Goal goalToUse() {
        return new YellowOperaGoal(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return BaseElementalMusicalHeartlessEntity.registerAttributes().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.THUNDER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return new ResourceLocation("kingdomkeys", "textures/entity/mob/yellow_opera.png");
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && source.m_19385_().equals(KKResistanceType.lightning.toString())) {
            this.m_252836_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, this.f_19796_.m_188500_() - 0.5, 0.0);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    class YellowOperaGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private int whileAttackTimer;
        private int shotChargeTimer;
        private float initialHealth;

        public YellowOperaGoal(YellowOperaEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 5;
            this.shotChargeTimer = 50;
        }

        public boolean m_8036_() {
            if (this.f_26135_.m_5448_() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canUseAttack;
        }

        public void m_8056_() {
            this.canUseAttack = true;
            this.attackTimer = 25 + YellowOperaEntity.this.m_9236_().f_46441_.m_188503_(5);
            EntityHelper.setState((Entity)this.f_26135_, 0);
            this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
            this.whileAttackTimer = 0;
            this.initialHealth = this.f_26135_.m_21223_();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void m_8037_() {
            if (this.f_26135_.m_5448_() == null || !this.canUseAttack) return;
            this.whileAttackTimer += 2;
            LivingEntity target = this.f_26135_.m_5448_();
            if (EntityHelper.getState((Entity)this.f_26135_) == 0) {
                this.f_26135_.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (YellowOperaEntity.this.m_9236_().f_46441_.m_188503_(100) <= 35 && this.f_26135_.m_20270_((Entity)target) > 6.0f) {
                    EntityHelper.setState((Entity)this.f_26135_, 1);
                } else if ((double)YellowOperaEntity.this.m_9236_().f_46441_.m_188503_(100) + YellowOperaEntity.this.m_9236_().f_46441_.m_188500_() <= 50.0) {
                    if (!(this.f_26135_.m_20270_((Entity)this.f_26135_.m_5448_()) < 8.0f)) return;
                    EntityHelper.setState((Entity)this.f_26135_, 2);
                    this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                    for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.f_26135_, 4.0)) {
                        this.f_26135_.m_7327_((Entity)enemy);
                    }
                } else {
                    EntityHelper.setState((Entity)this.f_26135_, 3);
                    this.f_26135_.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.f_26135_.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 3.0);
                    for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.f_26135_, 3.0)) {
                        this.f_26135_.m_7327_((Entity)enemy);
                    }
                }
            }
            if (EntityHelper.getState((Entity)this.f_26135_) == 3) {
                if (this.whileAttackTimer > 50) {
                    this.canUseAttack = false;
                }
                if (this.f_26135_.m_20183_().m_123341_() == (int)target.m_20185_() && this.f_26135_.m_20183_().m_123342_() == (int)target.m_20186_() && this.f_26135_.m_20183_().m_123343_() == (int)target.m_20189_()) {
                    this.canUseAttack = false;
                }
                if (this.f_26135_.m_20280_((Entity)this.f_26135_.m_5448_()) < 3.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.f_26135_.m_21223_()) {
                    this.canUseAttack = false;
                }
            }
            if (EntityHelper.getState((Entity)this.f_26135_) == 2 && this.whileAttackTimer > 20) {
                this.canUseAttack = false;
                EntityHelper.setState((Entity)this.f_26135_, 0);
                this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                return;
            } else {
                if (EntityHelper.getState((Entity)this.f_26135_) != 1) return;
                if (this.shotChargeTimer > 0) {
                    --this.shotChargeTimer;
                    this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.0);
                    ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), this.f_26135_.m_20185_(), this.f_26135_.m_20186_() + 2.5, this.f_26135_.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    return;
                } else {
                    this.f_26135_.m_21563_().m_24960_((Entity)target, 0.0f, 0.0f);
                    this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                    if (!YellowOperaEntity.this.m_9236_().f_46443_) {
                        LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(YellowOperaEntity.this.m_9236_());
                        lightningboltentity.m_20219_(target.m_20182_());
                        YellowOperaEntity.this.m_9236_().m_7967_((Entity)lightningboltentity);
                        target.m_6469_(KKDamageTypes.getElementalDamage(KKDamageTypes.LIGHTNING, (Entity)lightningboltentity, (Entity)this.f_26135_), (float)this.f_26135_.m_21133_(Attributes.f_22281_));
                    }
                    if (this.whileAttackTimer <= 50) return;
                    this.shotChargeTimer = 50;
                    this.canUseAttack = false;
                    EntityHelper.setState((Entity)this.f_26135_, 0);
                    this.f_26135_.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                }
            }
        }
    }
}

