/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.RagnarokShotEntity;

public class PrismRainCoreEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    List<RagnarokShotEntity> list = new ArrayList<RagnarokShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    float dmg;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(PrismRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> TARGETS = SynchedEntityData.m_135353_(PrismRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public PrismRainCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public PrismRainCoreEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), world);
    }

    public PrismRainCoreEntity(Level world, Player player, List<Entity> targets, float dmg) {
        super((EntityType)ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        Object targetIDS = "";
        for (Entity t : targets) {
            targetIDS = (String)targetIDS + "," + t.m_19879_();
        }
        this.setTarget(((String)targetIDS).substring(1));
        this.targetList = targets;
        this.dmg = dmg;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        double X = this.m_20185_();
        double Y = this.m_20186_() + 1.0;
        double Z = this.m_20189_();
        if (this.getCaster() != null && this.getTargets() != null) {
            if (this.f_19797_ == 1) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                for (int i = 0; i < this.getTargets().size(); ++i) {
                    Entity target = this.getTargets().get(i);
                    if (target == null) continue;
                    RagnarokShotEntity bullet = new RagnarokShotEntity(this.m_9236_(), (LivingEntity)this.getCaster(), target, this.dmg);
                    bullet.setColor(this.getColor(i % 7));
                    float r = 0.3f;
                    double offset_amount = -1.5;
                    double alpha = Math.toRadians(this.getCaster().m_146908_());
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)i * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)i * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)i * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.cos(alpha) + (Math.cos((double)i * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.sin(alpha));
                    bullet.m_6034_(x, y, z);
                    bullet.setMaxTicks(this.maxTicks + 20);
                    this.list.add(bullet);
                    this.m_9236_().m_7967_((Entity)bullet);
                }
            } else if (this.f_19797_ > 4 && this.f_19797_ < 10) {
                for (int i = 0; i < this.list.size(); ++i) {
                    RagnarokShotEntity bullet = this.list.get(i);
                    float posI = i + this.f_19797_ * 2;
                    float r = 0.3f * (float)this.f_19797_;
                    double offset_amount = -2.0;
                    double alpha = Math.toRadians(this.getCaster().m_146908_());
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)posI * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)posI * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)posI * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.cos(alpha) + (Math.cos((double)posI * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.sin(alpha));
                    bullet.m_6034_(x, y, z);
                }
            }
        }
        super.m_8119_();
    }

    private int getColor(int i) {
        switch (i) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 0xFF0000;
            }
            case 2: {
                return 65280;
            }
            case 3: {
                return 255;
            }
            case 4: {
                return 0xFF00FF;
            }
            case 5: {
                return 0xFFFF00;
            }
            case 6: {
                return 65535;
            }
        }
        return 0;
    }

    protected void m_6532_(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
            compound.m_128359_("TargetsUUID", (String)this.f_19804_.m_135370_(TARGETS));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
        this.f_19804_.m_135381_(TARGETS, (Object)compound.m_128461_("TargetUUID"));
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    public List<Entity> getTargets() {
        String[] ids;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (String id : ids = ((String)this.m_20088_().m_135370_(TARGETS)).split(",")) {
            if (id.equals("")) continue;
            list.add(this.m_9236_().m_6815_(Integer.parseInt(id)));
        }
        return list;
    }

    public void setTarget(String lists) {
        this.f_19804_.m_135381_(TARGETS, (Object)lists);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(TARGETS, (Object)"");
    }
}

