/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.integration.jei.KeybladeSummonRecipeCategory;
import online.kingdomkeys.kingdomkeys.integration.jei.SynthesisRecipeCategory;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;

@JeiPlugin
public class KKJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("kingdomkeys", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SynthesisRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new KeybladeSummonRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<Item> keychainsFromRegistry = ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof KeychainItem).toList();
        List<Item> orgWeapons = ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof IOrgWeapon).toList();
        ArrayList keychains = new ArrayList();
        keychainsFromRegistry.forEach(chain -> {
            if (((KeychainItem)chain).getKeyblade() != null) {
                keychains.add((KeychainItem)chain);
            }
        });
        InfoAdder info = new InfoAdder(registration);
        info.addInfo((Block)ModBlocks.moogleProjector.get(), "moogle_projector");
        orgWeapons.forEach(i -> info.addInfo((Item)i, "organization_weapons"));
        keychains.forEach(i -> info.addInfo((Item)i, "keychains"));
        info.addInfo((Block)ModBlocks.blastBlox.get(), "blast_blox");
        info.addInfo((Block)ModBlocks.dangerBlox.get(), "danger_blox");
        info.addInfo((Block)ModBlocks.magnetBlox.get(), "magnet_blox");
        info.addInfo((Block)ModBlocks.ghostBlox.get(), "ghost_blox");
        info.addInfo((Block)ModBlocks.bounceBlox.get(), "bounce_blox");
        info.addInfo((Item)ModItems.recipeD.get(), "recipes");
        info.addInfo((Item)ModItems.proofOfHeart.get(), "proof_of_heart");
        info.addInfo((Item)ModItems.organizationRobe_Helmet.get(), "organization_robes");
        info.addInfo((Item)ModItems.organizationRobe_Chestplate.get(), "organization_robes");
        info.addInfo((Item)ModItems.organizationRobe_Leggings.get(), "organization_robes");
        info.addInfo((Item)ModItems.organizationRobe_Boots.get(), "organization_robes");
        info.addInfo((Item)ModItems.xemnas_Helmet.get(), "organization_robes");
        info.addInfo((Item)ModItems.xemnas_Chestplate.get(), "organization_robes");
        info.addInfo((Item)ModItems.xemnas_Leggings.get(), "organization_robes");
        info.addInfo((Item)ModItems.xemnas_Boots.get(), "organization_robes");
        info.addInfo((Item)ModItems.antiCoat_Helmet.get(), "organization_robes");
        info.addInfo((Item)ModItems.antiCoat_Chestplate.get(), "organization_robes");
        info.addInfo((Item)ModItems.antiCoat_Leggings.get(), "organization_robes");
        info.addInfo((Item)ModItems.antiCoat_Boots.get(), "organization_robes");
        info.addInfo((Item)ModItems.fireSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.blizzardSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.thunderSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.gravitySpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.aeroSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.cureSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.reflectSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.stopSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.waterSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.magnetSpell.get(), "spell_orb");
        info.addInfo((Item)ModItems.valorOrb.get(), "valor_orb");
        info.addInfo((Item)ModItems.wisdomOrb.get(), "wisdom_orb");
        info.addInfo((Item)ModItems.limitOrb.get(), "limit_orb");
        info.addInfo((Item)ModItems.masterOrb.get(), "master_orb");
        info.addInfo((Item)ModItems.finalOrb.get(), "final_orb");
        registration.addRecipes(KeybladeSummonRecipeCategory.TYPE, keychains);
        registration.addRecipes(SynthesisRecipeCategory.TYPE, RecipeRegistry.getInstance().getValues());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }

    public void registerIngredients(IModIngredientRegistration registration) {
    }

    public static class InfoAdder {
        IRecipeRegistration registration;

        public InfoAdder(IRecipeRegistration registration) {
            this.registration = registration;
        }

        public void addInfo(Item item, String text) {
            this.registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("jei.info.kingdomkeys." + text))});
        }

        public void addInfo(Block item, String text) {
            this.registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("jei.info.kingdomkeys." + text))});
        }
    }
}

