/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.entity.organization.ArrowgunShotEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.item.tier.KeybladeItemTier;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSAttackOffhandPacket;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KeybladeItem
extends SwordItem
implements IItemCategory,
IExtendedReach {
    public KeybladeData data;
    private Item.Properties properties;
    public Recipe recipe;

    public KeybladeItem(Item.Properties properties) {
        super((Tier)new KeybladeItemTier(0.0f), 0, -2.4f, properties);
        this.properties = properties;
    }

    public int getStrength(int level) {
        return this.data.getStrength(level);
    }

    public int getMagic(int level) {
        return this.data.getMagic(level);
    }

    public int getStrength(ItemStack stack) {
        return this.data.getStrength(this.getKeybladeLevel(stack));
    }

    public int getMagic(ItemStack stack) {
        return this.data.getMagic(this.getKeybladeLevel(stack));
    }

    public String getDesc() {
        return Utils.translateToLocal(this.data.getDescription(), new Object[0]);
    }

    public void setKeybladeData(KeybladeData data) {
        this.data = data;
    }

    public int getKeybladeLevel(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("level")) {
            return stack.m_41783_().m_128451_("level");
        }
        return 0;
    }

    public void setKeybladeLevel(ItemStack stack, int level) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_("level", level);
    }

    public int getMaxLevel() {
        return this.data.getMaxLevel();
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player && !worldIn.f_46443_ && Utils.hasKeybladeID(stack)) {
            IPlayerCapabilities playerData;
            Player player = (Player)entityIn;
            int slot = itemSlot;
            if (slot == 0 && ItemStack.m_41728_((ItemStack)stack, (ItemStack)player.m_21206_())) {
                slot = 40;
            }
            if ((playerData = ModCapabilities.getPlayer(player)) != null) {
                ItemStack mainChain = playerData.getEquippedKeychain(DriveForm.NONE);
                if (playerData.getAlignment() != Utils.OrgMember.NONE) {
                    mainChain = playerData.getEquippedWeapon();
                }
                if (mainChain != null) {
                    ItemStack formChain = null;
                    if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                        formChain = playerData.getEquippedKeychain(new ResourceLocation(playerData.getActiveDriveForm()));
                    } else if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
                        formChain = playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                    }
                    if (formChain == null) {
                        formChain = ItemStack.f_41583_;
                    }
                    UUID stackID = Utils.getKeybladeID(stack);
                    if (!ItemStack.m_41728_((ItemStack)mainChain, (ItemStack)ItemStack.f_41583_) || !ItemStack.m_41728_((ItemStack)formChain, (ItemStack)ItemStack.f_41583_)) {
                        UUID mainChainID = Utils.getKeybladeID(mainChain);
                        UUID formChainID = Utils.getKeybladeID(formChain);
                        if (mainChainID == null) {
                            mainChainID = new UUID(0L, 0L);
                        }
                        if (formChainID == null) {
                            formChainID = new UUID(0L, 0L);
                        }
                        if (!mainChainID.equals(stackID) && !formChainID.equals(stackID)) {
                            player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        }
                    } else {
                        player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        UUID id;
                        slot = itemSlot;
                        if (i == 40 && ItemStack.m_41728_((ItemStack)stack, (ItemStack)player.m_21206_())) {
                            slot = 40;
                        }
                        if (i == slot || (id = Utils.getKeybladeID(player.m_150109_().m_8020_(i))) == null || !(player.m_150109_().m_8020_(i).m_41720_() instanceof KeybladeItem) || !id.equals(stackID) || i == player.m_150109_().f_35977_) continue;
                        player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                        player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                }
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Level level = player.m_9236_();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (player.m_6047_() && playerData.isAbilityEquipped("kingdomkeys:ability_strike_raid")) {
            int slot;
            int n = slot = hand == InteractionHand.OFF_HAND ? player.m_150109_().m_6643_() - 1 : player.m_150109_().f_35977_;
            if (itemstack != null && !playerData.getRecharge()) {
                int cost = 10;
                cost -= (int)((double)(cost * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_thrift")) * 0.2);
                playerData.remMP(Math.max(1, cost));
                if (!level.f_46443_) {
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.strike_raid.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    KKThrowableEntity entity = new KKThrowableEntity(level);
                    switch (ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_()).m_135815_()) {
                        case "retribution": {
                            entity.setRotationPoint(0);
                            break;
                        }
                        default: {
                            entity.setRotationPoint(1);
                        }
                    }
                    entity.setData(DamageCalculation.getKBStrengthDamage(player, itemstack) * 0.7f, player.m_20148_(), slot, itemstack);
                    entity.m_6034_(player.m_20182_().f_82479_, player.m_146892_().f_82480_, player.m_20182_().f_82481_);
                    entity.m_20088_().m_135381_(KKThrowableEntity.ITEMSTACK, (Object)itemstack);
                    entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 0.0f);
                    level.m_7967_((Entity)entity);
                    player.m_36335_().m_41524_(itemstack.m_41720_(), 15);
                } else {
                    player.m_6674_(slot == 40 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                }
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
        } else if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() instanceof KeybladeItem) {
            if (world.f_46443_ && !player.m_21206_().m_41619_() && player.m_21206_().m_41720_() instanceof KeybladeItem) {
                HitResult rtr;
                Item item = player.m_21206_().m_41720_();
                if (item instanceof IExtendedReach) {
                    IExtendedReach item2 = (IExtendedReach)item;
                    v1 = InputHandler.getMouseOverExtended(item2.getReach());
                } else {
                    v1 = rtr = Minecraft.m_91087_().f_91077_;
                }
                if (rtr != null) {
                    if (rtr.m_6662_() == HitResult.Type.ENTITY) {
                        EntityHitResult ertr = (EntityHitResult)rtr;
                        if (!ItemStack.m_41728_((ItemStack)player.m_21120_(InteractionHand.OFF_HAND), (ItemStack)ItemStack.f_41583_) && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof KeybladeItem && hand == InteractionHand.OFF_HAND) {
                            if (ertr.m_82443_() != null) {
                                PacketHandler.sendToServer(new CSAttackOffhandPacket(ertr.m_82443_().m_19879_()));
                                return InteractionResultHolder.m_19090_((Object)itemstack);
                            }
                            return InteractionResultHolder.m_19100_((Object)itemstack);
                        }
                    } else {
                        player.m_6674_(InteractionHand.OFF_HAND);
                    }
                }
            }
        } else if (playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
            player.m_6674_(hand);
            if (!world.f_46443_) {
                ArrowgunShotEntity shot = new ArrowgunShotEntity(player.m_9236_(), (LivingEntity)player, DamageCalculation.getMagicDamage(player) * 0.1f);
                shot.setShotType(1);
                shot.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 0.0f);
                world.m_7967_((Entity)shot);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.wisdom_shot.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (ModConfigs.keybladeOpenDoors) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            Player player = context.m_43723_();
            if (world.m_8055_(pos).m_60734_() instanceof DoorBlock) {
                SoundEvent sound;
                DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)world.m_8055_(pos).m_61143_((Property)DoorBlock.f_52730_);
                if (doubleblockhalf == DoubleBlockHalf.UPPER) {
                    world.m_46597_(pos.m_7495_(), (BlockState)world.m_8055_(pos.m_7495_()).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)world.m_8055_(pos.m_7495_()).m_61143_((Property)DoorBlock.f_52727_) == false)));
                    sound = (Boolean)world.m_8055_(pos.m_7495_()).m_61143_((Property)DoorBlock.f_52727_) != false ? SoundEvents.f_12055_ : SoundEvents.f_12056_;
                } else {
                    world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)world.m_8055_(pos).m_61143_((Property)DoorBlock.f_52727_) == false)));
                    sound = (Boolean)world.m_8055_(pos).m_61143_((Property)DoorBlock.f_52727_) != false ? SoundEvents.f_12055_ : SoundEvents.f_12056_;
                }
                world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (world.m_8055_(pos).m_60734_() instanceof TrapDoorBlock) {
                world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf((Boolean)world.m_8055_(pos).m_61143_((Property)TrapDoorBlock.f_57514_) == false)));
                SoundEvent sound = (Boolean)world.m_8055_(pos).m_61143_((Property)TrapDoorBlock.f_57514_) != false ? SoundEvents.f_12055_ : SoundEvents.f_12056_;
                world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.data != null) {
            tooltip = ClientUtils.getTooltip(tooltip, stack);
            if (this.recipe != null) {
                for (Map.Entry<Item, Integer> mat : this.recipe.getMaterials().entrySet()) {
                    tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(new ItemStack((ItemLike)mat.getKey()).m_41786_()) + " x" + String.valueOf(mat.getValue()))));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "KEYBLADE DATA MISSING")));
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "If you see this then either the keyblade json is missing or failed to load")));
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "It should be located in data/" + key.m_135827_() + "/keyblades/" + key.m_135815_() + ".json")));
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "If the file exists check the syntax, see builtin keyblades for examples")));
        }
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128403_("keybladeID")) {
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.WHITE) + stack.m_41783_().m_128342_("keybladeID").toString())));
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.TOOL;
    }

    @Override
    public float getReach() {
        return this.data.getReach();
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    @Mod.EventBusSubscriber
    public static class KeybladeEvents {
        @SubscribeEvent
        public static void onItemToss(ItemTossEvent event) {
            ItemStack droppedItem = event.getEntity().m_32055_();
            UUID droppedID = Utils.getKeybladeID(droppedItem);
            if (droppedID != null && droppedItem.m_41720_() instanceof KeybladeItem) {
                Utils.summonKeyblade(event.getPlayer(), true, null);
            }
        }

        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemEntity iEntity;
            ItemStack droppedItem;
            UUID droppedID;
            Entity entity = event.getEntity();
            if (entity instanceof ItemEntity && (droppedID = Utils.getKeybladeID(droppedItem = (iEntity = (ItemEntity)entity).m_32055_())) != null && droppedItem.m_41720_() instanceof KeybladeItem) {
                iEntity.m_9236_().m_6263_(null, iEntity.m_20182_().m_7096_(), iEntity.m_20182_().m_7098_(), iEntity.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

