/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.container.PauldronContainer;
import online.kingdomkeys.kingdomkeys.container.PauldronInventory;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class PauldronItem
extends Item
implements IItemCategory {
    String textureName;
    Item[] items;

    public PauldronItem(Item.Properties properties, String textureName, Item[] items) {
        super(properties);
        this.textureName = textureName;
        this.items = items;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(player)), (ServerPlayer)player);
            SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new PauldronContainer(w, p, stack), stack.m_41786_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.m_41783_() != null) {
            if (!stack.m_41783_().m_128403_("armorID")) {
                stack.m_41751_(this.setID(stack.m_41783_()));
            }
        } else {
            stack.m_41751_(this.setID(new CompoundTag()));
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public CompoundTag setID(CompoundTag nbt) {
        nbt.m_128362_("armorID", UUID.randomUUID());
        return nbt;
    }

    public Rarity m_41460_(ItemStack pStack) {
        if (pStack.m_41783_() == null) {
            return super.m_41460_(pStack);
        }
        if (pStack.m_41783_().m_128423_("boots") != null || pStack.m_41783_().m_128423_("leggings") != null || pStack.m_41783_().m_128423_("chestplate") != null || pStack.m_41783_().m_128423_("helmet") != null) {
            return Rarity.EPIC;
        }
        return super.m_41460_(pStack);
    }

    public boolean m_5812_(ItemStack pStack) {
        return this.m_41460_(pStack) == Rarity.EPIC;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.EQUIPMENT;
    }

    public String getTextureName() {
        return this.textureName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            if (!iItemHandler.getStackInSlot(0).m_41619_()) {
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"kingdomkeys.helmet").getString() + ": " + iItemHandler.getStackInSlot(0).m_41786_().getString())));
            }
            if (!iItemHandler.getStackInSlot(1).m_41619_()) {
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"kingdomkeys.chestplate").getString() + ": " + iItemHandler.getStackInSlot(1).m_41786_().getString())));
            }
            if (!iItemHandler.getStackInSlot(2).m_41619_()) {
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"kingdomkeys.leggings").getString() + ": " + iItemHandler.getStackInSlot(2).m_41786_().getString())));
            }
            if (!iItemHandler.getStackInSlot(3).m_41619_()) {
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"kingdomkeys.boots").getString() + ": " + iItemHandler.getStackInSlot(3).m_41786_().getString())));
            }
        });
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128403_("armorID")) {
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.WHITE) + stack.m_41783_().m_128342_("armorID").toString())));
        }
    }

    public Item getArmor(int slot) {
        return this.items[slot];
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return this.m_5812_(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PauldronInventory();
    }
}

