/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;

public class Party {
    private String name;
    private List<Member> members = new ArrayList<Member>();
    private boolean priv;
    private byte size;
    private boolean friendlyFire;

    public Party() {
    }

    public Party(String name, UUID leaderId, String username, boolean priv, byte size) {
        this.name = name;
        this.addMember(leaderId, username).setIsLeader(true);
        this.priv = priv;
        this.size = size;
        this.friendlyFire = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPriv(boolean priv) {
        this.priv = priv;
    }

    public boolean getPriv() {
        return this.priv;
    }

    public void setSize(byte size) {
        this.size = size;
    }

    public byte getSize() {
        return this.size;
    }

    public void setFriendlyFire(boolean ff) {
        this.friendlyFire = ff;
    }

    public boolean getFriendlyFire() {
        return this.friendlyFire;
    }

    public Member addMember(LivingEntity entity) {
        return this.addMember(entity.m_20148_(), entity.m_5446_().getString());
    }

    public Member addMember(UUID uuid, String username) {
        Member member = new Member(uuid, username);
        this.members.add(member);
        return member;
    }

    public Member addMember(UUID uuid, String username, int lvl, int hp, int mp) {
        Member member = new Member(uuid, username);
        member.setHP(hp);
        member.setMP(mp);
        member.setLevel(lvl);
        this.members.add(member);
        return member;
    }

    public void removeMember(UUID id) {
        Member member = this.getMember(id);
        if (member.isLeader()) {
            this.members.removeAll(this.members);
        } else {
            this.members.remove(member);
        }
    }

    public Member getMember(UUID id) {
        return this.members.stream().filter(member -> member.getUUID().equals(id)).findFirst().orElse(null);
    }

    public boolean hasMember(UUID id) {
        return this.getMember(id) != null;
    }

    @Nullable
    public List<Member> getLeaders() {
        return this.members.stream().filter(member -> member.isLeader()).toList();
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public int getMemberIndex(UUID memberUUID) {
        int i = 0;
        for (i = 0; i < this.members.size(); ++i) {
            if (!this.members.get(i).getUUID().equals(memberUUID)) continue;
            return i;
        }
        return -1;
    }

    public CompoundTag write() {
        CompoundTag partyNBT = new CompoundTag();
        partyNBT.m_128359_("name", this.getName());
        partyNBT.m_128379_("private", this.priv);
        partyNBT.m_128344_("size", this.size);
        partyNBT.m_128379_("ff", this.friendlyFire);
        ListTag members = new ListTag();
        for (Member member : this.getMembers()) {
            CompoundTag memberNBT = new CompoundTag();
            memberNBT.m_128362_("id", member.getUUID());
            memberNBT.m_128359_("username", member.getUsername());
            memberNBT.m_128379_("isLeader", member.isLeader());
            memberNBT.m_128405_("level", member.getLevel());
            memberNBT.m_128405_("hp", member.getHP());
            memberNBT.m_128405_("mp", member.getMP());
            members.add((Object)memberNBT);
        }
        partyNBT.m_128365_("members", (Tag)members);
        return partyNBT;
    }

    public void read(CompoundTag nbt) {
        this.setName(nbt.m_128461_("name"));
        this.setPriv(nbt.m_128471_("private"));
        this.setSize(nbt.m_128445_("size"));
        this.setFriendlyFire(nbt.m_128471_("ff"));
        ListTag members = nbt.m_128437_("members", 10);
        for (int j = 0; j < members.size(); ++j) {
            CompoundTag memberNBT = members.m_128728_(j);
            Member member = this.addMember(memberNBT.m_128342_("id"), memberNBT.m_128461_("username"), memberNBT.m_128451_("level"), memberNBT.m_128451_("hp"), memberNBT.m_128451_("mp"));
            member.setIsLeader(memberNBT.m_128471_("isLeader"));
        }
    }

    public static class Member {
        private UUID uuid;
        private String username;
        private boolean isLeader;
        private int level;
        private int hp;
        private int mp;

        public int getLevel() {
            return this.level;
        }

        public Member setLevel(int level) {
            this.level = level;
            return this;
        }

        public int getHP() {
            return this.hp;
        }

        public Member setHP(int hp) {
            this.hp = hp;
            return this;
        }

        public int getMP() {
            return this.mp;
        }

        public Member setMP(int mp) {
            this.mp = mp;
            return this;
        }

        public Member(LivingEntity entity) {
            this(entity.m_20148_(), entity.m_5446_().getString());
        }

        public Member(UUID uuid, String username) {
            this.uuid = uuid;
            this.username = username;
        }

        public Member setIsLeader(boolean leader) {
            this.isLeader = leader;
            return this;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

