/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.magic.MagicData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public abstract class Magic {
    ResourceLocation name;
    boolean hasTargetSelector;
    int maxLevel;
    String translationKey;
    String gmAbility;
    private MagicData data;

    public Magic(ResourceLocation registryName, boolean hasToSelect, int maxLevel, String gmAbility) {
        this.name = registryName;
        this.hasTargetSelector = hasToSelect;
        this.maxLevel = maxLevel - 1;
        this.gmAbility = gmAbility;
        this.translationKey = "magic." + registryName.m_135827_() + "." + registryName.m_135815_() + ".name";
    }

    public int getCasttimeTicks(int level) {
        return this.data.getCasttime(level);
    }

    public String getTranslationKey() {
        return this.getTranslationKey(0);
    }

    public String getTranslationKey(int level) {
        return this.translationKey.replace(".name", level + ".name");
    }

    public double getCost(int lvl, Player player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        double cost = this.data.getCost(lvl);
        if (cost != 300.0) {
            cost -= cost * (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_thrift") * 0.2;
        }
        return Math.max(1.0, cost);
    }

    public float getDamageMult(int lvl) {
        return this.data.getDmgMult(lvl);
    }

    public boolean getHasToSelect() {
        return this.hasTargetSelector;
    }

    public boolean getMagicLockOn(int lvl) {
        return this.data.getMagicLockOn(lvl);
    }

    public Ability getGMAbility() {
        if (this.gmAbility == null) {
            return null;
        }
        return (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(this.gmAbility));
    }

    public MagicData getMagicData() {
        return this.data;
    }

    public void setMagicData(MagicData data) {
        this.data = data;
    }

    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
    }

    public final void onUse(Player player, Player caster, int level, LivingEntity lockOnEntity) {
        double num;
        IPlayerCapabilities casterData = ModCapabilities.getPlayer(caster);
        float fullMPBlastMult = casterData.isAbilityEquipped("kingdomkeys:ability_full_mp_blast") && casterData.getMP() >= casterData.getMaxMP() ? 1.5f : 1.0f;
        int maxLevel = casterData.getMagicLevel(this.name);
        if (level > maxLevel) {
            casterData.setMagicUses(this.name, 0);
        } else {
            casterData.addMagicUses(this.name, 1);
            casterData.remMP(this.getCost(level, player));
            if (this.getMagicData() != null && this.getRCProb(casterData)) {
                if (this.getGMAbility() != null || level != this.getMaxLevel()) {
                    casterData.addReactionCommand("kingdomkeys:" + this.getRegistryName().m_135815_(), caster);
                }
                casterData.setMagicUses(this.name, 0);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(casterData), (ServerPlayer)caster);
            }
        }
        int cd = (int)((double)this.data.getCooldown(level) * (1.0 - (double)casterData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_endless_magic") * 0.2));
        casterData.setMagicCooldownTicks(Math.max(cd, 5));
        if (casterData.isAbilityEquipped("kingdomkeys:ability_wizards_ruse") && (num = player.m_9236_().f_46441_.m_188500_()) < 0.25 + 0.125 * (double)(casterData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_wizards_ruse") - 1)) {
            caster.m_5634_((float)((int)this.getCost(level, player) / 2));
        }
        if (!casterData.isAbilityEquipped("kingdomkeys:ability_magic_lock_on")) {
            lockOnEntity = null;
        }
        this.playMagicCastSound(player, caster, level);
        Utils.castMagic cast = new Utils.castMagic(player, caster, level, fullMPBlastMult, lockOnEntity, this);
        casterData.setCastedMagic(cast);
        PacketHandler.sendTo(new SCSyncCapabilityPacket(casterData), (ServerPlayer)caster);
    }

    protected abstract void playMagicCastSound(Player var1, Player var2, int var3);

    private boolean getRCProb(IPlayerCapabilities casterData) {
        double num;
        int prob = casterData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_grand_magic_haste") * 10;
        if (this.gmAbility != null && casterData.isAbilityEquipped(this.gmAbility) && casterData.getMagicLevel(this.getRegistryName()) == this.getMaxLevel()) {
            prob += casterData.getNumberOfAbilitiesEquipped(this.gmAbility) * 10;
        }
        return (num = Math.random() * 100.0) <= (double)(prob += (casterData.getMagicUses(this.name) - 1) * 5);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

