/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenEquipmentScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSEquipAccessories {
    int slotToEquipTo;
    int slotToEquipFrom;

    public CSEquipAccessories() {
    }

    public CSEquipAccessories(int slotToEquipTo, int slotToEquipFrom) {
        this.slotToEquipTo = slotToEquipTo;
        this.slotToEquipFrom = slotToEquipFrom;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotToEquipTo);
        buffer.writeInt(this.slotToEquipFrom);
    }

    public static CSEquipAccessories decode(FriendlyByteBuf buffer) {
        CSEquipAccessories msg = new CSEquipAccessories();
        msg.slotToEquipTo = buffer.readInt();
        msg.slotToEquipFrom = buffer.readInt();
        return msg;
    }

    public static void handle(CSEquipAccessories message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IPlayerCapabilities playerData;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!MinecraftForge.EVENT_BUS.post((Event)new EquipmentEvent.Accessory((Player)player, (playerData = ModCapabilities.getPlayer((Player)player)).getEquippedAccessory(message.slotToEquipTo), player.m_150109_().m_8020_(message.slotToEquipFrom), message.slotToEquipFrom, message.slotToEquipTo))) {
                int oldItemAP = 0;
                int newItemAP = 0;
                if (!ItemStack.m_41728_((ItemStack)playerData.getEquippedAccessory(message.slotToEquipTo), (ItemStack)ItemStack.f_41583_)) {
                    oldItemAP = ((KKAccessoryItem)playerData.getEquippedAccessory(message.slotToEquipTo).m_41720_()).getAp();
                }
                if (!ItemStack.m_41728_((ItemStack)player.m_150109_().m_8020_(message.slotToEquipFrom), (ItemStack)ItemStack.f_41583_)) {
                    newItemAP = ((KKAccessoryItem)player.m_150109_().m_8020_(message.slotToEquipFrom).m_41720_()).getAp();
                }
                if (playerData.getMaxAP(true) - oldItemAP + newItemAP >= Utils.getConsumedAP(playerData)) {
                    ItemStack stackToEquip = player.m_150109_().m_8020_(message.slotToEquipFrom);
                    ItemStack stackPreviouslyEquipped = playerData.equipAccessory(message.slotToEquipTo, stackToEquip);
                    player.m_150109_().m_6836_(message.slotToEquipFrom, stackPreviouslyEquipped);
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                PacketHandler.sendTo(new SCOpenEquipmentScreen(), player);
                Utils.RefreshAbilityAttributes((Player)player, playerData);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

