/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSStruggleSettings {
    String name;
    byte size;
    int dmgMult;
    BlockPos pos;
    BlockPos c1;
    BlockPos c2;

    public CSStruggleSettings() {
    }

    public CSStruggleSettings(Struggle struggle) {
        this.name = struggle.getName();
        this.size = struggle.getSize();
        this.dmgMult = struggle.getDamageMult();
        this.pos = struggle.getPos();
        this.c1 = struggle.getC1();
        this.c2 = struggle.getC2();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.writeByte((int)this.size);
        buffer.writeInt(this.dmgMult);
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.c1);
        buffer.m_130064_(this.c2);
    }

    public static CSStruggleSettings decode(FriendlyByteBuf buffer) {
        CSStruggleSettings msg = new CSStruggleSettings();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.size = buffer.readByte();
        msg.dmgMult = buffer.readInt();
        msg.pos = buffer.m_130135_();
        msg.c1 = buffer.m_130135_();
        msg.c2 = buffer.m_130135_();
        return msg;
    }

    public static void handle(CSStruggleSettings message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            Struggle p = worldData.getStruggleFromBlockPos(message.pos);
            p.setSize(message.size);
            p.setDamageMult(message.dmgMult);
            p.setName(message.name);
            p.setC1(message.c1);
            p.setC2(message.c2);
            Utils.syncWorldData(player.m_9236_(), worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

