/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.lib.Strings;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowMessagesPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSSynthesiseRecipe {
    ResourceLocation name;

    public CSSynthesiseRecipe() {
    }

    public CSSynthesiseRecipe(ResourceLocation name) {
        this.name = name;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.name);
    }

    public static CSSynthesiseRecipe decode(FriendlyByteBuf buffer) {
        CSSynthesiseRecipe msg = new CSSynthesiseRecipe();
        msg.name = buffer.m_130281_();
        return msg;
    }

    public static void handle(CSSynthesiseRecipe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.m_150109_().m_36062_() > -1) {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
                Recipe recipe = RecipeRegistry.getInstance().getValue(message.name);
                int stacksToGive = Utils.stacksForItemAmount(new ItemStack((ItemLike)recipe.getResult()), recipe.getAmount());
                if (stacksToGive <= Utils.getFreeSlotsForPlayer((Player)player)) {
                    boolean enoughTier;
                    Iterator<Map.Entry<Item, Integer>> it = recipe.getMaterials().entrySet().iterator();
                    boolean hasMaterials = true;
                    boolean enoughMunny = playerData.getMunny() >= recipe.getCost();
                    boolean bl = enoughTier = !ModConfigs.requireSynthTier || playerData.getSynthLevel() >= recipe.getTier();
                    while (it.hasNext()) {
                        Map.Entry<Item, Integer> m = it.next();
                        if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                        hasMaterials = false;
                    }
                    if (hasMaterials && enoughMunny && enoughTier) {
                        playerData.setMunny(playerData.getMunny() - recipe.getCost());
                        playerData.addSynthExperience(10 + recipe.getTier() * 2);
                        for (Map.Entry entry : recipe.getMaterials().entrySet()) {
                            playerData.removeMaterial((Item)entry.getKey(), (Integer)entry.getValue());
                        }
                        Item i = recipe.getResult();
                        ItemStack itemStack = new ItemStack((ItemLike)i);
                        for (int s = 0; s < stacksToGive - 1; ++s) {
                            player.m_150109_().m_36054_(new ItemStack((ItemLike)i, itemStack.m_41741_()));
                        }
                        int remainder = recipe.getAmount() - (stacksToGive - 1) * itemStack.m_41741_();
                        if (remainder > 0) {
                            player.m_150109_().m_36054_(new ItemStack((ItemLike)i, remainder));
                        }
                        if (i instanceof KeychainItem && ModConfigs.heartlessSpawningMode == SpawningMode.AFTER_KEYCHAIN) {
                            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
                            if (worldData.getHeartlessSpawnLevel() == 0) {
                                List<Utils.Title> titles = List.of(new Utils.Title("", Strings.HeartlessIntro1), new Utils.Title("", Strings.HeartlessIntro2), new Utils.Title("", Strings.HeartlessIntro3));
                                PacketHandler.sendToAllPlayers(new SCShowMessagesPacket(titles));
                                Utils.playSoundToEveryone((ServerLevel)player.m_9236_(), SoundEvents.f_12563_, 1.0f, 1.0f);
                            }
                            worldData.setHeartlessSpawnLevel(1);
                            PacketHandler.sendToAllPlayers(new SCSyncWorldCapability(worldData));
                        }
                        playerData.addSynthesisedRecipe(message.name.toString());
                    }
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

