/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;

public class CSUseReactionCommandPacket {
    int index;
    int lockedOnEntity;

    public CSUseReactionCommandPacket() {
    }

    public CSUseReactionCommandPacket(int level, LivingEntity lockedOnEntity) {
        this.index = level;
        this.lockedOnEntity = lockedOnEntity == null ? -1 : lockedOnEntity.m_19879_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.index);
        buffer.writeInt(this.lockedOnEntity);
    }

    public static CSUseReactionCommandPacket decode(FriendlyByteBuf buffer) {
        CSUseReactionCommandPacket msg = new CSUseReactionCommandPacket();
        msg.index = buffer.readInt();
        msg.lockedOnEntity = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseReactionCommandPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            String reactionName = playerData.getReactionCommands().get(message.index);
            ReactionCommand reaction = (ReactionCommand)ModReactionCommands.registry.get().getValue(new ResourceLocation(reactionName));
            reaction.onUse((Player)player, (LivingEntity)player, (LivingEntity)player.m_9236_().m_6815_(message.lockedOnEntity));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        });
        ctx.get().setPacketHandled(true);
    }
}

