/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.DualChoices;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.SingleChoices;
import online.kingdomkeys.kingdomkeys.leveling.Stat;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SCSyncCapabilityPacket {
    public int level = 0;
    public int exp = 0;
    public int expGiven = 0;
    public Stat strength;
    public Stat magic;
    public Stat defense;
    public Stat maxAP;
    public int maxHp;
    public int munny = 0;
    public int antipoints = 0;
    public double MP;
    public double maxMP;
    public double dp;
    public double maxDP;
    public double fp;
    public double focus;
    public double maxFocus;
    public boolean recharge;
    public List<String> messages;
    public List<String> bfMessages;
    public List<String> dfMessages;
    public String driveForm;
    public SingleChoices singleStyle = SingleChoices.SORA;
    public DualChoices dualStyle = DualChoices.KH2_ROXAS_DUAL;
    public List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();
    public LinkedHashMap<String, int[]> magicsMap = new LinkedHashMap();
    public List<String> shotlockList = new ArrayList<String>();
    public List<String> reactionList = new ArrayList<String>();
    public String equippedShotlock;
    public LinkedHashMap<String, int[]> driveFormMap = new LinkedHashMap();
    public LinkedHashSet<String> visibleDriveForms = new LinkedHashSet();
    public LinkedHashMap<String, int[]> abilityMap = new LinkedHashMap();
    public List<String> partyList = new ArrayList<String>(10);
    public TreeMap<ResourceLocation, Integer> materialMap = new TreeMap();
    public Map<ResourceLocation, ItemStack> keychains = new HashMap<ResourceLocation, ItemStack>();
    public Map<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
    public Map<Integer, ItemStack> accessories = new HashMap<Integer, ItemStack>();
    public Map<Integer, ItemStack> kbArmors = new HashMap<Integer, ItemStack>();
    public Map<Integer, ItemStack> armors = new HashMap<Integer, ItemStack>();
    public int maxAccessories;
    public int maxArmors;
    public SoAState soAstate;
    public SoAState choice;
    public SoAState sacrifice;
    public BlockPos choicePedestal;
    public BlockPos sacrificePedestal;
    public Vec3 returnPos;
    public ResourceKey<Level> returnDim;
    public int hearts;
    public Utils.OrgMember alignment;
    public ItemStack equippedWeapon;
    public Set<ItemStack> unlocks;
    public int limitCooldownTicks;
    public int magicCasttimeTicks;
    public int magicCooldownTicks;
    public LinkedHashMap<Integer, String> shortcutsMap = new LinkedHashMap();
    public int synthLevel;
    public int synthExp;
    private int armorColor = 0;
    private boolean armorGlint = true;
    public boolean respawnROD;
    public Set<String> synthesisedRecipes = new HashSet<String>();

    public SCSyncCapabilityPacket() {
    }

    public SCSyncCapabilityPacket(IPlayerCapabilities capability) {
        this.level = capability.getLevel();
        this.exp = capability.getExperience();
        this.expGiven = capability.getExperienceGiven();
        this.strength = capability.getStrengthStat();
        this.magic = capability.getMagicStat();
        this.defense = capability.getDefenseStat();
        this.maxAP = capability.getMaxAPStat();
        this.MP = capability.getMP();
        this.maxMP = capability.getMaxMP();
        this.recharge = capability.getRecharge();
        this.maxHp = capability.getMaxHP();
        this.dp = capability.getDP();
        this.maxDP = capability.getMaxDP();
        this.fp = capability.getFP();
        this.antipoints = capability.getAntiPoints();
        this.munny = capability.getMunny();
        this.focus = capability.getFocus();
        this.maxFocus = capability.getMaxFocus();
        this.recipeList = new ArrayList<ResourceLocation>(capability.getKnownRecipeList());
        this.magicsMap = new LinkedHashMap<String, int[]>(capability.getMagicsMap());
        this.shotlockList = new ArrayList<String>(capability.getShotlockList());
        this.equippedShotlock = capability.getEquippedShotlock();
        this.driveFormMap = new LinkedHashMap<String, int[]>(capability.getDriveFormMap());
        this.abilityMap = new LinkedHashMap<String, int[]>(capability.getAbilityMap());
        this.partyList = new ArrayList<String>(capability.getPartiesInvited());
        this.materialMap = new TreeMap<ResourceLocation, Integer>((SortedMap<ResourceLocation, Integer>)capability.getMaterialMap());
        this.keychains = capability.getEquippedKeychains();
        this.items = new HashMap<Integer, ItemStack>(capability.getEquippedItems());
        this.accessories = new HashMap<Integer, ItemStack>(capability.getEquippedAccessories());
        this.kbArmors = new HashMap<Integer, ItemStack>(capability.getEquippedKBArmors());
        this.armors = new HashMap<Integer, ItemStack>(capability.getEquippedArmors());
        this.maxAccessories = capability.getMaxAccessories();
        this.maxArmors = capability.getMaxArmors();
        this.messages = capability.getMessages();
        this.bfMessages = capability.getBFMessages();
        this.dfMessages = capability.getDFMessages();
        this.soAstate = capability.getSoAState();
        this.choice = capability.getChosen();
        this.choicePedestal = capability.getChoicePedestal();
        this.sacrifice = capability.getSacrificed();
        this.sacrificePedestal = capability.getSacrificePedestal();
        this.driveForm = capability.getActiveDriveForm();
        this.returnPos = capability.getReturnLocation();
        this.returnDim = capability.getReturnDimension();
        this.hearts = capability.getHearts();
        this.alignment = capability.getAlignment();
        this.equippedWeapon = capability.getEquippedWeapon();
        this.unlocks = capability.getWeaponsUnlocked();
        this.limitCooldownTicks = capability.getLimitCooldownTicks();
        this.magicCasttimeTicks = capability.getMagicCasttimeTicks();
        this.magicCooldownTicks = capability.getMagicCooldownTicks();
        this.reactionList = capability.getReactionCommands();
        this.shortcutsMap = capability.getShortcutsMap();
        this.synthLevel = capability.getSynthLevel();
        this.synthExp = capability.getSynthExperience();
        this.respawnROD = capability.getRespawnROD();
        this.singleStyle = capability.getSingleStyle();
        this.dualStyle = capability.getDualStyle();
        this.synthesisedRecipes = capability.getSynthesisedRecipes();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.level);
        buffer.writeInt(this.exp);
        buffer.writeInt(this.expGiven);
        buffer.m_130079_(this.strength.serialize(new CompoundTag()));
        buffer.m_130079_(this.magic.serialize(new CompoundTag()));
        buffer.m_130079_(this.defense.serialize(new CompoundTag()));
        buffer.m_130079_(this.maxAP.serialize(new CompoundTag()));
        buffer.writeDouble(this.MP);
        buffer.writeDouble(this.maxMP);
        buffer.writeBoolean(this.recharge);
        buffer.writeInt(this.maxHp);
        buffer.writeDouble(this.dp);
        buffer.writeDouble(this.maxDP);
        buffer.writeDouble(this.fp);
        buffer.writeInt(this.antipoints);
        buffer.writeInt(this.munny);
        buffer.writeDouble(this.focus);
        buffer.writeDouble(this.maxFocus);
        CompoundTag recipes = new CompoundTag();
        for (ResourceLocation resourceLocation : this.recipeList) {
            recipes.m_128359_(resourceLocation.toString(), resourceLocation.toString());
        }
        buffer.m_130079_(recipes);
        CompoundTag magics = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.magicsMap.entrySet()) {
            magics.m_128385_(entry.getKey().toString(), entry.getValue());
        }
        buffer.m_130079_(magics);
        CompoundTag compoundTag = new CompoundTag();
        for (String s : this.shotlockList) {
            compoundTag.m_128405_(s, 1);
        }
        buffer.m_130079_(compoundTag);
        buffer.m_130072_(this.equippedShotlock, 100);
        CompoundTag forms = new CompoundTag();
        for (Map.Entry<String, int[]> pair : this.driveFormMap.entrySet()) {
            forms.m_128385_(pair.getKey().toString(), pair.getValue());
        }
        buffer.m_130079_(forms);
        CompoundTag visibleForms = new CompoundTag();
        for (String formName : this.visibleDriveForms) {
            visibleForms.m_128359_(formName, "");
        }
        buffer.m_130079_(visibleForms);
        CompoundTag abilities = new CompoundTag();
        for (Map.Entry<String, int[]> pair : this.abilityMap.entrySet()) {
            abilities.m_128385_(pair.getKey().toString(), pair.getValue());
        }
        buffer.m_130079_(abilities);
        CompoundTag keychains = new CompoundTag();
        this.keychains.forEach((key, value) -> keychains.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(keychains);
        CompoundTag items = new CompoundTag();
        this.items.forEach((key, value) -> items.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(items);
        CompoundTag accessories = new CompoundTag();
        this.accessories.forEach((key, value) -> accessories.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(accessories);
        CompoundTag kbArmors = new CompoundTag();
        this.kbArmors.forEach((key, value) -> kbArmors.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(kbArmors);
        CompoundTag armors = new CompoundTag();
        this.armors.forEach((key, value) -> armors.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(armors);
        buffer.writeInt(this.maxAccessories);
        buffer.writeInt(this.maxArmors);
        buffer.writeInt(this.partyList.size());
        for (String string : this.partyList) {
            buffer.writeInt(string.length());
            buffer.m_130070_(string);
        }
        CompoundTag materials = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.materialMap.entrySet()) {
            materials.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
            if (materials.m_128451_(entry.getKey().toString()) != 0) continue;
            materials.m_128473_(entry.getKey().toString());
        }
        buffer.m_130079_(materials);
        buffer.writeInt(this.messages.size());
        buffer.writeInt(this.bfMessages.size());
        buffer.writeInt(this.dfMessages.size());
        for (String string : this.messages) {
            buffer.m_130070_(string);
        }
        for (String string : this.bfMessages) {
            buffer.m_130070_(string);
        }
        for (String string : this.dfMessages) {
            buffer.m_130070_(string);
        }
        buffer.writeInt(this.driveForm.length());
        buffer.m_130070_(this.driveForm);
        buffer.m_130085_(this.returnDim.m_135782_());
        buffer.writeDouble(this.returnPos.f_82479_);
        buffer.writeDouble(this.returnPos.f_82480_);
        buffer.writeDouble(this.returnPos.f_82481_);
        buffer.writeByte((int)this.soAstate.get());
        buffer.writeByte((int)this.choice.get());
        buffer.writeByte((int)this.sacrifice.get());
        buffer.m_130064_(this.choicePedestal);
        buffer.m_130064_(this.sacrificePedestal);
        buffer.writeInt(this.hearts);
        buffer.writeInt(this.alignment.ordinal());
        buffer.m_130055_(this.equippedWeapon);
        buffer.writeInt(this.unlocks.size());
        this.unlocks.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        buffer.writeInt(this.limitCooldownTicks);
        buffer.writeInt(this.magicCasttimeTicks);
        buffer.writeInt(this.magicCooldownTicks);
        buffer.writeInt(this.reactionList.size());
        for (String string : this.reactionList) {
            buffer.m_130072_(string, 100);
        }
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<Integer, String> pair : this.shortcutsMap.entrySet()) {
            compoundTag2.m_128359_(pair.getKey().toString(), pair.getValue());
        }
        buffer.m_130079_(compoundTag2);
        buffer.writeInt(this.synthLevel);
        buffer.writeInt(this.synthExp);
        buffer.writeBoolean(this.respawnROD);
        buffer.m_130072_(this.singleStyle.toString(), 20);
        buffer.m_130072_(this.dualStyle.toString(), 20);
        buffer.writeInt(this.synthesisedRecipes.size());
        for (String s : this.synthesisedRecipes) {
            buffer.m_130072_(s, 100);
        }
    }

    public static SCSyncCapabilityPacket decode(FriendlyByteBuf buffer) {
        int i;
        SCSyncCapabilityPacket msg = new SCSyncCapabilityPacket();
        msg.level = buffer.readInt();
        msg.exp = buffer.readInt();
        msg.expGiven = buffer.readInt();
        msg.strength = Stat.deserializeNBT("strength", buffer.m_130260_());
        msg.magic = Stat.deserializeNBT("magic", buffer.m_130260_());
        msg.defense = Stat.deserializeNBT("defense", buffer.m_130260_());
        msg.maxAP = Stat.deserializeNBT("max_ap", buffer.m_130260_());
        msg.MP = buffer.readDouble();
        msg.maxMP = buffer.readDouble();
        msg.recharge = buffer.readBoolean();
        msg.maxHp = buffer.readInt();
        msg.dp = buffer.readDouble();
        msg.maxDP = buffer.readDouble();
        msg.fp = buffer.readDouble();
        msg.antipoints = buffer.readInt();
        msg.munny = buffer.readInt();
        msg.focus = buffer.readDouble();
        msg.maxFocus = buffer.readDouble();
        CompoundTag recipesTag = buffer.m_130260_();
        for (Object key2 : recipesTag.m_128431_()) {
            msg.recipeList.add(new ResourceLocation((String)key2));
        }
        CompoundTag magicsTag = buffer.m_130260_();
        for (String magicName : magicsTag.m_128431_()) {
            msg.magicsMap.put(magicName, magicsTag.m_128465_(magicName));
        }
        CompoundTag shotlocksTag = buffer.m_130260_();
        msg.shotlockList.addAll(shotlocksTag.m_128431_());
        msg.equippedShotlock = buffer.m_130136_(100);
        CompoundTag driveFormsTag = buffer.m_130260_();
        for (String driveFormName : driveFormsTag.m_128431_()) {
            msg.driveFormMap.put(driveFormName, driveFormsTag.m_128465_(driveFormName));
        }
        CompoundTag visibleDriveForms = buffer.m_130260_();
        msg.visibleDriveForms.addAll(visibleDriveForms.m_128431_());
        CompoundTag abilitiesTag = buffer.m_130260_();
        for (String abilityName : abilitiesTag.m_128431_()) {
            msg.abilityMap.put(abilityName, abilitiesTag.m_128465_(abilityName));
        }
        CompoundTag keychainsNBT = buffer.m_130260_();
        keychainsNBT.m_128431_().forEach(key -> msg.keychains.put(new ResourceLocation(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)keychainsNBT.m_128423_(key)))));
        CompoundTag itemsNBT = buffer.m_130260_();
        itemsNBT.m_128431_().forEach(key -> msg.items.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)itemsNBT.m_128423_(key)))));
        CompoundTag accessoriesNBT = buffer.m_130260_();
        accessoriesNBT.m_128431_().forEach(key -> msg.accessories.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)accessoriesNBT.m_128423_(key)))));
        CompoundTag kbArmorsNBT = buffer.m_130260_();
        kbArmorsNBT.m_128431_().forEach(key -> msg.kbArmors.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)kbArmorsNBT.m_128423_(key)))));
        CompoundTag armorsNBT = buffer.m_130260_();
        armorsNBT.m_128431_().forEach(key -> msg.armors.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)armorsNBT.m_128423_(key)))));
        msg.maxAccessories = buffer.readInt();
        msg.maxArmors = buffer.readInt();
        int amount = buffer.readInt();
        msg.partyList = new ArrayList<String>();
        for (int i2 = 0; i2 < amount; ++i2) {
            int length = buffer.readInt();
            msg.partyList.add(buffer.m_130136_(length));
        }
        CompoundTag materialsTag = buffer.m_130260_();
        for (String matName : materialsTag.m_128431_()) {
            msg.materialMap.put(new ResourceLocation(matName), materialsTag.m_128451_(matName));
        }
        int msgSize = buffer.readInt();
        int bfMsgSize = buffer.readInt();
        int dfMsgSize = buffer.readInt();
        msg.messages = new ArrayList<String>();
        for (i = 0; i < msgSize; ++i) {
            msg.messages.add(buffer.m_130136_(100));
        }
        msg.bfMessages = new ArrayList<String>();
        for (i = 0; i < bfMsgSize; ++i) {
            msg.bfMessages.add(buffer.m_130136_(100));
        }
        msg.dfMessages = new ArrayList<String>();
        for (i = 0; i < dfMsgSize; ++i) {
            msg.dfMessages.add(buffer.m_130136_(100));
        }
        int length = buffer.readInt();
        msg.driveForm = buffer.m_130136_(length);
        msg.returnDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        msg.returnPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        msg.soAstate = SoAState.fromByte(buffer.readByte());
        msg.choice = SoAState.fromByte(buffer.readByte());
        msg.sacrifice = SoAState.fromByte(buffer.readByte());
        msg.choicePedestal = buffer.m_130135_();
        msg.sacrificePedestal = buffer.m_130135_();
        msg.hearts = buffer.readInt();
        msg.alignment = Utils.OrgMember.values()[buffer.readInt()];
        msg.equippedWeapon = buffer.m_130267_();
        msg.unlocks = new HashSet<ItemStack>();
        int unlockSize = buffer.readInt();
        for (int i3 = 0; i3 < unlockSize; ++i3) {
            msg.unlocks.add(buffer.m_130267_());
        }
        msg.limitCooldownTicks = buffer.readInt();
        msg.magicCasttimeTicks = buffer.readInt();
        msg.magicCooldownTicks = buffer.readInt();
        int rSize = buffer.readInt();
        for (int i4 = 0; i4 < rSize; ++i4) {
            msg.reactionList.add(buffer.m_130136_(100));
        }
        CompoundTag shortcutsTag = buffer.m_130260_();
        for (String s : shortcutsTag.m_128431_()) {
            int shortcutPos = Integer.parseInt(s);
            msg.shortcutsMap.put(shortcutPos, shortcutsTag.m_128461_("" + shortcutPos));
        }
        msg.synthLevel = buffer.readInt();
        msg.synthExp = buffer.readInt();
        msg.respawnROD = buffer.readBoolean();
        msg.singleStyle = SingleChoices.valueOf(buffer.m_130136_(20));
        msg.dualStyle = DualChoices.valueOf(buffer.m_130136_(20));
        int recipeSize = buffer.readInt();
        for (int i5 = 0; i5 < recipeSize; ++i5) {
            msg.synthesisedRecipes.add(buffer.m_130136_(100));
        }
        return msg;
    }

    public static void handle(SCSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.syncCapability(message)));
        ctx.get().setPacketHandled(true);
    }
}

