/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.DualChoices;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.SingleChoices;

public class SCSyncCapabilityToAllPacket {
    public Map<Integer, ItemStack> kbArmors = new HashMap<Integer, ItemStack>();
    private String name;
    private String driveForm;
    private int level = 0;
    private int exp = 0;
    private int expGiven = 0;
    private int strength = 0;
    private int magic = 0;
    private int defense = 0;
    private int reflectTicks = 0;
    private int reflectLevel = 0;
    private int antipoints = 0;
    private int maxHP = 20;
    double mp = 0.0;
    double maxMP = 0.0;
    LinkedHashMap<String, int[]> driveFormMap = new LinkedHashMap();
    LinkedHashMap<String, int[]> magicsMap = new LinkedHashMap();
    private double dp = 0.0;
    private double fp = 0.0;
    private int aerialDodgeTicks = 0;
    private boolean isGliding = false;
    private boolean hasJumpedAD = false;
    private int armorColor = 0;
    private int notifColor = 0;
    private boolean armorGlint = true;
    private SingleChoices singleStyle;
    private DualChoices dualStyle;
    private BlockPos airStepPos;

    public SCSyncCapabilityToAllPacket() {
    }

    public SCSyncCapabilityToAllPacket(String name, IPlayerCapabilities capability) {
        this.name = name;
        this.level = capability.getLevel();
        this.exp = capability.getExperience();
        this.expGiven = capability.getExperienceGiven();
        this.strength = capability.getStrength(false);
        this.magic = capability.getMagic(false);
        this.defense = capability.getDefense(false);
        this.driveForm = capability.getActiveDriveForm();
        this.reflectTicks = capability.getReflectTicks();
        this.reflectLevel = capability.getReflectLevel();
        this.fp = capability.getFP();
        this.dp = capability.getDP();
        this.antipoints = capability.getAntiPoints();
        this.maxHP = capability.getMaxHP();
        this.mp = capability.getMP();
        this.maxMP = capability.getMaxMP();
        this.magicsMap = capability.getMagicsMap();
        this.driveFormMap = capability.getDriveFormMap();
        this.isGliding = capability.getIsGliding();
        this.aerialDodgeTicks = capability.getAerialDodgeTicks();
        this.hasJumpedAD = capability.hasJumpedAerialDodge();
        this.kbArmors = capability.getEquippedKBArmors();
        this.notifColor = capability.getNotifColor();
        this.armorColor = capability.getArmorColor();
        this.armorGlint = capability.getArmorGlint();
        this.singleStyle = capability.getSingleStyle();
        this.dualStyle = capability.getDualStyle();
        this.airStepPos = capability.getAirStep();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeInt(this.level);
        buffer.writeInt(this.exp);
        buffer.writeInt(this.expGiven);
        buffer.writeInt(this.strength);
        buffer.writeInt(this.magic);
        buffer.writeInt(this.defense);
        buffer.m_130070_(this.driveForm);
        buffer.writeInt(this.reflectTicks);
        buffer.writeInt(this.reflectLevel);
        buffer.writeDouble(this.dp);
        buffer.writeDouble(this.fp);
        buffer.writeInt(this.antipoints);
        buffer.writeInt(this.maxHP);
        buffer.writeDouble(this.mp);
        buffer.writeDouble(this.maxMP);
        CompoundTag magics = new CompoundTag();
        for (Map.Entry<String, int[]> pair : this.magicsMap.entrySet()) {
            magics.m_128385_(pair.getKey().toString(), pair.getValue());
        }
        buffer.m_130079_(magics);
        CompoundTag forms = new CompoundTag();
        for (Map.Entry<String, int[]> pair : this.driveFormMap.entrySet()) {
            forms.m_128385_(pair.getKey().toString(), pair.getValue());
        }
        buffer.m_130079_(forms);
        buffer.writeBoolean(this.isGliding);
        buffer.writeInt(this.aerialDodgeTicks);
        buffer.writeBoolean(this.hasJumpedAD);
        CompoundTag kbArmors = new CompoundTag();
        this.kbArmors.forEach((key, value) -> kbArmors.m_128365_(key.toString(), (Tag)value.serializeNBT()));
        buffer.m_130079_(kbArmors);
        buffer.writeInt(this.notifColor);
        buffer.writeInt(this.armorColor);
        buffer.writeBoolean(this.armorGlint);
        buffer.m_130072_(this.singleStyle.toString(), 20);
        buffer.m_130072_(this.dualStyle.toString(), 20);
        buffer.m_130064_(this.airStepPos);
    }

    public static SCSyncCapabilityToAllPacket decode(FriendlyByteBuf buffer) {
        SCSyncCapabilityToAllPacket msg = new SCSyncCapabilityToAllPacket();
        msg.name = buffer.m_130277_();
        msg.level = buffer.readInt();
        msg.exp = buffer.readInt();
        msg.expGiven = buffer.readInt();
        msg.strength = buffer.readInt();
        msg.magic = buffer.readInt();
        msg.defense = buffer.readInt();
        msg.driveForm = buffer.m_130277_();
        msg.reflectTicks = buffer.readInt();
        msg.reflectLevel = buffer.readInt();
        msg.dp = buffer.readDouble();
        msg.fp = buffer.readDouble();
        msg.antipoints = buffer.readInt();
        msg.maxHP = buffer.readInt();
        msg.mp = buffer.readDouble();
        msg.maxMP = buffer.readDouble();
        CompoundTag magicsTag = buffer.m_130260_();
        for (String magicName : magicsTag.m_128431_()) {
            msg.magicsMap.put(magicName, magicsTag.m_128465_(magicName));
        }
        CompoundTag driveFormsTag = buffer.m_130260_();
        for (String driveFormName : driveFormsTag.m_128431_()) {
            msg.driveFormMap.put(driveFormName, driveFormsTag.m_128465_(driveFormName));
        }
        msg.isGliding = buffer.readBoolean();
        msg.aerialDodgeTicks = buffer.readInt();
        msg.hasJumpedAD = buffer.readBoolean();
        CompoundTag kbArmorsNBT = buffer.m_130260_();
        kbArmorsNBT.m_128431_().forEach(key -> msg.kbArmors.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)((CompoundTag)kbArmorsNBT.m_128423_(key)))));
        msg.notifColor = buffer.readInt();
        msg.armorColor = buffer.readInt();
        msg.armorGlint = buffer.readBoolean();
        msg.singleStyle = SingleChoices.valueOf(buffer.m_130136_(20));
        msg.dualStyle = DualChoices.valueOf(buffer.m_130136_(20));
        msg.airStepPos = buffer.m_130135_();
        return msg;
    }

    public static void handle(SCSyncCapabilityToAllPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            List list = Minecraft.m_91087_().f_91073_.m_6907_();
            Player player = null;
            for (int i = 0; i < list.size(); ++i) {
                String name = ((AbstractClientPlayer)list.get(i)).m_7755_().getString();
                if (!name.equals(message.name)) continue;
                player = (Player)list.get(i);
            }
            if (player != null) {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                playerData.setLevel(message.level);
                playerData.setExperience(message.exp);
                playerData.setExperienceGiven(message.expGiven);
                playerData.setStrength(message.strength);
                playerData.setMagic(message.magic);
                playerData.setDefense(message.defense);
                playerData.setActiveDriveForm(message.driveForm);
                playerData.setReflectTicks(message.reflectTicks, message.reflectLevel);
                playerData.setDP(message.dp);
                playerData.setFP(message.fp);
                playerData.setAntiPoints(message.antipoints);
                playerData.setMaxHP(message.maxHP);
                playerData.setMP(message.mp);
                playerData.setMaxMP(message.maxMP);
                playerData.setMagicsMap(message.magicsMap);
                playerData.setDriveFormMap(message.driveFormMap);
                playerData.setIsGliding(message.isGliding);
                playerData.setAerialDodgeTicks(message.aerialDodgeTicks);
                playerData.setHasJumpedAerialDodge(message.hasJumpedAD);
                playerData.equipAllKBArmor(message.kbArmors, false);
                playerData.setNotifColor(message.notifColor);
                playerData.setArmorColor(message.armorColor);
                playerData.setArmorGlint(message.armorGlint);
                playerData.setSingleStyle(message.singleStyle);
                playerData.setDualStyle(message.dualStyle);
                playerData.setAirStep(message.airStepPos);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

