/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;

public class SCSyncDimensionLists {
    final Set<ResourceKey<Level>> addedDims;
    final Set<ResourceKey<Level>> removedDims;

    public SCSyncDimensionLists(Set<ResourceKey<Level>> addedDims, Set<ResourceKey<Level>> removedDims) {
        this.addedDims = addedDims;
        this.removedDims = removedDims;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.addedDims.size());
        this.addedDims.forEach(key -> buf.m_130085_(key.m_135782_()));
        buf.m_130130_(this.removedDims.size());
        this.removedDims.forEach(key -> buf.m_130085_(key.m_135782_()));
    }

    public static SCSyncDimensionLists decode(FriendlyByteBuf buf) {
        HashSet<ResourceKey<Level>> addedDims = new HashSet<ResourceKey<Level>>();
        HashSet<ResourceKey<Level>> removedDims = new HashSet<ResourceKey<Level>>();
        int addedSize = buf.m_130242_();
        for (int i = 0; i < addedSize; ++i) {
            ResourceLocation dim = buf.m_130281_();
            addedDims.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim));
        }
        int removedSize = buf.m_130242_();
        for (int i = 0; i < removedSize; ++i) {
            ResourceLocation dim = buf.m_130281_();
            removedDims.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dim));
        }
        return new SCSyncDimensionLists(addedDims, removedDims);
    }

    public static void handle(SCSyncDimensionLists msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                Set levels = player.f_108617_.m_105151_();
                levels.addAll(msg.addedDims);
                msg.removedDims.forEach(levels::remove);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void syncClients(Set<ResourceKey<Level>> addedDims, Set<ResourceKey<Level>> removedDims) {
        PacketHandler.sendToAllPlayers(new SCSyncDimensionLists(addedDims, removedDims));
    }
}

