/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;

public class SCSyncShopData {
    public List<ShopList> list = new LinkedList<ShopList>();

    public SCSyncShopData() {
    }

    public SCSyncShopData(List<ShopList> recipes) {
        this.list = recipes;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.list.size());
        CompoundTag compoundNBT = new CompoundTag();
        for (int i = 0; i < this.list.size(); ++i) {
            compoundNBT.m_128365_("shop" + i, (Tag)this.list.get(i).serializeNBT());
        }
        buffer.m_130079_(compoundNBT);
    }

    public static SCSyncShopData decode(FriendlyByteBuf buffer) {
        SCSyncShopData msg = new SCSyncShopData();
        int size = buffer.readInt();
        CompoundTag compoundNBT = buffer.m_130260_();
        for (int i = 0; i < size; ++i) {
            ShopList r = new ShopList();
            r.deserializeNBT((CompoundTag)compoundNBT.m_128423_("shop" + i));
            msg.list.add(r);
        }
        return msg;
    }

    public static void handle(SCSyncShopData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.syncShopData(message)));
        ctx.get().setPacketHandled(true);
    }
}

