/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import java.util.Map;
import net.minecraft.world.item.Item;
import online.kingdomkeys.kingdomkeys.datagen.init.KeybladeStats;

public class KeybladeLevel {
    private int strength;
    private int magic;
    private Map<Item, Integer> materials;
    private String ability;

    public KeybladeLevel() {
    }

    public KeybladeLevel(KeybladeLevelBuilder keybladeLevelBuilder) {
        if (keybladeLevelBuilder.ability != null) {
            this.ability = keybladeLevelBuilder.ability;
        }
        this.magic = keybladeLevelBuilder.magic;
        this.strength = keybladeLevelBuilder.strength;
        this.materials = keybladeLevelBuilder.materials;
    }

    public void setAbility(String ability) {
        this.ability = ability;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setMaterials(Map<Item, Integer> materials) {
        this.materials = materials;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getStrength() {
        return this.strength;
    }

    public Map<Item, Integer> getMaterialList() {
        return this.materials;
    }

    public KeybladeLevel(int strength, int magic, Map<Item, Integer> materials, String ability) {
        this.strength = strength;
        this.magic = magic;
        this.materials = materials;
        this.ability = ability;
    }

    public String toString() {
        return String.format("KeybladeLevel[strength:%d, magic:%d, materials[%d]]", this.strength, this.magic, this.materials.size());
    }

    public static class KeybladeLevelBuilder {
        private int strength;
        private int magic;
        private Map<Item, Integer> materials;
        private String ability;

        public KeybladeLevelBuilder withStats(int str, int mag) {
            this.strength = str;
            this.magic = mag;
            return this;
        }

        public KeybladeLevelBuilder withAbility(String ability) {
            this.ability = ability;
            return this;
        }

        public KeybladeLevelBuilder withMaterials(KeybladeStats.Recipe recipe) {
            this.materials = recipe.asMap();
            return this;
        }

        public KeybladeLevel build() {
            return new KeybladeLevel(this);
        }
    }
}

