/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategoryRegistry;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;

public class Utils {
    public static final UUID mobLevelHPModifier = UUID.fromString("c86a76af-4615-4f6e-aaab-b1a349bdeb7b");
    public static final UUID mobLevelAttackModifier = UUID.fromString("a8971ed5-c584-4579-82e7-5c823009dec0");
    static final int[] bagCosts = new int[]{10000, 20000, 40000, 80000};

    public static ItemStack getItemInAnyHand(Player player, Item item) {
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() == item) {
            return player.m_21205_();
        }
        if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == item) {
            return player.m_21206_();
        }
        return null;
    }

    public static int getSavepointPercent(int ticks) {
        return Math.round(100.0f - (float)(ticks - 1) / 19.0f * 100.0f);
    }

    public static ItemStack getWhiteMushroomReward() {
        ArrayList<Item> list = new ArrayList<Item>();
        list.add((Item)ModItems.orichalcum.get());
        list.add((Item)ModItems.orichalcumplus.get());
        list.add((Item)ModItems.evanescent_crystal.get());
        list.add((Item)ModItems.illusory_crystal.get());
        Random rand = new Random();
        Item item = (Item)list.get(rand.nextInt(list.size()));
        return new ItemStack((ItemLike)item, rand.nextInt(3) + 1);
    }

    public static int getCheapestDriveCost(IPlayerCapabilities playerData, List<DriveForm> driveFormMap) {
        int min = playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination") ? ((DriveForm)ModDriveForms.ANTI.get()).getDriveCost() : 1000;
        for (DriveForm form : driveFormMap) {
            if (form == null || form.getDriveFormData() == null || form == ModDriveForms.ANTI.get()) continue;
            min = Math.min(form.getDriveCost(), min);
        }
        return min;
    }

    public static double getCheapestMagicCost(LinkedHashMap<String, int[]> magicsMap, Player player) {
        double min = 1000.0;
        for (Map.Entry<String, int[]> magic : magicsMap.entrySet()) {
            Magic m = (Magic)ModMagic.registry.get().getValue(new ResourceLocation(magic.getKey()));
            if (m == null) continue;
            int lvl = magic.getValue()[0];
            min = Math.min(m.getCost(lvl, player), min);
        }
        return min;
    }

    public static void removeEffects(MobEffect effect, LivingEntity entity) {
        if (effect == ModMobEffects.GRAVITY.get() && entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            PacketHandler.sendTo(new SCRecalculateEyeHeight(), player2);
            if (player2.getForcedPose() != null && !ModCapabilities.getPlayer((Player)player2).getIsGliding()) {
                player2.setForcedPose(null);
            }
        }
        if (effect == ModMobEffects.STOP.get()) {
            IGlobalCapabilities globalData = ModCapabilities.getGlobal(entity);
            if (entity instanceof Mob) {
                ((Mob)entity).m_21557_(false);
            }
            ArrayList<Float> realDamage = new ArrayList<Float>();
            for (int i = 0; i < globalData.getStopDamage().size(); ++i) {
                if (i % 2 != 0) continue;
                realDamage.add(globalData.getStopDamage().get(i));
            }
            globalData.setStopDamage(realDamage);
            if (entity instanceof ServerPlayer) {
                PacketHandler.sendTo(new SCSyncGlobalCapabilityPacket(globalData), (ServerPlayer)entity);
            }
        }
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (effect != null) {
            entity.m_9236_().m_7654_().m_6846_().m_11314_().forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundRemoveMobEffectPacket(entity.m_19879_(), effect)));
        }
    }

    public static List<Component> getResistancesStats(ItemStack selectedItemStack) {
        ArrayList<Component> stats = new ArrayList<Component>();
        int str = 0;
        int mag = 0;
        int ap = 0;
        int def = 0;
        int fireRes = 0;
        int iceRes = 0;
        int thunderRes = 0;
        int lightRes = 0;
        int darkRes = 0;
        Item item = selectedItemStack.m_41720_();
        if (item instanceof KeybladeItem) {
            KeybladeItem kb = (KeybladeItem)item;
            str = kb.getStrength(0);
            mag = kb.getMagic(0);
        } else {
            item = selectedItemStack.m_41720_();
            if (item instanceof KKAccessoryItem) {
                KKAccessoryItem accessory = (KKAccessoryItem)item;
                str = accessory.getStr();
                mag = accessory.getMag();
                ap = accessory.getAp();
            } else {
                item = selectedItemStack.m_41720_();
                if (item instanceof KKArmorItem) {
                    KKArmorItem armor = (KKArmorItem)item;
                    def = armor.getDefense();
                    for (Map.Entry resistanceType : armor.getResList().entrySet()) {
                        switch ((KKResistanceType)((Object)resistanceType.getKey())) {
                            case fire: {
                                fireRes = (Integer)resistanceType.getValue();
                                break;
                            }
                            case ice: {
                                iceRes = (Integer)resistanceType.getValue();
                                break;
                            }
                            case lightning: {
                                thunderRes = (Integer)resistanceType.getValue();
                                break;
                            }
                            case light: {
                                lightRes = (Integer)resistanceType.getValue();
                                break;
                            }
                            case darkness: {
                                darkRes = (Integer)resistanceType.getValue();
                            }
                        }
                    }
                }
            }
        }
        if (ap != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + ap)).m_130940_(ChatFormatting.YELLOW));
        }
        if (str != 0 || selectedItemStack.m_41720_() instanceof KeybladeItem) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + str)).m_130940_(ChatFormatting.DARK_RED));
        }
        if (mag != 0 || selectedItemStack.m_41720_() instanceof KeybladeItem) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + mag)).m_130940_(ChatFormatting.BLUE));
        }
        if (def != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.defense", new Object[0]) + ": " + def)).m_130940_(ChatFormatting.WHITE));
        }
        if (fireRes != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.fireresshort", new Object[0]) + ": " + fireRes + "%")).m_130940_(ChatFormatting.RED));
        }
        if (iceRes != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.blizzardresshort", new Object[0]) + ": " + iceRes + "%")).m_130940_(ChatFormatting.AQUA));
        }
        if (thunderRes != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.thunderresshort", new Object[0]) + ": " + thunderRes + "%")).m_130940_(ChatFormatting.YELLOW));
        }
        if (lightRes != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.lightresshort", new Object[0]) + ": " + lightRes + "%")).m_130940_(ChatFormatting.GRAY));
        }
        if (darkRes != 0) {
            stats.add((Component)Component.m_237113_((String)(Utils.translateToLocal("gui.menu.status.darkresshort", new Object[0]) + ": " + darkRes + "%")).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return stats;
    }

    public static ResourceLocation getItemRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getBlockRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static float map(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static int getSlotFor(Inventory inv, ItemStack stack) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_() || !ItemStack.m_41728_((ItemStack)stack, (ItemStack)inv.m_8020_(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNumber(char c) {
        try {
            Integer.parseInt(String.valueOf(c));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getInt(String num) {
        try {
            int number = Integer.parseInt(num);
            return number;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static double getDouble(String num) {
        try {
            double number = Double.parseDouble(num);
            return number;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int randomWithRange(int min, int max) {
        int range = Math.abs(max - min) + 1;
        return (int)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static double randomWithRange(double min, double max) {
        double range = Math.abs(max - min);
        return Math.random() * range + Math.min(min, max);
    }

    public static float randomWithRange(float min, float max) {
        float range = Math.abs(max - min) + 1.0f;
        return (float)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static String translateToLocalFormatted(String name, Object ... format) {
        MutableComponent translation = Component.m_237110_((String)name, (Object[])format);
        return translation.getString();
    }

    public static String translateToLocal(String name, Object ... args) {
        MutableComponent translation = Component.m_237110_((String)name, (Object[])args);
        return translation.getString();
    }

    public static ItemStack getWeaponDamageStack(DamageSource damageSource, Player player) {
        switch (damageSource.m_19385_()) {
            case "player": {
                if ((player.m_21205_() == null || !(player.m_21205_().m_41720_() instanceof KeybladeItem)) && !(player.m_21205_().m_41720_() instanceof IOrgWeapon)) break;
                return player.m_21205_();
            }
            case "offhand": {
                if ((player.m_21206_() == null || !(player.m_21206_().m_41720_() instanceof KeybladeItem)) && !(player.m_21206_().m_41720_() instanceof IOrgWeapon)) break;
                return player.m_21206_();
            }
        }
        return null;
    }

    public static int getDriveFormLevel(Map<String, int[]> map, String driveForm) {
        if (map.get(driveForm) == null) {
            KingdomKeys.LOGGER.error("The drive form map doesn't contain " + driveForm);
            return 0;
        }
        if (driveForm.equals("kingdomkeys:form_anti")) {
            return 7;
        }
        return map.get(driveForm)[0];
    }

    public static LinkedHashMap<Item, Integer> getSortedMaterials(Map<Item, Integer> materials) {
        ArrayList<Item> list = new ArrayList<Item>(materials.keySet());
        list.sort(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)));
        LinkedHashMap<Item, Integer> map = new LinkedHashMap<Item, Integer>();
        for (Item k : list) {
            map.put(k, materials.get(k));
        }
        return map;
    }

    public static LinkedHashMap<String, int[]> getSortedAbilities(LinkedHashMap<String, int[]> abilities) {
        return abilities.entrySet().stream().sorted((entry, entry2) -> {
            Ability ability = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation((String)entry.getKey()));
            Ability ability2 = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation((String)entry2.getKey()));
            if (ability != null && ability2 != null) {
                return ability.compareTo(ability2);
            }
            return ((String)entry.getKey()).compareTo((String)entry2.getKey());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value, value2) -> value, LinkedHashMap::new));
    }

    public static LinkedHashMap<String, int[]> getSortedDriveForms(LinkedHashMap<String, int[]> driveFormsMap, List<DriveForm> visibleForms) {
        ArrayList<DriveForm> list = new ArrayList<DriveForm>();
        for (String entry : driveFormsMap.keySet()) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(entry));
            if (!visibleForms.contains(form)) continue;
            list.add(form);
        }
        list.sort(Comparator.comparingInt(DriveForm::getOrder));
        LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((DriveForm)list.get(i)).getRegistryName().toString(), driveFormsMap.get(((DriveForm)list.get(i)).getRegistryName().toString()));
        }
        return map;
    }

    public static List<Limit> getPlayerLimitAttacks(Player player) {
        ArrayList<Limit> limits = new ArrayList<Limit>(ModLimits.registry.get().getValues());
        return limits;
    }

    public static List<Limit> getSortedLimits(List<Limit> list) {
        ArrayList<Limit> newList = new ArrayList<Limit>(list);
        newList.sort(Comparator.comparingInt(Limit::getOrder));
        return newList;
    }

    public static List<String> getSortedShotlocks(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>(list);
        newList.sort(Comparator.comparingInt(a -> ((Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(a))).getOrder()));
        return newList;
    }

    public static Player getPlayerByName(Level world, String name) {
        List<Player> players = world.m_7654_() == null ? world.m_6907_() : Utils.getAllPlayers(world.m_7654_());
        for (Player p : players) {
            if (!p.m_5446_().getString().toLowerCase().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static Player getClosestPlayer(Entity e, Level world) {
        Player nearest = null;
        if (e.m_20194_() == null) {
            return null;
        }
        List<Player> players = world == null ? Utils.getAllPlayers(e.m_20194_()) : world.m_6907_();
        for (Player p : players) {
            if (nearest == null) {
                nearest = p;
            }
            if (!(p.m_20270_(e) < nearest.m_20270_(e))) continue;
            nearest = p;
        }
        return nearest;
    }

    public static Player getClosestPlayer(Entity e) {
        return Utils.getClosestPlayer(e, null);
    }

    public static List<Player> getAllPlayers(MinecraftServer ms) {
        ArrayList<Player> list = new ArrayList<Player>();
        for (ServerLevel world : ms.m_129785_()) {
            for (Player p : world.m_6907_()) {
                list.add(p);
            }
        }
        return list;
    }

    public static List<LivingEntity> getLivingEntitiesInRadius(Entity entity, float radius) {
        List list = entity.m_9236_().m_6249_(entity, entity.m_20191_().m_82400_((double)radius), Entity::m_6084_);
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static List<Entity> removePartyMembersFromList(Player player, List<Entity> list) {
        Party casterParty = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.m_9236_().m_46003_(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        return list;
    }

    public static boolean anyPartyMemberOnExcept(Player player, Party p, ServerLevel level) {
        boolean membersOn = false;
        for (Party.Member member : p.getMembers()) {
            if (Utils.getPlayerByName((Level)level, member.getUsername().toLowerCase()) == null || Utils.getPlayerByName((Level)level, member.getUsername().toLowerCase()) == player) continue;
            membersOn = true;
        }
        return membersOn;
    }

    public static List<LivingEntity> getLivingEntitiesInRadiusExcludingParty(Player player, float radius) {
        List list = player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_((double)radius), Entity::m_6084_);
        Party casterParty = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.m_9236_().m_46003_(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static List<LivingEntity> getLivingEntitiesInRadiusExcludingParty(Player player, Entity entity, float radiusX, float radiusY, float radiusZ) {
        List list = player.m_9236_().m_6249_((Entity)player, entity.m_20191_().m_82377_((double)radiusX, (double)radiusY, (double)radiusZ), Entity::m_6084_);
        Party casterParty = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.m_9236_().m_46003_(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        list.remove(entity);
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static String getResourceName(String text) {
        return text.replaceAll("[ \\t]+$", "").replaceAll("\\s+", "_").replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll("\\&", "and").toLowerCase();
    }

    public static void createKeybladeID(ItemStack stack) {
        if (!Utils.hasKeybladeID(stack)) {
            if (stack.m_41783_() == null) {
                stack.m_41751_(new CompoundTag());
            }
            UUID uuid = UUID.randomUUID();
            stack.m_41783_().m_128362_("keybladeID", uuid);
            KingdomKeys.LOGGER.debug("Created new keybladeID:{} for {}", (Object)uuid, (Object)stack.m_41611_().getString());
        }
    }

    public static void copyKeybladeID(ItemStack source, ItemStack destination) {
        if (Utils.hasKeybladeID(source)) {
            if (destination.m_41783_() == null) {
                destination.m_41751_(new CompoundTag());
            }
            destination.m_41783_().m_128362_("keybladeID", source.m_41783_().m_128342_("keybladeID"));
        }
    }

    public static boolean hasKeybladeID(ItemStack stack) {
        return stack.m_41783_() != null && !stack.m_150930_(Items.f_41852_) && stack.m_41783_().m_128403_("keybladeID");
    }

    public static UUID getKeybladeID(ItemStack stack) {
        if (Utils.hasKeybladeID(stack)) {
            return stack.m_41783_().m_128342_("keybladeID");
        }
        return null;
    }

    public static void armourTick(ItemStack stack, Entity entity, Level level, int slot) {
        if (entity instanceof Player) {
            IPlayerCapabilities playerData;
            Player player = (Player)entity;
            if (!level.f_46443_ && (playerData = ModCapabilities.getPlayer(player)) != null) {
                UUID armorUUID;
                UUID uUID = armorUUID = playerData.getEquippedKBArmor(0).m_41720_() != null ? Utils.getArmorID(playerData.getEquippedKBArmor(0)) : null;
                if (Utils.hasArmorID(stack)) {
                    if (Utils.getArmorID(stack).equals(armorUUID)) {
                        if (player.m_150109_().m_8020_(36) != stack && player.m_150109_().m_8020_(37) != stack && player.m_150109_().m_8020_(38) != stack && player.m_150109_().m_8020_(39) != stack) {
                            Utils.desummonArmour(playerData, player, stack, slot, true, true);
                        }
                    } else {
                        Utils.desummonArmour(playerData, player, stack, slot, false, true);
                    }
                }
            }
        }
    }

    public static void desummonArmour(IPlayerCapabilities playerData, Player player, ItemStack stack, int slot, boolean sameUUID, boolean playSound) {
        if (sameUUID) {
            ItemStack pauldron = playerData.getEquippedKBArmor(0);
            pauldron.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                Item patt26411$temp = stack.m_41720_();
                if (patt26411$temp instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)patt26411$temp;
                    IItemHandlerModifiable pauldronInventory = (IItemHandlerModifiable)iItemHandler;
                    stack.m_41783_().m_128473_("armorID");
                    pauldronInventory.setStackInSlot(armorItem.m_266204_().ordinal(), stack);
                }
            });
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
        }
        player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
        if (playSound) {
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    public static boolean hasArmorID(ItemStack stack) {
        return (stack.m_41720_() instanceof PauldronItem || stack.m_41720_() instanceof ArmorItem) && stack.m_41783_() != null && stack.m_41783_().m_128403_("armorID");
    }

    public static UUID getArmorID(ItemStack stack) {
        if (Utils.hasArmorID(stack)) {
            return stack.m_41783_().m_128342_("armorID");
        }
        return null;
    }

    public static int findSummoned(Inventory inv, ItemStack chain) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>((Collection<ItemStack>)inv.f_35974_);
        list.addAll((Collection<ItemStack>)inv.f_35975_);
        list.addAll((Collection<ItemStack>)inv.f_35976_);
        return Utils.findSummoned(list, chain);
    }

    public static int findSummoned(List<ItemStack> inv, ItemStack chain) {
        if (!ItemStack.m_41728_((ItemStack)chain, (ItemStack)ItemStack.f_41583_)) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack slotStack = inv.get(i);
                if (!Utils.hasKeybladeID(slotStack) || slotStack.m_41783_() == null || chain.m_41783_() == null || !slotStack.m_41783_().m_128342_("keybladeID").equals(chain.m_41783_().m_128342_("keybladeID"))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findSummoned(Inventory inv) {
        ArrayList list = new ArrayList(inv.f_35974_);
        list.addAll(inv.f_35975_);
        list.addAll(inv.f_35976_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack slotStack = (ItemStack)list.get(i);
            if (!Utils.hasKeybladeID(slotStack) || !(slotStack.m_41720_() instanceof KeybladeItem)) continue;
            return i;
        }
        return -1;
    }

    public static void swapStack(Inventory inv, int stack1, int stack2) {
        ItemStack tempStack = inv.m_8020_(stack2);
        inv.m_6836_(stack2, inv.m_8020_(stack1));
        inv.m_6836_(stack1, tempStack);
    }

    public static ItemCategory getCategoryForStack(ItemStack stack) {
        ItemCategory category = ItemCategory.MISC;
        if (stack.m_41720_() instanceof IItemCategory) {
            category = ((IItemCategory)stack.m_41720_()).getCategory();
        } else if (ItemCategoryRegistry.hasCategory(stack.m_41720_())) {
            category = ItemCategoryRegistry.getCategory(stack.m_41720_());
        }
        return category;
    }

    public static ItemCategory getCategoryForRecipe(ResourceLocation location) {
        if (RecipeRegistry.getInstance().containsKey(location)) {
            return Utils.getCategoryForStack(new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue(location).getResult()));
        }
        return ItemCategory.MISC;
    }

    public static ItemCategory getCategoryForShop(ResourceLocation stackRL) {
        return Utils.getCategoryForStack(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(stackRL)));
    }

    public static int getAccessoriesStat(IPlayerCapabilities playerData, String type) {
        int res = 0;
        int c = 1;
        for (Map.Entry<Integer, ItemStack> entry : playerData.getEquippedAccessories().entrySet()) {
            if (c > playerData.getMaxAccessories()) break;
            if (ItemStack.m_41728_((ItemStack)entry.getValue(), (ItemStack)ItemStack.f_41583_)) continue;
            KKAccessoryItem accessory = (KKAccessoryItem)entry.getValue().m_41720_();
            switch (type) {
                case "ap": {
                    res += accessory.getAp();
                    break;
                }
                case "str": {
                    res += accessory.getStr();
                    break;
                }
                case "mag": {
                    res += accessory.getMag();
                }
            }
        }
        return res;
    }

    public static List<String> getAccessoriesAbilities(IPlayerCapabilities playerData) {
        ArrayList<String> res = new ArrayList<String>();
        int c = 1;
        for (Map.Entry<Integer, ItemStack> entry : playerData.getEquippedAccessories().entrySet()) {
            if (c > playerData.getMaxAccessories()) break;
            if (!ItemStack.m_41728_((ItemStack)entry.getValue(), (ItemStack)ItemStack.f_41583_)) {
                KKAccessoryItem accessory = (KKAccessoryItem)entry.getValue().m_41720_();
                res.addAll(accessory.getAbilities());
            }
            ++c;
        }
        return res;
    }

    public static int getArmorsStat(Map<Integer, ItemStack> equipped, String type) {
        int res = 0;
        for (Map.Entry<Integer, ItemStack> entry : equipped.entrySet()) {
            if (ItemStack.m_41728_((ItemStack)entry.getValue(), (ItemStack)ItemStack.f_41583_)) continue;
            KKArmorItem kkArmorItem = (KKArmorItem)entry.getValue().m_41720_();
            switch (type) {
                case "def": {
                    res += kkArmorItem.getDefense();
                    break;
                }
                case "darkness": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.darkness)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.darkness, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "light": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.light)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.light, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "ice": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.ice)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.ice, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "lightning": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.lightning)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.lightning, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "fire": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.fire)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.fire, res == 0 ? 100 : 100 - res);
                }
            }
        }
        return res;
    }

    public static int getArmorsStat(IPlayerCapabilities playerData, String type) {
        return Utils.getArmorsStat(playerData.getEquippedArmors(), type);
    }

    public static int getConsumedAP(IPlayerCapabilities playerData) {
        int ap = 0;
        LinkedHashMap<String, int[]> map = playerData.getAbilityMap();
        for (Map.Entry<String, int[]> entry : map.entrySet()) {
            Ability a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(entry.getKey()));
            ap += a.getAPCost() * Integer.bitCount(entry.getValue()[1]);
        }
        return ap;
    }

    public static double getMPHasteValue(IPlayerCapabilities playerData) {
        int val = 0;
        val += 2 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_haste");
        val += 4 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_hastera");
        return val += 6 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_hastega");
    }

    public static void RefreshAbilityAttributes(Player player, IPlayerCapabilities playerData) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        HashMultimap map = HashMultimap.create();
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString("7faaa8a8-fee1-422c-8f85-6794042e8f09"), "kingdomkeys:ability_lucky_lucky", (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky"), AttributeModifier.Operation.ADDITION);
        map.put((Object)Attributes.f_22286_, (Object)attributemodifier);
        player.m_21204_().m_22178_((Multimap)map);
    }

    public static boolean isWearingOrgRobes(Player player) {
        if (!ModConfigs.orgEnabled) {
            return false;
        }
        boolean wearingOrgCloak = true;
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (!itemStack.m_41619_() && (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135815_().startsWith("organization_") || ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135815_().startsWith("xemnas_") || ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135815_().startsWith("anticoat_"))) continue;
            wearingOrgCloak = false;
            break;
        }
        return wearingOrgCloak;
    }

    public static int getBagCosts(int bagLevel) {
        return bagCosts[bagLevel];
    }

    public static String snakeToCamel(String str) {
        str = ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1);
        while (((String)str).contains("_")) {
            str = ((String)str).replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(((String)str).charAt(((String)str).indexOf("_") + 1))));
        }
        str = ((String)str).substring(0, 1).toLowerCase() + ((String)str).substring(1);
        return str;
    }

    public static float getTargetPitch(Entity entity, Entity target) {
        double xDiff = target.m_20185_() - entity.m_20185_();
        double yDiff = target.m_20186_() - entity.m_20186_();
        double zDiff = target.m_20189_() - entity.m_20189_();
        double distance = Mth.m_14116_((float)((float)(xDiff * xDiff + zDiff * zDiff)));
        return (float)(-(Mth.m_14136_((double)yDiff, (double)distance) * 57.2957763671875));
    }

    public static float getTargetYaw(Entity entity, Entity target) {
        double d0 = target.m_20185_() - entity.m_20185_();
        double d1 = target.m_20189_() - entity.m_20189_();
        return (float)(-(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875)) - 90.0f;
    }

    public static Shotlock getPlayerShotlock(Player player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        return (Shotlock)ModShotlocks.registry.get().getValue(new ResourceLocation(playerData.getEquippedShotlock()));
    }

    public static boolean isPlayerLowHP(Player player) {
        return player.m_21223_() < player.m_21233_() / 4.0f;
    }

    public static void syncWorldData(Level world, IWorldCapabilities worldData) {
        world.m_7654_().m_129785_().forEach(sw -> ModCapabilities.getWorld((Level)sw).read(worldData.write(new CompoundTag())));
        PacketHandler.sendToAllPlayers(new SCSyncWorldCapability(worldData));
    }

    public static Map<Integer, ItemStack> getEquippedItems(Map<Integer, ItemStack> equippedItems) {
        HashMap<Integer, ItemStack> finalMap = new HashMap<Integer, ItemStack>(equippedItems);
        for (Map.Entry<Integer, ItemStack> entry : equippedItems.entrySet()) {
            ItemStack stack = entry.getValue();
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_)) continue;
            finalMap.remove(entry.getKey());
        }
        return finalMap;
    }

    public static boolean isEntityInParty(Party party, Entity e) {
        if (party == null) {
            return false;
        }
        List<Party.Member> list = party.getMembers();
        for (Party.Member m : list) {
            if (!m.getUUID().equals(e.m_20148_())) continue;
            return true;
        }
        return false;
    }

    public static List<Entity> removeFriendlyEntities(List<Entity> list) {
        ArrayList<Entity> list2 = new ArrayList<Entity>();
        for (Entity e : list) {
            if (!(e instanceof Monster) && !(e instanceof Player)) continue;
            list2.add((Entity)((LivingEntity)e));
        }
        return list2;
    }

    public static boolean isHostile(Entity e) {
        return e instanceof Monster || e instanceof Player || e instanceof Slime;
    }

    public static List<String> getKeybladeAbilitiesAtLevel(Item item, int level) {
        ArrayList<String> abilities = new ArrayList<String>();
        KeybladeItem keyblade = null;
        if (item instanceof IKeychain) {
            keyblade = ((IKeychain)item).toSummon();
        } else if (item instanceof KeybladeItem) {
            keyblade = (KeybladeItem)item;
        }
        if (keyblade != null) {
            for (int i = 0; i <= level; ++i) {
                String a = keyblade.data.getLevelAbility(i);
                if (a == null) continue;
                abilities.add(a);
            }
        }
        return abilities;
    }

    public static List<String> getOrgWeaponAbilities(Item item) {
        IOrgWeapon org;
        String[] a;
        ArrayList<String> abilities = new ArrayList<String>();
        Object keyblade = null;
        if (item instanceof IOrgWeapon && (a = (org = (IOrgWeapon)item).getOrganizationData().getAbilities()) != null) {
            abilities.addAll(Arrays.asList(a));
        }
        return abilities;
    }

    public static void restartLevel(IPlayerCapabilities playerData, Player player) {
        playerData.setLevel(1);
        playerData.setExperience(0);
        playerData.setMaxHP(20);
        player.m_21153_((float)playerData.getMaxHP());
        player.m_21051_(Attributes.f_22276_).m_22100_((double)playerData.getMaxHP());
        playerData.setMaxMP(0.0);
        playerData.setMP(playerData.getMaxMP());
        playerData.setStrength(1);
        playerData.setMagic(1);
        playerData.setDefense(1);
        playerData.setMaxAP(0);
        playerData.setMaxAccessories(0);
        playerData.setMaxArmors(0);
        playerData.clearAbilities();
        SoAState.applyStatsForChoices(player, playerData, false);
        playerData.setEquippedShotlock("");
        playerData.getShotlockList().clear();
    }

    public static void restartLevel2(IPlayerCapabilities playerData, Player player) {
        LinkedHashMap<String, int[]> driveForms = playerData.getDriveFormMap();
        for (Map.Entry<String, int[]> entry : driveForms.entrySet()) {
            int dfLevel = entry.getValue()[0];
            DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(entry.getKey()));
            if (form.getRegistryName().equals((Object)DriveForm.NONE) || form.getRegistryName().equals((Object)DriveForm.SYNCH_BLADE)) continue;
            for (int i = 1; i <= dfLevel; ++i) {
                String baseAbility = form.getBaseAbilityForLevel(i);
                if (baseAbility == null || baseAbility.equals("")) continue;
                playerData.addAbility(baseAbility, false);
            }
        }
        player.m_5634_((float)playerData.getMaxHP());
        playerData.setMP(playerData.getMaxMP());
    }

    public static String getTierFromInt(int tier) {
        return switch (tier) {
            case 1 -> "D";
            case 2 -> "C";
            case 3 -> "B";
            case 4 -> "A";
            case 5 -> "S";
            case 6 -> "SS";
            case 7 -> "SSS";
            default -> "Unknown: " + tier;
        };
    }

    public static int getFreeSlotsForPlayer(Player player) {
        int free = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!ItemStack.m_41728_((ItemStack)ItemStack.f_41583_, (ItemStack)stack)) continue;
            ++free;
        }
        return free;
    }

    public static int stacksForItemAmount(ItemStack item, int amount) {
        return (int)Math.round(Math.ceil((double)amount / (double)item.m_41741_()));
    }

    public static int getLootingLevel(Player player) {
        int lvl = 0;
        if (!ItemStack.m_41656_((ItemStack)player.m_21205_(), (ItemStack)ItemStack.f_41583_) && player.m_21205_().m_41793_()) {
            lvl += EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
        }
        if (!ItemStack.m_41656_((ItemStack)player.m_21206_(), (ItemStack)ItemStack.f_41583_) && player.m_21206_().m_41793_()) {
            lvl += EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21206_());
        }
        return lvl += ModCapabilities.getPlayer(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky");
    }

    public static List<String> appendEnchantmentNames(String text, CompoundTag pStoredEnchantments) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (pStoredEnchantments != null) {
            arrayList.add(Component.m_237115_((String)text).getString());
            for (int i = 0; i < pStoredEnchantments.m_128440_(); ++i) {
                CompoundTag compoundtag = pStoredEnchantments.m_128437_("Enchantments", 10).m_128728_(i);
                BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundtag)).ifPresent(p_41708_ -> arrayList.add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "- " + p_41708_.m_44700_(EnchantmentHelper.m_182438_((CompoundTag)compoundtag)).getString())).getString()));
            }
        }
        return arrayList;
    }

    public static int[] getRGBFromDec(int color) {
        int[] colors = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    public static int getDecFromRGB(int r, int g, int b) {
        return 65536 * r + 256 * g + b;
    }

    public static boolean shouldRenderOverlay(Player player) {
        if (ModConfigs.showGuiToggle == ModConfigs.ShowType.HIDE) {
            return false;
        }
        if (!(ModConfigs.showGuiToggle != ModConfigs.ShowType.WEAPON || player.m_21205_().m_41720_() instanceof KeybladeItem || player.m_21206_().m_41720_() instanceof KeybladeItem || player.m_21205_().m_41720_() instanceof IOrgWeapon || player.m_21206_().m_41720_() instanceof IOrgWeapon)) {
            return false;
        }
        IGlobalCapabilities globalData = ModCapabilities.getGlobal((LivingEntity)player);
        return globalData == null || !player.m_21023_((MobEffect)ModMobEffects.KO.get());
    }

    public static BlockPos stringArrayToBlockPos(String[] temp) {
        return new BlockPos(Utils.getInt(temp[0]), Utils.getInt(temp[1]), Utils.getInt(temp[2]));
    }

    public static void reviveFromKO(LivingEntity entity) {
        entity.m_21195_((MobEffect)ModMobEffects.KO.get());
    }

    public static int getRandomMobLevel(Player player) {
        if (ModConfigs.mobLevelingUp) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0;
            }
            int avgLevel = playerData.getLevel();
            if (ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_()) != null) {
                Party p = ModCapabilities.getWorld(player.m_9236_()).getPartyFromMember(player.m_20148_());
                int total = 0;
                int membersOnline = 0;
                for (Party.Member m : p.getMembers()) {
                    if (Utils.getPlayerByName(player.m_9236_(), m.getUsername().toLowerCase()) == null) continue;
                    total += ModCapabilities.getPlayer(Utils.getPlayerByName(player.m_9236_(), m.getUsername().toLowerCase())).getLevel();
                    ++membersOnline;
                }
                if (membersOnline == 0) {
                    avgLevel = 1;
                    KingdomKeys.LOGGER.warn("0 members online for this party, this should not be happening, in world " + player.m_9236_().m_46472_().m_135782_().toString());
                } else {
                    avgLevel = total / membersOnline;
                }
            }
            int level = avgLevel - player.m_9236_().f_46441_.m_188503_(6) + 2;
            level = Utils.clamp(level, 1, 100);
            return level;
        }
        return 0;
    }

    public static ChatFormatting getLevelColor(Player player, int lvl) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (playerData == null) {
            return ChatFormatting.WHITE;
        }
        if (playerData.getLevel() > lvl) {
            return ChatFormatting.GREEN;
        }
        if (playerData.getLevel() == lvl) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public static void playSoundToEveryone(ServerLevel level, SoundEvent sound, float vol, float pitch) {
        for (Player p : Utils.getAllPlayers(level.m_7654_())) {
            p.m_9236_().m_5594_(null, p.m_20183_(), sound, SoundSource.PLAYERS, vol, pitch);
        }
    }

    public static void summonKeyblade(Player player, boolean forceDesummon, ResourceLocation formToSummonFrom) {
        ItemStack keyblade;
        ItemStack summonedExtraStack;
        ItemStack extraChain;
        boolean useOrg;
        ItemStack chain;
        ItemStack offHeldStack;
        ItemStack heldStack;
        IPlayerCapabilities playerData;
        block39: {
            block37: {
                block38: {
                    playerData = ModCapabilities.getPlayer(player);
                    if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                        return;
                    }
                    heldStack = player.m_21205_();
                    offHeldStack = player.m_21206_();
                    chain = playerData.getEquippedKeychain(DriveForm.NONE);
                    useOrg = false;
                    if (playerData.getAlignment() != OrgMember.NONE) {
                        chain = playerData.getEquippedWeapon().m_41777_();
                        useOrg = true;
                    }
                    extraChain = null;
                    if (formToSummonFrom == null) break block37;
                    if (formToSummonFrom.equals((Object)DriveForm.NONE)) break block38;
                    if (!playerData.getEquippedKeychains().containsKey(formToSummonFrom)) break block39;
                    extraChain = playerData.getEquippedKeychain(formToSummonFrom);
                    break block39;
                }
                KingdomKeys.LOGGER.fatal(".-.");
                break block39;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
                if (playerData.getAlignment() == OrgMember.NONE || playerData.getEquippedWeapon() != null && playerData.getEquippedWeapon().m_41720_() instanceof KeybladeItem && playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE) != null) {
                    extraChain = playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                } else {
                    extraChain = chain.m_41777_();
                    for (ItemStack weapon : playerData.getWeaponsUnlocked()) {
                        if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)extraChain)) continue;
                        extraChain.m_41751_(weapon.m_41783_());
                        break;
                    }
                }
            }
        }
        ArrayList<ItemStack> potentialKeyblades = new ArrayList<ItemStack>((Collection<ItemStack>)player.m_150109_().f_35974_);
        potentialKeyblades.addAll((Collection<ItemStack>)player.m_150109_().f_35975_);
        potentialKeyblades.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
        int slotSummoned = -1;
        slotSummoned = Utils.findSummoned(potentialKeyblades, chain);
        if (slotSummoned != -1) {
            potentialKeyblades.set(slotSummoned, ItemStack.f_41583_);
        }
        int extraSlotSummoned = -1;
        if (extraChain != null) {
            extraSlotSummoned = Utils.findSummoned(potentialKeyblades, extraChain);
        }
        ItemStack summonedStack = slotSummoned > -1 ? player.m_150109_().m_8020_(slotSummoned) : ItemStack.f_41583_;
        ItemStack itemStack = summonedExtraStack = extraSlotSummoned > -1 ? player.m_150109_().m_8020_(extraSlotSummoned) : ItemStack.f_41583_;
        if (forceDesummon && !ItemStack.m_41728_((ItemStack)(heldStack = summonedStack), (ItemStack)ItemStack.f_41583_)) {
            offHeldStack = summonedExtraStack;
        }
        if (forceDesummon || !ItemStack.m_41728_((ItemStack)offHeldStack, (ItemStack)ItemStack.f_41583_) && ItemStack.m_41728_((ItemStack)offHeldStack, (ItemStack)summonedExtraStack) && Utils.hasKeybladeID(offHeldStack)) {
            if ((forceDesummon || !ItemStack.m_41728_((ItemStack)heldStack, (ItemStack)ItemStack.f_41583_) && ItemStack.m_41728_((ItemStack)heldStack, (ItemStack)summonedStack)) && offHeldStack.m_41783_() != null && offHeldStack.m_41783_().m_128342_("keybladeID").equals(extraChain.m_41783_().m_128342_("keybladeID"))) {
                extraChain.m_41751_(offHeldStack.m_41783_());
                playerData.equipKeychain(formToSummonFrom, extraChain);
                player.m_150109_().m_6836_(extraSlotSummoned, ItemStack.f_41583_);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else if (extraSlotSummoned > -1) {
            Utils.swapStack(player.m_150109_(), 40, extraSlotSummoned);
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
        } else if (extraChain != null && !ItemStack.m_41728_((ItemStack)extraChain, (ItemStack)ItemStack.f_41583_)) {
            if (ItemStack.m_41728_((ItemStack)offHeldStack, (ItemStack)ItemStack.f_41583_)) {
                keyblade = extraChain.m_41720_() instanceof IKeychain ? new ItemStack((ItemLike)((IKeychain)extraChain.m_41720_()).toSummon()) : new ItemStack((ItemLike)extraChain.m_41720_());
                keyblade.m_41751_(extraChain.m_41783_());
                player.m_150109_().m_6836_(40, keyblade);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                Utils.spawnKeybladeParticles(player, InteractionHand.OFF_HAND);
            } else if (player.m_150109_().m_36062_() > -1) {
                keyblade = extraChain.m_41720_() instanceof IKeychain ? new ItemStack((ItemLike)((IKeychain)extraChain.m_41720_()).toSummon()) : new ItemStack((ItemLike)extraChain.m_41720_());
                keyblade.m_41751_(extraChain.m_41783_());
                Utils.swapStack(player.m_150109_(), player.m_150109_().m_36062_(), 40);
                player.m_150109_().m_6836_(40, keyblade);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
        if (forceDesummon || !ItemStack.m_41728_((ItemStack)heldStack, (ItemStack)ItemStack.f_41583_) && Utils.hasKeybladeID(heldStack)) {
            if (Utils.hasKeybladeID(heldStack) && heldStack.m_41783_().m_128342_("keybladeID").equals(chain.m_41783_().m_128342_("keybladeID"))) {
                chain.m_41751_(heldStack.m_41783_());
                if (useOrg) {
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)heldStack)) continue;
                        weapon.m_41751_(heldStack.m_41783_());
                        break;
                    }
                    playerData.setWeaponsUnlocked(weapons);
                } else {
                    playerData.equipKeychain(DriveForm.NONE, chain);
                }
                if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade") && !extraChain.m_150930_(Items.f_41852_)) {
                    player.m_150109_().m_6836_(40, ItemStack.f_41583_);
                }
                player.m_150109_().m_6836_(slotSummoned, ItemStack.f_41583_);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else if (slotSummoned > -1) {
            Utils.swapStack(player.m_150109_(), player.m_150109_().f_35977_, slotSummoned);
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            Utils.spawnKeybladeParticles(player, InteractionHand.MAIN_HAND);
        } else if (!ItemStack.m_41728_((ItemStack)chain, (ItemStack)ItemStack.f_41583_)) {
            if (ItemStack.m_41728_((ItemStack)heldStack, (ItemStack)ItemStack.f_41583_)) {
                if (!useOrg) {
                    keyblade = new ItemStack((ItemLike)((IKeychain)chain.m_41720_()).toSummon());
                    keyblade.m_41751_(chain.m_41783_());
                } else {
                    keyblade = chain;
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)keyblade)) continue;
                        keyblade.m_41751_(weapon.m_41783_());
                        break;
                    }
                }
                Utils.swapStack(player.m_150109_(), player.m_150109_().f_35977_, player.m_150109_().m_36062_());
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, keyblade);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                Utils.spawnKeybladeParticles(player, InteractionHand.MAIN_HAND);
            } else if (player.m_150109_().m_36062_() > -1) {
                if (!useOrg) {
                    keyblade = new ItemStack((ItemLike)((IKeychain)chain.m_41720_()).toSummon());
                    keyblade.m_41751_(chain.m_41783_());
                } else {
                    keyblade = chain;
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.m_41656_((ItemStack)weapon, (ItemStack)keyblade)) continue;
                        keyblade.m_41751_(weapon.m_41783_());
                        break;
                    }
                }
                Utils.swapStack(player.m_150109_(), player.m_150109_().m_36062_(), player.m_150109_().f_35977_);
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, keyblade);
                player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private static void spawnKeybladeParticles(Player summoner, InteractionHand hand) {
        Vec3 userPos = new Vec3(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_());
        Vec3 lHandCenter = new Vec3(-0.4, -1.3, -0.38);
        lHandCenter = lHandCenter.m_82524_((float)Math.toRadians(-summoner.f_20883_));
        Vec3 rHandCenter = new Vec3(0.4, -1.3, -0.38);
        rHandCenter = rHandCenter.m_82524_((float)Math.toRadians(-summoner.f_20883_));
        Vec3 v = null;
        v = hand == InteractionHand.MAIN_HAND ? userPos.m_82520_(-rHandCenter.f_82479_, rHandCenter.f_82480_, -rHandCenter.f_82481_) : userPos.m_82520_(-lHandCenter.f_82479_, lHandCenter.f_82480_, -lHandCenter.f_82481_);
        ((ServerLevel)summoner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, v.f_82479_, summoner.m_20186_() + 1.0, v.f_82481_, 80, 0.0, 0.0, 0.0, 0.2);
    }

    public static boolean isPlayerWithin(Player player, BlockPosBounds bounds) {
        return (int)player.m_20185_() >= bounds.min.m_123341_() && (int)player.m_20185_() <= bounds.max.m_123341_() && (int)player.m_20186_() >= bounds.min.m_123342_() && (int)player.m_20186_() <= bounds.max.m_123342_() && (int)player.m_20189_() >= bounds.min.m_123343_() && (int)player.m_20189_() <= bounds.max.m_123343_();
    }

    public static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static void applyMobLevel(LivingEntity mob, int level) {
        if (level != 0) {
            AttributeInstance hp;
            AttributeInstance attack = mob.m_21051_(Attributes.f_22281_);
            if (attack != null) {
                AttributeModifier attackModifier = attack.m_22111_(mobLevelAttackModifier);
                if (attackModifier != null) {
                    attack.m_22130_(attackModifier);
                }
                attack.m_22125_(new AttributeModifier(mobLevelAttackModifier, "kk_mob_level_attack", (double)((float)(level * ModConfigs.mobLevelStats) / 500.0f), AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if ((hp = mob.m_21051_(Attributes.f_22276_)) != null) {
                AttributeModifier hpModifier = hp.m_22111_(mobLevelHPModifier);
                if (hpModifier != null) {
                    hp.m_22130_(hpModifier);
                }
                hp.m_22125_(new AttributeModifier(mobLevelHPModifier, "kk_mob_level_hp", (double)((float)(level * ModConfigs.mobLevelStats) / 500.0f), AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }

    public static List<DriveForm> getVisibleDriveForms(Player player) {
        return ModDriveForms.registry.get().getValues().stream().filter(driveForm -> driveForm.displayInCommandMenu(player)).toList();
    }

    public static enum OrgMember {
        NONE,
        XEMNAS,
        XIGBAR,
        XALDIN,
        VEXEN,
        LEXAEUS,
        ZEXION,
        SAIX,
        AXEL,
        DEMYX,
        LUXORD,
        MARLUXIA,
        LARXENE,
        ROXAS;

    }

    public record BlockPosBounds(BlockPos min, BlockPos max) {
        public BlockPosBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        }
    }

    public record castMagic(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity, Magic magic) {
    }

    public record ShotlockPosition(int id, float x, float y, float z) {
    }

    public static class Title {
        public String title;
        public String subtitle;
        public int fadeIn = 10;
        public int fadeOut = 20;
        public int displayTime = 70;

        public Title(String title, String subtitle, int fadeIn, int displayTime, int fadeOut) {
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.fadeOut = fadeOut;
            this.displayTime = displayTime;
        }

        public Title(String title, String subtitle) {
            this.title = title;
            this.subtitle = subtitle;
        }

        public Title(CompoundTag compound) {
            this.read(compound);
        }

        public CompoundTag write() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("title", this.title);
            compound.m_128359_("subtitle", this.subtitle);
            compound.m_128405_("fadein", this.fadeIn);
            compound.m_128405_("fadeout", this.fadeOut);
            compound.m_128405_("displaytime", this.displayTime);
            return compound;
        }

        public void read(CompoundTag tag) {
            this.title = tag.m_128461_("title");
            this.subtitle = tag.m_128461_("subtitle");
            this.fadeIn = tag.m_128451_("fadein");
            this.fadeOut = tag.m_128451_("fadeout");
            this.displayTime = tag.m_128451_("displaytime");
        }

        public static CompoundTag writeList(List<Title> titles) {
            CompoundTag compound = new CompoundTag();
            for (int i = 0; i < titles.size(); ++i) {
                Title t = titles.get(i);
                compound.m_128365_("m" + i, (Tag)t.write());
            }
            compound.m_128405_("size", titles.size());
            return compound;
        }

        public static List<Title> readList(CompoundTag compound) {
            int size = compound.m_128451_("size");
            ArrayList<Title> titles = new ArrayList<Title>();
            for (int i = 0; i < size; ++i) {
                titles.add(new Title(compound.m_128469_("m" + i)));
            }
            return titles;
        }
    }
}

