/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.card.WorldCardItem;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistry;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class Floor
implements INBTSerializable<CompoundTag> {
    FloorType type = ModFloorTypes.NONE.get();
    Map<UUID, Room> players = new HashMap<UUID, Room>();
    Map<RoomPos, RoomData> rooms = new HashMap<RoomPos, RoomData>();
    int floorID;
    RoomPos exitRoom;

    public Floor(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public Floor(Level level) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability capability = ModCapabilities.getCastleOblivionInterior(level);
        this.floorID = capability.getFloors().size();
        capability.addFloor(this);
        RoomData entranceHall = new RoomData(RoomPos.ZERO, RoomData.Type.ENTRANCE);
        entranceHall.setDoor(DoorData.Type.ENTRANCE, RoomDirection.SOUTH);
        entranceHall.setDoor(DoorData.Type.HALL, RoomDirection.NORTH);
        entranceHall.setRemainingDoors(DoorData.Type.NONE);
        entranceHall.setParent(this);
        this.rooms.put(entranceHall.pos, entranceHall);
    }

    public static Floor getOrCreateFirstFloor(Level level) {
        CastleOblivionCapabilities.ICastleOblivionInteriorCapability capability = ModCapabilities.getCastleOblivionInterior(level);
        if (capability.getFloors().isEmpty()) {
            Floor floor = new Floor(level);
            RoomData data = floor.getRoom(RoomPos.ZERO);
            Room room = new Room(ModRoomTypes.ENTRANCE_HALL.get(), floor.getFloorID(), RoomPos.ZERO);
            room.setPosition(new BlockPos(0, 59, 0));
            BlockPos southDoor = new BlockPos(16, 60, 1);
            BlockPos northDoor = new BlockPos(16, 63, 67);
            room.doors.put(RoomDirection.NORTH, new Room.Door(data.getDoor(RoomDirection.NORTH), northDoor));
            room.doors.put(RoomDirection.SOUTH, new Room.Door(data.getDoor(RoomDirection.SOUTH), southDoor));
            room.setStructure(ModRoomStructures.ENTRANCE_HALL_1F.get());
            data.setGenerated(room);
            BlockState northState = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.cardDoor.get()).m_49966_().m_61124_((Property)CardDoorBlock.FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CardDoorBlock.GENERATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(false));
            BlockState southState = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.cardDoor.get()).m_49966_().m_61124_((Property)CardDoorBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)CardDoorBlock.GENERATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
            level.m_7731_(northDoor, northState, 2);
            level.m_7731_(southDoor, southState, 2);
            CardDoorTileEntity northTE = new CardDoorTileEntity(northDoor, northState);
            northTE.setParent(data);
            northTE.setDirection(RoomDirection.NORTH);
            northTE.setData(data.getDoor(RoomDirection.NORTH));
            CardDoorTileEntity southTE = new CardDoorTileEntity(southDoor, southState);
            southTE.setParent(data);
            southTE.setDirection(RoomDirection.SOUTH);
            southTE.setData(data.getDoor(RoomDirection.SOUTH));
            southTE.openDoor(false);
            level.m_151523_((BlockEntity)northTE);
            level.m_151523_((BlockEntity)southTE);
            return floor;
        }
        return capability.getFloors().get(0);
    }

    public RoomData getExitRoom() {
        return this.rooms.get(this.exitRoom);
    }

    public int getFloorID() {
        return this.floorID;
    }

    public Map<UUID, Room> getPlayers() {
        return ImmutableMap.builder().putAll(this.players).build();
    }

    public boolean hasWorldCard() {
        return this.type != ModFloorTypes.NONE.get();
    }

    public void floorEntered(Player player) {
        this.players.put(player.m_36316_().getId(), this.getEntranceHall().getGenerated());
    }

    public void floorExited(Player player) {
        this.players.remove(player.m_36316_().getId());
    }

    public boolean inFloor(BlockPos pos) {
        Room entrance;
        if (!this.rooms.isEmpty() && (entrance = this.rooms.get(RoomPos.ZERO).getGenerated()) != null) {
            int maxX = entrance.getPosition().m_123341_() + entrance.getStructure().getWidth();
            int minX = entrance.getPosition().m_123341_();
            int maxZ = entrance.getPosition().m_123343_() + entrance.getStructure().getDepth();
            int minZ = entrance.getPosition().m_123343_();
            for (Map.Entry<RoomPos, RoomData> roomData : this.rooms.entrySet()) {
                Room room = roomData.getValue().getGenerated();
                int roomWidth = room.getStructure().getWidth();
                int roomDepth = room.getStructure().getDepth();
                BlockPos roomPos = room.getPosition();
                minX = Math.min(minX, roomPos.m_123341_());
                maxX = Math.max(maxX, roomPos.m_123341_() + roomWidth);
                minZ = Math.min(minZ, roomPos.m_123343_());
                maxZ = Math.max(maxZ, roomPos.m_123343_() + roomDepth);
            }
            return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ;
        }
        return false;
    }

    public void setWorldCard(WorldCardItem card) {
        this.type = card.getFloorType();
        this.generateLayout();
    }

    public FloorType getType() {
        return this.type;
    }

    public BlockPos getEntranceHallPosition() {
        return this.getRoom(RoomPos.ZERO).getGenerated().getPosition();
    }

    public RoomData getEntranceHall() {
        return this.getRoom(RoomPos.ZERO);
    }

    public void generateLayout() {
        int i;
        RoomData entrance = new RoomData(new RoomPos(0, 1), RoomData.Type.NORMAL);
        entrance.setDoor(DoorData.Type.FIXED, RoomDirection.SOUTH);
        entrance.setParent(this);
        RoomData currentRoom = entrance;
        this.rooms.put(entrance.pos, entrance);
        RoomDirection prevDir = RoomDirection.SOUTH;
        for (i = 0; i < this.type.getCritPathLength(); ++i) {
            Map<RoomData, RoomDirection> adjRooms = this.getAdjacentRooms(currentRoom);
            ArrayList<RoomDirection> directions = new ArrayList<RoomDirection>(List.of(RoomDirection.values()));
            if (currentRoom.pos.y() == 1) {
                directions.remove((Object)RoomDirection.SOUTH);
            }
            for (RoomDirection direction : adjRooms.values()) {
                directions.remove((Object)direction);
            }
            if (directions.isEmpty()) {
                boolean deadEnd = true;
                nextDir = null;
                int intersections = 0;
                boolean foundNextSpace = false;
                for (RoomDirection dir : Arrays.stream(RoomDirection.values()).toList()) {
                    if (foundNextSpace) break;
                    boolean noPossible = false;
                    RoomPos searchPos = currentRoom.pos.add(dir);
                    intersections = 0;
                    while (!foundNextSpace && !noPossible) {
                        if (this.rooms.containsKey(searchPos)) {
                            RoomData searchRoom = this.rooms.get(searchPos);
                            if (searchRoom.getType() == RoomData.Type.NORMAL) {
                                searchPos = searchPos.add(dir);
                                ++intersections;
                                continue;
                            }
                            nextDir = dir;
                            noPossible = true;
                            continue;
                        }
                        nextDir = dir;
                        deadEnd = false;
                        foundNextSpace = true;
                    }
                }
                if (deadEnd) {
                    if (!currentRoom.getDoors().containsKey((Object)nextDir)) {
                        currentRoom.setDoor(DoorData.Type.EXIT, nextDir);
                        currentRoom.setRemainingDoors(DoorData.Type.NONE);
                        currentRoom.finalizeType(RoomData.Type.EXIT);
                        this.exitRoom = currentRoom.pos;
                    }
                } else {
                    RoomPos pos = currentRoom.pos.add(nextDir);
                    for (int j = 0; j < intersections; ++j) {
                        RoomData intersectedRoom = this.rooms.get(pos);
                        if (intersectedRoom != null) {
                            intersectedRoom.addDoor(DoorData.Type.NORMAL, nextDir);
                            intersectedRoom.addDoor(DoorData.Type.NORMAL, nextDir.opposite());
                        }
                        pos = pos.add(nextDir);
                    }
                    if (!this.rooms.containsKey(pos)) {
                        currentRoom.setDoor(DoorData.Type.NORMAL, nextDir);
                        if (i == this.type.getCritPathLength() - 1) {
                            RoomData newRoom = new RoomData(pos);
                            newRoom.setDoor(DoorData.Type.NORMAL, nextDir.opposite());
                            currentRoom.finalizeType(RoomData.Type.NORMAL);
                            currentRoom = newRoom;
                            currentRoom.setDoor(DoorData.Type.EXIT, nextDir);
                            currentRoom.setRemainingDoors(DoorData.Type.NONE);
                            currentRoom.finalizeType(RoomData.Type.EXIT);
                            this.exitRoom = currentRoom.pos;
                        } else {
                            RoomData newRoom = new RoomData(pos);
                            newRoom.setDoor(DoorData.Type.NORMAL, nextDir.opposite());
                            currentRoom.finalizeType(RoomData.Type.NORMAL);
                            currentRoom = newRoom;
                        }
                    } else {
                        KingdomKeys.LOGGER.error("Room pos after intersection at pos {} already contains a room this should not happen", (Object)pos.toString());
                    }
                }
            } else {
                int rand = Utils.randomWithRange(0, directions.size() - 1);
                nextDir = (RoomDirection)((Object)directions.get(rand));
                prevDir = nextDir.opposite();
                currentRoom.setDoor(DoorData.Type.NORMAL, nextDir);
                if (i == this.type.getCritPathLength() - 1) {
                    currentRoom = this.createRoomInDirection(currentRoom, nextDir);
                    currentRoom.setDoor(DoorData.Type.EXIT, nextDir);
                    currentRoom.setRemainingDoors(DoorData.Type.NONE);
                    currentRoom.finalizeType(RoomData.Type.EXIT);
                    this.exitRoom = currentRoom.pos;
                } else {
                    currentRoom.finalizeType(RoomData.Type.NORMAL);
                    currentRoom = this.createRoomInDirection(currentRoom, nextDir);
                }
            }
            currentRoom.setParent(this);
            this.rooms.put(currentRoom.pos, currentRoom);
        }
        currentRoom = entrance;
        for (i = 0; i < this.type.getBonusRoomCount(); ++i) {
        }
    }

    public RoomData createRoomInDirection(RoomData prevRoom, RoomDirection direction) {
        RoomData newRoom = new RoomData(RoomPos.inDirection(prevRoom.pos, direction));
        newRoom.setDoor(DoorData.Type.NORMAL, direction.opposite());
        return newRoom;
    }

    public List<RoomData> getRooms() {
        return this.rooms.values().stream().toList();
    }

    public List<RoomData> getGeneratedRooms() {
        return this.rooms.values().stream().filter(roomData -> roomData.getGenerated() != null).toList();
    }

    public RoomData getRoom(RoomPos pos) {
        return this.rooms.get(pos);
    }

    @Nullable
    public RoomData getAdjacentRoom(RoomData room, RoomDirection direction) {
        RoomPos adjPos = room.pos.add(direction);
        if (this.rooms.containsKey(adjPos)) {
            return this.rooms.get(adjPos);
        }
        return null;
    }

    public Map<RoomData, RoomDirection> getAdjacentRooms(RoomData room) {
        HashMap<RoomData, RoomDirection> rooms = new HashMap<RoomData, RoomDirection>();
        for (int i = 0; i < RoomDirection.values().length; ++i) {
            RoomData roomData = this.getAdjacentRoom(room, RoomDirection.values()[i]);
            if (roomData == null) continue;
            rooms.put(roomData, RoomDirection.values()[i]);
        }
        return rooms;
    }

    public boolean shouldTick() {
        return !this.players.isEmpty();
    }

    public boolean shouldRoomTick(Room room) {
        return this.players.containsValue(room);
    }

    public BlockPos getNorthernMostRoomPosition() {
        BlockPos startPos = this.getEntranceHallPosition();
        RoomPos found = RoomPos.ZERO;
        for (RoomPos pos : this.rooms.keySet()) {
            if (pos.y() <= found.y()) continue;
            found = pos;
        }
        return new BlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_() + 128 * found.y());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", this.floorID);
        tag.m_128359_("floor_type", this.type.getRegistryName().toString());
        tag.m_128405_("players_size", this.players.size());
        CompoundTag playersTag = new CompoundTag();
        for (int i = 0; i < this.players.size(); ++i) {
            List uuids = this.players.keySet().stream().toList();
            List<Room> rooms = this.players.values().stream().toList();
            playersTag.m_128362_("players_uuid_" + i, (UUID)uuids.get(i));
            playersTag.m_128365_("players_room_" + i, (Tag)rooms.get(i).serializeNBT());
        }
        tag.m_128365_("players", (Tag)playersTag);
        tag.m_128405_("rooms_size", this.rooms.size());
        CompoundTag roomsTag = new CompoundTag();
        for (int i = 0; i < this.rooms.size(); ++i) {
            List<RoomData> roomList = this.rooms.values().stream().toList();
            roomsTag.m_128365_("rooms_roomdata_" + i, (Tag)roomList.get(i).serializeNBT());
        }
        tag.m_128365_("rooms", (Tag)roomsTag);
        if (this.exitRoom != null) {
            tag.m_128365_("exit", (Tag)this.exitRoom.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.floorID = tag.m_128451_("id");
        this.type = (FloorType)((JsonRegistry)((Object)ModJsonRegistries.FLOOR_TYPE.get())).getValue(new ResourceLocation(tag.m_128461_("floor_type")));
        this.players.clear();
        int playerssize = tag.m_128451_("players_size");
        CompoundTag playersTag = tag.m_128469_("players");
        this.rooms.clear();
        int roomssize = tag.m_128451_("rooms_size");
        CompoundTag roomsTag = tag.m_128469_("rooms");
        for (int i = 0; i < roomssize; ++i) {
            RoomData data = new RoomData(roomsTag.m_128469_("rooms_roomdata_" + i));
            this.rooms.put(data.pos, data);
        }
        if (tag.m_128441_("exit")) {
            this.exitRoom = new RoomPos(tag.m_128469_("exit"));
        }
    }
}

