/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistryObject;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomCategory;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomSize;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoomStructure
extends JsonRegistryObject {
    private String path;
    private RoomSize size;
    private List<RoomCategory> categories;
    @Nullable
    private ResourceLocation floor;
    private int width;
    private int depth;
    private List<ResourceLocation> roomWhitelist;

    public RoomStructure(CompoundTag tag) {
        super(tag);
    }

    public RoomStructure(JsonElement element) {
        super(element);
    }

    public List<RoomType> getRoomWhitelist() {
        return this.roomWhitelist.stream().map(resourceLocation -> ModRoomTypes.registry.get().getValue((ResourceLocation)resourceLocation)).toList();
    }

    public FloorType getFloor() {
        if (this.floor != null) {
            return ModFloorTypes.registry.get().getValue(this.floor);
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public RoomSize getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<RoomCategory> getCategories() {
        return this.categories;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("structure", this.path);
        tag.m_128405_("size", this.size.ordinal());
        tag.m_128405_("width", this.width);
        tag.m_128405_("depth", this.depth);
        CompoundTag categories = new CompoundTag();
        this.categories.forEach(roomCategory -> categories.m_128405_(roomCategory.name(), roomCategory.ordinal()));
        tag.m_128365_("categories", (Tag)categories);
        if (this.floor != null) {
            tag.m_128359_("floor", this.floor.toString());
        }
        CompoundTag whiteList = new CompoundTag();
        if (this.roomWhitelist != null) {
            this.roomWhitelist.forEach(resourceLocation -> whiteList.m_128359_(resourceLocation.toString(), resourceLocation.toString()));
        }
        tag.m_128365_("white_list", (Tag)whiteList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.path = tag.m_128461_("structure");
        this.size = RoomSize.values()[tag.m_128451_("size")];
        this.width = tag.m_128451_("width");
        this.depth = tag.m_128451_("depth");
        this.categories = new ArrayList<RoomCategory>();
        CompoundTag cats = tag.m_128469_("categories");
        cats.m_128431_().forEach(s -> this.categories.add(RoomCategory.values()[cats.m_128451_(s)]));
        if (tag.m_128441_("floor")) {
            this.floor = new ResourceLocation(tag.m_128461_("floor"));
        }
        this.roomWhitelist = new ArrayList<ResourceLocation>();
        tag.m_128469_("white_list").m_128431_().forEach(s -> this.roomWhitelist.add(new ResourceLocation(s)));
    }

    @Override
    public void deserializeJson(JsonElement element) throws JsonParseException {
        JsonObject root = RoomStructure.getJsonObject(element);
        root.entrySet().forEach(entry -> {
            JsonElement entryElement = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "structure": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        this.path = s;
                        break;
                    }
                    throw new JsonParseException("Structure should not be empty");
                }
                case "size": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        try {
                            this.size = RoomSize.valueOf(s.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new JsonParseException("Invalid size, valid values are: S, M, L, SPECIAL");
                        }
                    }
                    throw new JsonParseException("Size should not be empty");
                }
                case "dimensions": {
                    JsonArray dimensions = entryElement.getAsJsonArray();
                    if (dimensions.size() >= 2) {
                        this.width = dimensions.get(0).getAsInt();
                        this.depth = dimensions.get(1).getAsInt();
                        break;
                    }
                    throw new JsonParseException("Dimensions should have 2 values");
                }
                case "categories": {
                    JsonArray categories = entryElement.getAsJsonArray();
                    if (!categories.isEmpty()) {
                        this.categories = new ArrayList<RoomCategory>();
                        categories.forEach(cat -> {
                            String s = cat.getAsString();
                            if (!s.isEmpty()) {
                                try {
                                    this.categories.add(RoomCategory.valueOf(s.toUpperCase()));
                                }
                                catch (IllegalArgumentException e) {
                                    throw new JsonParseException("Invalid category, valid values are: ENEMY, STATUS, BOUNTY, SPECIAL, ANY");
                                }
                            } else {
                                throw new JsonParseException("Category should not be empty");
                            }
                        });
                        break;
                    }
                    throw new JsonParseException("Categories should not be empty");
                }
                case "floor": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    this.floor = new ResourceLocation(s);
                    break;
                }
                case "white_list": {
                    JsonArray whitelist = entryElement.getAsJsonArray();
                    if (whitelist.isEmpty()) break;
                    this.roomWhitelist = new ArrayList<ResourceLocation>();
                    whitelist.forEach(wlentry -> {
                        String roomtype = wlentry.getAsString();
                        this.roomWhitelist.add(new ResourceLocation(roomtype));
                    });
                }
            }
            if (this.roomWhitelist == null) {
                this.roomWhitelist = new ArrayList<ResourceLocation>();
            }
        });
    }

    @NotNull
    private static JsonObject getJsonObject(JsonElement element) {
        JsonObject root = element.getAsJsonObject();
        if (!root.has("structure")) {
            throw new JsonParseException("Missing required element \"structure\"");
        }
        if (!root.has("size")) {
            throw new JsonParseException("Missing required element \"size\"");
        }
        if (!root.has("dimensions")) {
            throw new JsonParseException("Missing required element \"dimensions\"");
        }
        if (!root.has("categories")) {
            throw new JsonParseException("Missing required element \"categories\"");
        }
        return root;
    }
}

