/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.dive_to_the_heart;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.entity.block.SoAPlatformTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class DiveToTheHeartChunkGenerator
extends ChunkGenerator {
    BiomeSource biomeSource;
    public static final Codec<DiveToTheHeartChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(inst -> inst.biomeSource)).apply((Applicative)instance, instance.stable(DiveToTheHeartChunkGenerator::new)));
    private static final BlockPos SPAWN_POS = new BlockPos(0, 25, 0);
    int width = 17;
    int height = 25;
    int depth = 17;
    int leftXSize = 8;
    int rightXSize = 9;
    int topZSize = 8;
    int bottomZSize = 9;
    String topOfPlatform = "0000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004000000000005000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    String structureTop = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111112111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";
    String structureMiddle = "0000011111110000000011000000011000001000000000001000100000000000001001000000000000010100000000000000011000000000000000110000000000000001100000000000000011000000000000000110000000000000001100000000000000010100000000000001001000000000000010001000000000001000001100000001100000000111111100000";
    String structureBottom = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";

    public DiveToTheHeartChunkGenerator(BiomeSource biomeSource) {
        super(biomeSource);
        this.biomeSource = biomeSource;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion pLevel, long pSeed, RandomState pRandom, BiomeManager pBiomeManager, StructureManager pStructureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }

    public void m_6929_(WorldGenRegion pLevel) {
    }

    public int m_6331_() {
        return 0;
    }

    public void m_214194_(WorldGenRegion pLevel, StructureManager pStructureManager, RandomState pRandom, ChunkAccess pChunk) {
        int startX;
        int startZ;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        ChunkPos cPos = pChunk.m_7697_();
        int xOffset = 0;
        int zOffset = 0;
        if (cPos.equals((Object)new ChunkPos(0, 0))) {
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.rightXSize, this.bottomZSize, Corner.BR);
        }
        if (cPos.equals((Object)new ChunkPos(-1, 0))) {
            xOffset = 8;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.leftXSize, this.bottomZSize, Corner.BL);
        }
        if (cPos.equals((Object)new ChunkPos(0, -1))) {
            zOffset = 8;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.rightXSize, this.topZSize, Corner.TR);
        }
        if (cPos.equals((Object)new ChunkPos(-1, -1))) {
            zOffset = 8;
            xOffset = 8;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.leftXSize, this.topZSize, Corner.TL);
        }
    }

    public void generateCorner(WorldGenRegion level, ChunkPos cPos, BlockPos.MutableBlockPos pos, int startX, int startZ, int xSize, int zSize, Corner corner) {
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < zSize; ++z) {
                for (int x = 0; x < xSize; ++x) {
                    pos.m_122178_(x + startX, SPAWN_POS.m_123342_() - y, z + startZ);
                    int strucX = x;
                    int strucZ = z;
                    switch (corner) {
                        case BL: {
                            strucZ += 8;
                            break;
                        }
                        case BR: {
                            strucX += 8;
                            strucZ += 8;
                            break;
                        }
                        case TL: {
                            break;
                        }
                        case TR: {
                            strucX += 8;
                        }
                    }
                    if (y == 0) {
                        this.stateToPlace(this.topOfPlatform.charAt(strucX + strucZ * this.width), level, pos);
                        continue;
                    }
                    if (y == 1) {
                        this.stateToPlace(this.structureTop.charAt(strucX + strucZ * this.width), level, pos);
                        continue;
                    }
                    if (y == this.height - 1) {
                        this.stateToPlace(this.structureBottom.charAt(strucX + strucZ * this.width), level, pos);
                        continue;
                    }
                    this.stateToPlace(this.structureMiddle.charAt(strucX + strucZ * this.width), level, pos);
                }
            }
        }
    }

    public int m_6337_() {
        return 0;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel, RandomState pRandom) {
        return 0;
    }

    public NoiseColumn m_214184_(int pX, int pZ, LevelHeightAccessor pHeight, RandomState pRandom) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213600_(List<String> pInfo, RandomState pRandom, BlockPos pPos) {
    }

    private static int distance(int firstX, int firstZ, int secondX, int secondZ) {
        return Math.max(Math.abs(firstX - secondX), Math.abs(firstZ - secondZ));
    }

    private void stateToPlace(char c, WorldGenRegion pLevel, BlockPos.MutableBlockPos pos) {
        switch (c) {
            case '0': {
                return;
            }
            case '1': {
                pLevel.m_7731_((BlockPos)pos, (BlockState)((Block)ModBlocks.mosaic_stained_glass.get()).m_49966_().m_61124_((Property)MosaicStainedGlassBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                break;
            }
            case '2': {
                pLevel.m_7731_((BlockPos)pos, (BlockState)((Block)ModBlocks.station_of_awakening_core.get()).m_49966_().m_61124_((Property)SoAPlatformCoreBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                ((SoAPlatformTileEntity)pLevel.m_7702_((BlockPos)pos)).setMultiblockFormed(true);
                break;
            }
            case '3': {
                this.createPedestal(pLevel, pos, new ItemStack((ItemLike)ModItems.dreamSword.get()));
                break;
            }
            case '4': {
                this.createPedestal(pLevel, pos, new ItemStack((ItemLike)ModItems.dreamShield.get()));
                break;
            }
            case '5': {
                this.createPedestal(pLevel, pos, new ItemStack((ItemLike)ModItems.dreamStaff.get()));
            }
        }
    }

    private void createPedestal(WorldGenRegion pLevel, BlockPos.MutableBlockPos pos, ItemStack toDisplay) {
        pLevel.m_7731_((BlockPos)pos, ((Block)ModBlocks.pedestal.get()).m_49966_(), 2);
        PedestalTileEntity te = (PedestalTileEntity)pLevel.m_7702_((BlockPos)pos);
        te.setStationOfAwakeningMarker(true);
        te.setDisplayStack(toDisplay);
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor pExecutor, Blender pBlender, RandomState pRandom, StructureManager pStructureManager, ChunkAccess pChunk) {
        return CompletableFuture.completedFuture(pChunk);
    }

    static enum Corner {
        TL,
        TR,
        BL,
        BR;

    }
}

