/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.station_of_sorrow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class StationOfSorrowChunkGenerator
extends ChunkGenerator {
    BiomeSource biomeSource;
    public static final Codec<StationOfSorrowChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(inst -> inst.biomeSource)).apply((Applicative)instance, instance.stable(StationOfSorrowChunkGenerator::new)));
    private static final BlockPos SPAWN_POS = new BlockPos(0, 25, 0);
    int width = 25;
    int baseY = 25;
    int depth = 25;
    int colHeight = 6;
    int leftXSize = 12;
    int rightXSize = 13;
    int topZSize = 12;
    int bottomZSize = 13;
    String structureTop = "0000000000111110000000000000000001144144110000000000300011144444441110003000000111114444444111110000000141411141414111414100000011411111141111114110000011414114414144114141100001111114444444441111110001111114144141441411111100144114441144411444114410144441444114441144414444114441114144141441411144411144444444442444444444411144411141441414414111444114444144411444114441444410144114441144411444114410011111141441414414111111000111111444444444111111000011414114414144114141100000114111111411111141100000014141114141411141410000000111114444444111110000003000111444444411100030000000000114414411000000000000000000111110000000000";

    public StationOfSorrowChunkGenerator(BiomeSource biomeSource) {
        super(biomeSource);
        this.biomeSource = biomeSource;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion pLevel, long pSeed, RandomState pRandom, BiomeManager pBiomeManager, StructureManager pStructureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }

    public void m_214194_(WorldGenRegion pLevel, StructureManager pStructureManager, RandomState pRandom, ChunkAccess pChunk) {
        int startX;
        int startZ;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        ChunkPos cPos = pChunk.m_7697_();
        int xOffset = 0;
        int zOffset = 0;
        if (cPos.equals((Object)new ChunkPos(0, 0))) {
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.rightXSize, this.bottomZSize, Corner.BR);
        }
        if (cPos.equals((Object)new ChunkPos(-1, 0))) {
            xOffset = 4;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.leftXSize, this.bottomZSize, Corner.BL);
        }
        if (cPos.equals((Object)new ChunkPos(0, -1))) {
            zOffset = 4;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.rightXSize, this.topZSize, Corner.TR);
        }
        if (cPos.equals((Object)new ChunkPos(-1, -1))) {
            zOffset = 4;
            xOffset = 4;
            startZ = cPos.m_45605_() + zOffset;
            startX = cPos.m_45604_() + xOffset;
            this.generateCorner(pLevel, cPos, blockpos$mutable, startX, startZ, this.leftXSize, this.topZSize, Corner.TL);
        }
    }

    public void generateCorner(WorldGenRegion level, ChunkPos cPos, BlockPos.MutableBlockPos pos, int startX, int startZ, int xSize, int zSize, Corner corner) {
        for (int y = 0; y < this.baseY; ++y) {
            for (int z = 0; z < zSize; ++z) {
                for (int x = 0; x < xSize; ++x) {
                    pos.m_122178_(x + startX, SPAWN_POS.m_123342_() - y, z + startZ);
                    int strucX = x;
                    int strucZ = z;
                    switch (corner) {
                        case BL: {
                            strucZ += 12;
                            break;
                        }
                        case BR: {
                            strucX += 12;
                            strucZ += 12;
                            break;
                        }
                        case TL: {
                            break;
                        }
                        case TR: {
                            strucX += 12;
                        }
                    }
                    if (y != 1) continue;
                    this.stateToPlace(this.structureTop.charAt(strucX + strucZ * this.width), (LevelAccessor)level, pos);
                }
            }
        }
    }

    public void m_6929_(WorldGenRegion pLevel) {
    }

    public int m_6331_() {
        return 0;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor pExecutor, Blender pBlender, RandomState pRandom, StructureManager pStructureManager, ChunkAccess pChunk) {
        return CompletableFuture.completedFuture(pChunk);
    }

    public int m_6337_() {
        return 0;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel, RandomState pRandom) {
        return 0;
    }

    public NoiseColumn m_214184_(int pX, int pZ, LevelHeightAccessor pHeight, RandomState pRandom) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_213600_(List<String> pInfo, RandomState pRandom, BlockPos pPos) {
    }

    private static int distance(int firstX, int firstZ, int secondX, int secondZ) {
        return Math.max(Math.abs(firstX - secondX), Math.abs(firstZ - secondZ));
    }

    private void stateToPlace(char c, LevelAccessor world, BlockPos.MutableBlockPos pos) {
        switch (c) {
            case '0': {
                return;
            }
            case '1': {
                world.m_7731_((BlockPos)pos, Blocks.f_50333_.m_49966_(), 2);
                break;
            }
            case '2': {
                world.m_7731_((BlockPos)pos, Blocks.f_50714_.m_49966_(), 2);
                break;
            }
            case '3': {
                for (int i = -1; i < this.colHeight; ++i) {
                    world.m_7731_((BlockPos)pos, Blocks.f_50283_.m_49966_(), 2);
                    pos.m_142448_(pos.m_123342_() + 1);
                }
                break;
            }
            case '4': {
                world.m_7731_((BlockPos)pos, Blocks.f_50498_.m_49966_(), 2);
            }
        }
    }

    static enum Corner {
        TL,
        TR,
        BL,
        BR;

    }
}

