package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.item.*;
import online.kingdomkeys.kingdomkeys.lib.Strings;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSSynthesiseRecipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

import java.awt.*;
import java.util.List;
import java.util.*;
import java.util.Map.Entry;

import static online.kingdomkeys.kingdomkeys.lib.Strings.*;

public class SynthesisCreateScreen extends MenuFilterable {

	// MenuFilterBar filterBar;
	MenuBox boxL, boxM, boxRT, boxRB;
	MenuButton create;
	private MenuButton back;
	SynthesisScreen parent;

	public SynthesisCreateScreen(SynthesisScreen parent) {
		super(Strings.Gui_Synthesis_Synthesise_Title, new Color(0, 255, 0));
		drawSeparately = true;
		this.parent = parent;
	}

	protected void action(String string) {
		switch (string) {
		case "create":
			PacketHandler.sendToServer(new CSSynthesiseRecipe(selectedRL));
			minecraft.level.playSound(minecraft.player, minecraft.player.blockPosition(), ModSounds.itemget.get(), SoundSource.MASTER, 1.0f, 1.0f);
			break;
		}
	}
	
	@Override
	public void init() {
		float boxPosX = (float) width * 0.1437F;
		float topBarHeight = (float) height * 0.17F;
		float boxWidth = (float) width * 0.3F;
		float middleHeight = (float) height * 0.6F;
		boxL = new MenuBox((int) boxPosX, (int) topBarHeight, (int) boxWidth, (int) middleHeight,1, new Color(40, 4, 255));
		boxM = new MenuBox((int) boxPosX + (int) boxWidth, (int) topBarHeight, (int) (boxWidth*0.7F), (int) middleHeight,1, new Color(108, 40, 40));
		boxRT = new MenuBox(boxM.getX() + (int) (boxWidth*0.7F), (int) topBarHeight, (int) (boxWidth*1.17F), (int) (middleHeight*0.2F),1, new Color(0, 0, 0));
		boxRB = new MenuBox(boxM.getX() + (int) (boxWidth*0.7F), (int) topBarHeight + boxRT.getHeight(), (int) (boxWidth*1.17F), (int) (middleHeight - boxRT.getHeight()),1, new Color(4, 68, 4));
		int scrollTop = (int) topBarHeight;
		int scrollBot = (int) (scrollTop + middleHeight);
		scrollBar = new MenuScrollBar((int) (boxPosX + boxWidth - 17), scrollTop, scrollBot, (int) middleHeight, 0);
		scrollBar2 = new MenuScrollBar(boxRB.getX() + boxRB.getWidth() - 17, boxRB.getY(), boxRB.getY()+boxRB.getHeight(), (int) middleHeight, 0);
		addRenderableWidget(scrollBar);
		addRenderableWidget(scrollBar2);
		float filterPosX = width * 0.3F;
		float filterPosY = height * 0.02F;
		filterBar = new MenuFilterBar((int) filterPosX, (int) filterPosY, this);
		filterBar.init();
		initItems();

		buttonPosX -= 10;
		buttonWidth = ((float)width * 0.07F);
		// addButton(scrollBar = new MenuScrollBar());
		super.init();
		
	}

	@Override
	public void initItems() {
		float invPosX = (float) width * 0.1494F;
		float invPosY = (float) height * 0.1851F;
		inventory.clear();
		children().clear();
		renderables.clear();
		filterBar.buttons.forEach(this::addWidget);

		List<ResourceLocation> items = new ArrayList<>();
		IPlayerCapabilities playerData = ModCapabilities.getPlayer(minecraft.player);
		for (int i = 0; i < playerData.getKnownRecipeList().size(); i++) {
			ResourceLocation itemName = playerData.getKnownRecipeList().get(i);
			Recipe recipe = RecipeRegistry.getInstance().getValue(itemName);
			if(recipe != null) {
				ResourceLocation recipeRL = recipe.getRegistryName();
				ItemStack stack = new ItemStack(recipe.getResult());

				if (recipe.getResult() instanceof KeychainItem)
					stack = new ItemStack(((KeychainItem) recipe.getResult()).getKeyblade());

				if (filterItem(stack)) {
					items.add(recipeRL);
				}
			} else {
				KingdomKeys.LOGGER.error(itemName +" is not a valid recipe, check it");
			}
		}
		items.sort(Comparator.comparing(Utils::getCategoryForRecipe).thenComparing(stack -> new ItemStack(RecipeRegistry.getInstance().getValue(stack).getResult()).getHoverName().getContents().toString()));

		for (int i = 0; i < items.size(); i++) {
			ItemStack itemStack = new ItemStack(RecipeRegistry.getInstance().getValue(items.get(i)).getResult());
			if(itemStack != null && itemStack.getItem() instanceof KeychainItem) {
				itemStack = new ItemStack(((KeychainItem) RecipeRegistry.getInstance().getValue(items.get(i)).getResult()).getKeyblade());
			}
			MenuStockItem item = new MenuStockItem(this, items.get(i), itemStack, (int) invPosX, (int) invPosY + (i * 14), boxL.getWidth()-scrollBar.getWidth()-6, false);
			item.setBackgroundColor(new Color(30,30,100));
			inventory.add(item);
		}

		inventory.forEach(this::addWidget);

		super.init();
		create = new MenuButton(boxM.getX()+boxM.getWidth()/2 - (int)(buttonWidth+22)/2, (int) (height * 0.67),(int)buttonWidth, Strings.Gui_Synthesis_Synthesise_Create, MenuButton.ButtonType.ROUNDBUTTON,(e) -> {
			action("create");
		});
		create.setCenterText(true);
		addRenderableWidget(create);

		addRenderableWidget(back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)buttonWidth/2, Component.translatable(Strings.Gui_Menu_Back).getString(), MenuButton.ButtonType.BUTTON, b -> minecraft.setScreen(new SynthesisScreen(parent.invFile, parent.name, parent.moogle))));

	}

	@Override
	public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
		drawMenuBackground(gui, mouseX, mouseY, partialTicks);
		boxL.renderWidget(gui, mouseX, mouseY, partialTicks);
		boxM.renderWidget(gui, mouseX, mouseY, partialTicks);
		boxRB.renderWidget(gui, mouseX, mouseY, partialTicks);
		boxRT.renderWidget(gui, mouseX, mouseY, partialTicks);
		super.render(gui, mouseX, mouseY, partialTicks);

		if(!inventory.isEmpty()) {
			int listHeight = (inventory.get(inventory.size() - 1).getY() + 20) - inventory.get(0).getY() + 3;
			scrollBar.setContentHeight(listHeight);
		}

		if (selectedItemStack != ItemStack.EMPTY) {
			IPlayerCapabilities playerData = ModCapabilities.getPlayer(minecraft.player);
			boolean enoughMats = true;
			boolean enoughMunny = false;
			boolean enoughTier = false;
			boolean enoughSpace = false;
			if (RecipeRegistry.getInstance().containsKey(selectedRL)) {
				Recipe recipe = RecipeRegistry.getInstance().getValue(selectedRL);
				enoughSpace = Utils.getFreeSlotsForPlayer(minecraft.player) >= Utils.stacksForItemAmount(new ItemStack(recipe.getResult()), recipe.getAmount());
				enoughMunny = playerData.getMunny() >= recipe.getCost();
				enoughTier = !ModConfigs.requireSynthTier || playerData.getSynthLevel() >= recipe.getTier();
				create.visible = true;
				// item.getRecipe().getMaterials().entrySet().iterator();//item.data.getLevelData(item.getKeybladeLevel()).getMaterialList().entrySet().iterator();
				for (Entry<Item, Integer> m : recipe.getMaterials().entrySet()) {
					if (playerData.getMaterialAmount(m.getKey()) < m.getValue()) {
						enoughMats = false;
					}
				}

			}

			create.active = enoughMats && enoughMunny && enoughTier && enoughSpace;
			if(!enoughSpace) { //TODO somehow make this detect in singleplayer the inventory changes
				create.setMessage(Component.translatable(Strings.Gui_Shop_NoSpace));
			} else {
				create.setMessage(Component.translatable(Strings.Gui_Synthesis_Synthesise_Create));
			}
			create.visible = RecipeRegistry.getInstance().containsKey(selectedRL);
		} else {
			create.visible = false;
		}

		for(Renderable renderable : this.inventory){
			if(renderable instanceof MenuStockItem menuStockItem){
				menuStockItem.active = true;
				gui.enableScissor(boxL.getX()+2,scrollBar.getY()+2,boxL.getX()+boxL.getWidth(),scrollBar.getBottom()-5); //Arbitrary number to hide the cut one
				renderable.render(gui,mouseX,mouseY,partialTicks);
				gui.disableScissor();
			} else {
				renderable.render(gui,mouseX,mouseY,partialTicks);
			}
		}

		//Render synth level
		IPlayerCapabilities playerData = ModCapabilities.getPlayer(minecraft.player);
		gui.drawString(minecraft.font, Utils.translateToLocal(Gui_Synthesis_Exp_MoogleLevel)+": "+playerData.getSynthLevel(), boxRT.getX()+7, boxRT.getY()+6, 0xFFFF00);

		String line = Utils.translateToLocal(Gui_Menu_Main_Synthesis_Tier)+": "+Utils.getTierFromInt(playerData.getSynthLevel());
		gui.drawString(minecraft.font, line, boxRT.getX()+boxRT.getWidth()-minecraft.font.width(line)-5, boxRT.getY()+6, 0xFFFFFF);

		line = Utils.translateToLocal(Gui_Synthesis_Exp_NextLevel)+": ";
		gui.drawString(minecraft.font, line, boxRT.getX()+7, boxRT.getY()+18, 0xFFFF00);

		line = playerData.getSynthLevel() >= 7 ? "0 "+Utils.translateToLocal(Strings.Gui_Synthesis_Exp): playerData.getSynthExpNeeded(playerData.getSynthLevel(),playerData.getSynthExperience())+" "+Utils.translateToLocal(Strings.Gui_Synthesis_Exp);
		gui.drawString(minecraft.font, line, boxRT.getX()+boxRT.getWidth()-minecraft.font.width(line)-5, boxRT.getY()+18, 0xFFFFFF);

		create.render(gui, mouseX,  mouseY,  partialTicks);
		back.render(gui, mouseX, mouseY, partialTicks);
	}

	@Override
	protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
		PoseStack matrixStack = gui.pose();
		float tooltipPosX = width * 0.3333F;
		float tooltipPosY = height * 0.8F;

		float iconPosX = boxRT.getX();
		float iconPosY = boxRT.getY() + 25;

		IPlayerCapabilities playerData = ModCapabilities.getPlayer(minecraft.player);

		matrixStack.pushPose();
		{
			double offset = (boxM.getWidth()*0.1F);
			matrixStack.translate(boxM.getX() + offset/2, iconPosY, 1);

			if(RecipeRegistry.getInstance().containsKey(selectedRL)) {
				Recipe recipe = RecipeRegistry.getInstance().getValue(selectedRL);
				gui.drawString(minecraft.font, Utils.translateToLocal(Strings.Gui_Shop_Buy_Cost)+" ", 2, -20, Color.yellow.getRGB());
				String line = recipe.getCost()+" "+Utils.translateToLocal(Strings.Gui_Menu_Main_Munny);
				gui.drawString(minecraft.font, line, boxM.getWidth() - minecraft.font.width(line) - 10, -20, recipe.getCost() > playerData.getMunny() ? Color.RED.getRGB() : Color.GREEN.getRGB());

				gui.drawString(minecraft.font, Utils.translateToLocal(Strings.Gui_Shop_Tier)+" ", 2, -10, Color.yellow.getRGB());
				line = Utils.getTierFromInt(recipe.getTier())+" - "+(10 + recipe.getTier()*2)+" "+Utils.translateToLocal(Strings.Gui_Synthesis_Exp);
				Color color = Color.GREEN; // If you have enough tier it will be green, otherwise will be white or red based on the config.ja m'ho va dir en el
				if(recipe.getTier() > playerData.getSynthLevel()) {
					color = ModConfigs.requireSynthTier ? Color.RED : Color.WHITE;
				}
				gui.drawString(minecraft.font, line, boxM.getWidth() - minecraft.font.width(line) - 10, -10,  color.getRGB());
			}
			float size = 80;
			matrixStack.translate(boxM.getWidth()*0.7F / 2,boxM.getHeight()/2 - size / 2,0);
			ClientUtils.drawItemAsIcon(selectedItemStack, matrixStack, 0, -10, (int)size);
		}
		matrixStack.popPose();

		if (selectedItemStack != null && selectedItemStack.getItem() instanceof KeybladeItem || selectedItemStack.getItem() instanceof KKAccessoryItem || selectedItemStack.getItem() instanceof KKArmorItem) {
			String desc = "";
			String ability = "";
			if(selectedItemStack.getItem() instanceof KeybladeItem kb) {
				desc = kb.getDesc();
				ability = kb.data.getLevelAbility(0);
			} else if(selectedItemStack.getItem() instanceof KKAccessoryItem accessory) {
				ability = !accessory.getAbilities().isEmpty() ? accessory.getAbilities().get(0) : null;
			}

			matrixStack.pushPose();
			{
				matrixStack.translate(boxM.getX()+20, height*0.58, 1);
				List<Component> stats = Utils.getResistancesStats(selectedItemStack);

				float scale = stats.size() > 4 ? 1F-(stats.size()-4)*0.25F: 1F;
				matrixStack.scale(scale, scale, scale);

				int offset = -10;
				for(int i=0;i<stats.size();i++){
					Component c = stats.get(i);
					gui.drawString(minecraft.font, c, 0, offset+(10*i), 0x4444FF);
				}

				if(ability != null) {
					Ability a = ModAbilities.registry.get().getValue(new ResourceLocation(ability));
					if(a != null) {
						String abilityName = Utils.translateToLocal(a.getTranslationKey());
						gui.drawString(minecraft.font, abilityName, -20 + (boxM.getWidth()/2) - (minecraft.font.width(abilityName)/2), (stats.size()-1)*10, 0xFFAA44);
					}
				}
			}
			matrixStack.popPose();

			if(!desc.equals("")) {
				matrixStack.pushPose();
				{
					String text = Utils.translateToLocal(selectedItemStack.getDescriptionId());
					gui.drawString(minecraft.font, text, (int)(tooltipPosX + 5), (int) (tooltipPosY)+5, 0xFF9900);
					ClientUtils.drawSplitString(gui, desc, (int) tooltipPosX + 5, (int) tooltipPosY + 5 + minecraft.font.lineHeight, (int) (width * 0.6F), 0xFFFFFF);
				}
				matrixStack.popPose();
			}

		}

		//Materials
		{
			if(RecipeRegistry.getInstance().containsKey(selectedRL)) {
				Recipe recipe = RecipeRegistry.getInstance().getValue(selectedRL);
				Iterator<Entry<Item, Integer>> materials = Utils.getSortedMaterials(recipe.getMaterials()).entrySet().iterator();
				int i = 0;														//MAX Y
				int listHeight = (boxRB.getPosY()+10 + (recipe.getMaterials().size()+1)*16)+10 - boxRB.getPosY()+10;
				scrollBar2.setContentHeight(listHeight);
				int startX = (int) iconPosX + 20;
				int startY = boxRB.getPosY()+10;
				gui.enableScissor(boxRB.getX()+2,scrollBar2.getY()+2,boxRB.getX()+boxRB.getWidth(),scrollBar2.getBottom()-5); //Arbitrary number to hide the cut one
				while(materials.hasNext()) {
					Entry<Item, Integer> m = materials.next();
					ItemStack stack = new ItemStack(m.getKey());
					String name = Utils.translateToLocal(stack.getDescriptionId());
					String mats = " x"+m.getValue()+" ("+playerData.getMaterialAmount(m.getKey())+")";

					int color = playerData.getMaterialAmount(m.getKey()) >= m.getValue() ?  0x00FF00 : 0xFF0000;
					ClientUtils.drawScrollingString(gui,minecraft.font,Component.literal(name), startX, scrollBar2.getX() - minecraft.font.width(mats), startY + (int) ((i*16)-scrollBar2.scrollOffset), color, false);
					gui.drawString(minecraft.font, mats, scrollBar2.getX() - minecraft.font.width(mats), startY + (int) ((i*16)-scrollBar2.scrollOffset)+1, color);
					ClientUtils.drawItemAsIcon(stack, matrixStack, startX -17, boxRB.getPosY()+10 + (int)((i*16)-4-scrollBar2.scrollOffset), 16);
					i++;
				}
				gui.disableScissor();
			}
		}
	}

	@Override
	public boolean isPauseScreen() {
		return false;
	}

	@Override
	public void onClose() {
		if (parent.moogle != -1) {
			PacketHandler.sendToServer(new CSCloseMoogleGUI(parent.moogle));
		}
		super.onClose();
	}

	@Override
	public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
		scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
		scrollBar2.mouseClicked(mouseX, mouseY, mouseButton);
		return super.mouseClicked(mouseX, mouseY, mouseButton);
	}

	@Override
	public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
		scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
		scrollBar2.mouseReleased(pMouseX, pMouseY, pButton);
		return super.mouseReleased(pMouseX, pMouseY, pButton);
	}

	@Override
	public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
		scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
		scrollBar2.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
		updateScroll();
		return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
	}

	public void updateScroll() {
		inventory.forEach(button -> {
			button.offsetY = (int) scrollBar.scrollOffset;
		});
	}

	@Override
	public boolean mouseScrolled(double mouseX, double mouseY, double deltaY) {
		if(mouseX >= boxL.getX() && mouseX <= scrollBar.getX()+ scrollBar.getWidth())
			scrollBar.mouseScrolled(mouseX, mouseY, deltaY);
		if(mouseX >= boxRB.getX() && mouseX <= scrollBar2.getX()+ scrollBar2.getWidth())
			scrollBar2.mouseScrolled(mouseX, mouseY, deltaY);
		updateScroll();
		return false;
	}
}