package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class ShadowGoal extends TargetGoal {
	// 1 - in Shadow ; 0 - in Overworld

	private final int MAX_DISTANCE_FOR_AI = 100, MAX_DISTANCE_FOR_LEAP = 10, MAX_DISTANCE_FOR_DASH = 25, TIME_BEFORE_NEXT_ATTACK = 70, TIME_OUTSIDE_THE_SHADOW = 70;
	private int shadowTicks = 70, oldAi = -1, ticksUntilNextAttack;
	public boolean canUseNextAttack = true;
	public double originalAttackDamage;

	public ShadowGoal(PathfinderMob creature) {
		super(creature, true);
		ticksUntilNextAttack = TIME_BEFORE_NEXT_ATTACK;   
		this.originalAttackDamage = creature.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
		this.mob = (BaseKHEntity) creature;
	}
	private final BaseKHEntity mob;


	@Override
	public boolean canContinueToUse() {
		if(this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() > 0)
			this.originalAttackDamage = this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();

		if (this.mob.getTarget() != null && this.mob.distanceToSqr(this.mob.getTarget()) < MAX_DISTANCE_FOR_AI) {
		
			if (this.mob.onGround()) {
				if (!isInShadow()) {
					shadowTicks-=2;
					if (shadowTicks <= 0) {
						EntityHelper.setState(mob,1);
	                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0D);
						canUseNextAttack = false;
					}
				} else {
				//	this.goalOwner.setInvisible(false);
				}
			}

			if (isInShadow()) {
				this.mob.setInvulnerable(true);
				//this.goalOwner.setInvisible(true);
				canUseNextAttack = false;
				shadowTicks+=2;
				if (shadowTicks >= TIME_OUTSIDE_THE_SHADOW) {
					EntityHelper.setState(mob,0);
					this.mob.setInvulnerable(false);
					canUseNextAttack = true;
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(originalAttackDamage);
				}
			}

			EntityHelper.Dir dir = EntityHelper.get8Directions(this.mob);
			int currentAi = this.mob.level().random.nextInt(2);

			if (!canUseNextAttack) {
				ticksUntilNextAttack-=2;
				if (ticksUntilNextAttack <= 0) {
					canUseNextAttack = true;
					ticksUntilNextAttack = TIME_BEFORE_NEXT_ATTACK;
				}
			}

			if (oldAi != -1 && canUseNextAttack) {
				if (currentAi == 0 && oldAi == 0)
					currentAi = 1;
				if (currentAi == 1 && oldAi == 1)
					currentAi = 0;
			}

			// Leaping
			if (this.mob.onGround() && this.mob.distanceToSqr(this.mob.getTarget()) <= MAX_DISTANCE_FOR_LEAP && currentAi == 0 && canUseNextAttack) {
				oldAi = 0;

				this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0.5, 0));

				switch (dir) {
				case NORTH:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0, -0.7));
					break;
				case NORTH_WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0, -0.7));
					break;
				case SOUTH:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0, 0.7));
					break;
				case NORTH_EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0, -0.7));
					break;
				case WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0, 0));
					break;
				case SOUTH_WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0, 0.7));
					break;
				case EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0, 0));
					break;
				case SOUTH_EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0, 0.7));
					break;
				}

				if (this.mob.level().random.nextInt(2) == 0) {
					EntityHelper.setState(mob,0);
					this.mob.setInvulnerable(false);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(originalAttackDamage);
				} else {
					EntityHelper.setState(mob,1);
					this.mob.setInvulnerable(true);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0D);
				}

				canUseNextAttack = false;
			}

			// Dash
			if (this.mob.onGround() && this.mob.distanceToSqr(this.mob.getTarget()) <= MAX_DISTANCE_FOR_DASH && currentAi == 1 && canUseNextAttack) {
				oldAi = 1;

				this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0.2, 0));

				switch (dir) {
				case NORTH:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0, -1));
					break;
				case NORTH_WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1, 0, -1));
					break;
				case SOUTH:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0, 0, 1));
					break;
				case NORTH_EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1, 0, -1));
					break;
				case WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1, 0, 0));
					break;
				case SOUTH_WEST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1, 0, 1));
					break;
				case EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1, 0, 0));
					break;
				case SOUTH_EAST:
					this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1, 0, 1));
					break;
				}

				if (this.mob.level().random.nextInt(2) == 0) {
					EntityHelper.setState(mob,0);
					this.mob.setInvulnerable(false);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(originalAttackDamage);
				} else {
					EntityHelper.setState(mob,1);
					this.mob.setInvulnerable(true);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0D);
				}

				canUseNextAttack = false;
			}

			return true;
		}
		EntityHelper.setState(mob,0);
		this.mob.setInvulnerable(false);
        this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(originalAttackDamage);
		return false;
	}

	@Override
	public void start() {
		EntityHelper.setState(mob,0);
		this.mob.setInvulnerable(false);
	}

	public boolean isInShadow() {
		return EntityHelper.getState(mob) == 1;
	}

	@Override
	public boolean canUse() {
		return this.mob.getTarget() != null && this.mob.distanceToSqr(this.mob.getTarget()) < MAX_DISTANCE_FOR_AI;
	}

}