package online.kingdomkeys.kingdomkeys.datagen;

import java.util.Collections;
import java.util.Set;

import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.datagen.init.*;
import online.kingdomkeys.kingdomkeys.datagen.provider.BaseLootTableProvider;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {

	 private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder()
	            .add(Registries.DAMAGE_TYPE, KKDamageTypes::bootstrap);
	 
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
    	DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();

        final ExistingFileHelper existingFileHelper = event.getExistingFileHelper();

        //Datapack Registry providers
        generator.addProvider(event.includeServer(), new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), BUILDER, Set.of(KingdomKeys.MODID)));
       
        //tags
        BlockTagsGen blockTags = new BlockTagsGen(generator, event.getLookupProvider(), existingFileHelper);
        generator.addProvider(event.includeServer(), blockTags);
        generator.addProvider(event.includeServer(), new ItemTagsGen(generator.getPackOutput(), event.getLookupProvider(), blockTags.contentsGetter(), existingFileHelper));
        //generator.addProvider(event.includeServer(), new EntityTagsGen(generator, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), new Recipes(generator, event.getLookupProvider()));
        generator.addProvider(event.includeClient(), new BlockStates(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), new ItemModels(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), new AtlasProvider(generator, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(event.includeClient(), new BlockModels(generator, existingFileHelper));
        generator.addProvider(event.includeServer(), new KeybladeStats(generator, existingFileHelper));
        generator.addProvider(event.includeServer(), new BaseLootTableProvider(output, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), new SynthesisRecipe(generator, existingFileHelper));
        //probably should use the forge provider generator.addProvider(event.includeServer(), new KKAdvancementProvider(generator.getPackOutput(), event.getLookupProvider(), ));
        generator.addProvider(event.includeClient(), new LanguageENUS(generator));
        generator.addProvider(event.includeClient(), new LanguageESES(generator));
        generator.addProvider(event.includeClient(), new LanguageENGB(generator));
        generator.addProvider(event.includeClient(), new Sounds(generator, existingFileHelper));
        
       // generator.addProvider(event.includeServer(), new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), BUILDER, Set.of(KingdomKeys.MODID)));

    }
}
