package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class LanceEntity extends KKThrowableEntity{

	int maxTicks = 100;
	boolean stopped = false;

	public LanceEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
		super(type, world);
		this.blocksBuilding = true;
	}

	public LanceEntity(Level world) {
		super(ModEntities.TYPE_LANCE.get(), world);
		this.blocksBuilding = true;
	}

	@Override
	protected double getDefaultGravity() {
		return 0D;
	}

	@Override
	public void tick() {
		if (this.tickCount > maxTicks) {
			this.remove(RemovalReason.KILLED);
		}

		if (!isStopped()) {
			if (tickCount > 2)
				level().addParticle(ParticleTypes.CRIT, getX(), getY(), getZ(), 0, 0, 0);

			if (this.onGround()) {
				this.setOnGround(false);
				this.setDeltaMovement(this.getDeltaMovement().multiply(this.random.nextFloat() * 0.2F, this.random.nextFloat() * 0.2F, this.random.nextFloat() * 0.2F));
			}

			HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
			boolean flag = false;
			if (raytraceresult.getType() == HitResult.Type.BLOCK) {
				BlockPos blockpos = ((BlockHitResult) raytraceresult).getBlockPos();
				BlockState blockstate = this.level().getBlockState(blockpos);
				if (blockstate.is(Blocks.NETHER_PORTAL) || blockstate.is(Blocks.END_GATEWAY)) {
					this.handlePortal();
					flag = true;
				} else {
					setStopped(true);
				}
			}

			if (raytraceresult.getType() != HitResult.Type.MISS && !flag && !NeoForge.EVENT_BUS.post(new ProjectileImpactEvent(this, raytraceresult)).isCanceled()) {
				this.onHit(raytraceresult);
			}

			if (!stopped) {
				Vec3 vec3d = this.getDeltaMovement();
				double d0 = this.getX() + vec3d.x;
				double d1 = this.getY() + vec3d.y;
				double d2 = this.getZ() + vec3d.z;
				float f1;
				if (this.isInWater()) {
					for (int i = 0; i < 4; ++i) {
						this.level().addParticle(ParticleTypes.BUBBLE, d0 - vec3d.x * 0.25D, d1 - vec3d.y * 0.25D, d2 - vec3d.z * 0.25D, vec3d.x, vec3d.y, vec3d.z);
					}

					f1 = 0.8F;
				} else {
					f1 = 0.99F;
				}

				this.setDeltaMovement(vec3d.scale(f1));
				if (!this.isNoGravity()) {
					Vec3 vec3d1 = this.getDeltaMovement();
					this.setDeltaMovement(vec3d1.x, vec3d1.y - this.getGravity(), vec3d1.z);
				}

				this.setPos(d0, d1, d2);
			}
		}

	}
	
	public void stopLance(){
		setStopped(true);
		this.setDeltaMovement(this.getDeltaMovement().scale(0.001));
	}
	
	@Override
	protected void onHit(HitResult rtRes) {
		if (!level().isClientSide) {
			EntityHitResult ertResult = null;
			BlockHitResult brtResult = null;

			if (rtRes instanceof EntityHitResult) {
				ertResult = (EntityHitResult) rtRes;
			}

			if (rtRes instanceof BlockHitResult) {
				brtResult = (BlockHitResult) rtRes;
			}

			if (ertResult != null && ertResult.getEntity() != null && ertResult.getEntity() instanceof LivingEntity target) {
                if (target != getOwner()) {
	            	target.hurt(target.damageSources().thrown(this, this.getProjOwner()), dmg < 4 ? 4 : dmg);
					dmg *= 0.9F;
				}
			} else { // Block (not ERTR)
				if(brtResult != null) {
					
					if(level().getBlockState(brtResult.getBlockPos()).getBlock() == Blocks.TALL_GRASS || level().getBlockState(brtResult.getBlockPos()).getBlock() == Blocks.GRASS_BLOCK || level().getBlockState(brtResult.getBlockPos()).getBlock() == Blocks.SUGAR_CANE) {
					
					} else {
						stopLance();	
					}
				}
			}
		}


	}

	public int getMaxTicks() {
		return maxTicks;
	}

	public void setMaxTicks(int maxTicks) {
		this.maxTicks = maxTicks;
	}
	
	private static final EntityDataAccessor<Boolean> STOPPED = SynchedEntityData.defineId(LanceEntity.class, EntityDataSerializers.BOOLEAN);

	public boolean isStopped() {
		return stopped;
	}

	public void setStopped(boolean stopped) {
		this.entityData.set(STOPPED, stopped);
		this.stopped = stopped;
	}
	
	@Override
	public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
		super.onSyncedDataUpdated(key);
		if (key.equals(STOPPED)) {
			this.stopped = this.getStoppedDataManager();
		}
	}
	
	@Override
	public void addAdditionalSaveData(CompoundTag compound) {
		super.addAdditionalSaveData(compound);
		compound.putBoolean("Stopped", this.isStopped());
	}

	@Override
	public void readAdditionalSaveData(CompoundTag compound) {
		super.readAdditionalSaveData(compound);
		this.setStopped(compound.getBoolean("Stopped"));
	}

	@Override
	protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
		super.defineSynchedData(pBuilder);
		pBuilder.define(STOPPED, false);
	}

	public boolean getStoppedDataManager() {
		return this.entityData.get(STOPPED);
	}
	
	
}
