package online.kingdomkeys.kingdomkeys.item;

import com.google.common.collect.Lists;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.lib.Strings;
import online.kingdomkeys.kingdomkeys.util.Utils;

import java.util.List;

public class KKAccessoryItem extends Item implements IItemCategory {

	int ap,str,mag;
	String[] abilities;
	
    public KKAccessoryItem(Properties properties, int AP, int str, int mag, String[] abilities) {
        super(properties);
		this.ap = AP;
		this.str = str;
		this.mag = mag;
		this.abilities = abilities;
    }

    @OnlyIn(Dist.CLIENT)
    @Override
    public void appendHoverText(ItemStack stack, TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
    	if(getAp() != 0) {
    		tooltip.add(Component.translatable(ChatFormatting.YELLOW+Utils.translateToLocal(Strings.Gui_Menu_Status_AP)+": "+getAp()));
    	}
    	if(getStr() != 0) {
    		tooltip.add(Component.translatable(ChatFormatting.RED+Utils.translateToLocal(Strings.Gui_Menu_Status_Strength)+": "+getStr()));
    	}
    	if(getMag() != 0) {
    		tooltip.add(Component.translatable(ChatFormatting.BLUE+Utils.translateToLocal(Strings.Gui_Menu_Status_Magic)+": "+getMag()));
    	}
    	if(!getAbilities().isEmpty()) {
			tooltip.add(Component.translatable(ChatFormatting.GOLD+Utils.translateToLocal(Strings.Gui_Menu_Status_Abilities)+":"));
    		for(String a : getAbilities()) {
    			Ability ability = ModAbilities.registry.get(ResourceLocation.parse(a));
				if (ability != null) {
					tooltip.add(Component.translatable(ChatFormatting.GOLD+"- " + Utils.translateToLocal(ability.getTranslationKey())));
				}
    		}
    	}
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }
    
    public int getAp() {
		return ap;
	}

	public void setAp(int ap) {
		this.ap = ap;
	}

	public int getStr() {
		return str;
	}

	public void setStr(int str) {
		this.str = str;
	}

	public int getMag() {
		return mag;
	}

	public void setMag(int mag) {
		this.mag = mag;
	}

	public List<String> getAbilities() {
		return abilities == null ? Lists.newArrayList() : Lists.newArrayList(abilities);
	}

	public void setAbilities(String[] abilities) {
		this.abilities = abilities;
	}

	@Override
	public ItemCategory getCategory() {
		return ItemCategory.ACCESSORIES;
	}

	@Override
	public String toString() {
		return super.toString(); //ap+" "+str+" "+mag;
	}
}
