/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.fabric.config;

import com.anthonyhilyard.iceberg.Iceberg;
import java.util.function.Predicate;

class Range<V>
implements Predicate<Object> {
    private final Class<? extends V> clazz;
    private final V min;
    private final V max;

    Range(Class<V> clazz, V min, V max) {
        this.clazz = clazz;
        this.min = min;
        this.max = max;
    }

    public Class<? extends V> getClazz() {
        return this.clazz;
    }

    public V getMin() {
        return this.min;
    }

    public V getMax() {
        return this.max;
    }

    private boolean isNumber(Object other) {
        return Number.class.isAssignableFrom(this.clazz) && other instanceof Number;
    }

    @Override
    public boolean test(Object t) {
        if (this.isNumber(t)) {
            boolean result;
            Number n = (Number)t;
            boolean bl = result = ((Number)this.min).doubleValue() <= n.doubleValue() && n.doubleValue() <= ((Number)this.max).doubleValue();
            if (!result) {
                Iceberg.LOGGER.debug("Range value {} is not within its bounds {}-{}", (Object)n.doubleValue(), (Object)((Number)this.min).doubleValue(), (Object)((Number)this.max).doubleValue());
            }
            return result;
        }
        if (!this.clazz.isInstance(t)) {
            return false;
        }
        if (t instanceof Comparable) {
            boolean result;
            Comparable c = (Comparable)t;
            boolean bl = result = c.compareTo(this.min) >= 0 && c.compareTo(this.max) <= 0;
            if (!result) {
                Iceberg.LOGGER.debug("Range value {} is not within its bounds {}-{}", (Object)c, this.min, this.max);
            }
            return result;
        }
        return false;
    }

    public V correct(V value, V defaultValue) {
        if (this.isNumber(value)) {
            Number n = (Number)value;
            return n.doubleValue() < ((Number)this.min).doubleValue() ? this.min : (n.doubleValue() > ((Number)this.max).doubleValue() ? this.max : value);
        }
        if (!this.clazz.isInstance(value)) {
            return defaultValue;
        }
        if (value instanceof Comparable) {
            Comparable c = (Comparable)value;
            return c.compareTo(this.min) < 0 ? this.min : (c.compareTo(this.max) > 0 ? this.max : value);
        }
        return defaultValue;
    }

    public String toString() {
        if (this.clazz == Integer.class) {
            if (this.max.equals(Integer.MAX_VALUE)) {
                return "> " + String.valueOf(this.min);
            }
            if (this.min.equals(Integer.MIN_VALUE)) {
                return "< " + String.valueOf(this.max);
            }
        }
        return String.valueOf(this.min) + " ~ " + String.valueOf(this.max);
    }
}

