/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.mixin.accessor.EndDragonFightAccessor;
import com.yungnickyoung.minecraft.betterendisland.world.IBetterDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.util.ExitPortalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_174;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2881;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3666;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public enum DragonRespawnStage implements class_3542
{
    START("start"){

        @Override
        public void tick(class_3218 serverLevel, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer) {
            class_2338 beamTargetPos = new class_2338(0, 128, 0);
            summoningCrystals.forEach(crystal -> crystal.method_6837(beamTargetPos));
            ((IBetterDragonFight)dragonFight).advanceRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS("preparing_to_summon_pillars"){

        @Override
        public void tick(class_3218 serverLevel, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer) {
            int totalPhaseTime = 100;
            if (phaseTimer < totalPhaseTime) {
                if (phaseTimer == 0 || phaseTimer == 50 || phaseTimer == 51 || phaseTimer == 52 || phaseTimer >= 95) {
                    DragonRespawnStage.broadcastDragonGrowlSound(serverLevel);
                }
            } else {
                ((IBetterDragonFight)dragonFight).advanceRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS("summoning_pillars"){

        @Override
        public void tick(class_3218 serverLevel, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer) {
            boolean isLastTickForSpike;
            int ticksPerSpike = 40;
            boolean isFirstTickForSpike = phaseTimer % ticksPerSpike == 0;
            boolean bl = isLastTickForSpike = phaseTimer % ticksPerSpike == 39;
            if (isFirstTickForSpike || isLastTickForSpike) {
                int spikeIndex = phaseTimer / ticksPerSpike;
                List allSpikes = class_3310.method_14506((class_5281)serverLevel);
                if (spikeIndex < allSpikes.size()) {
                    class_3310.class_3181 spike = (class_3310.class_3181)allSpikes.get(spikeIndex);
                    int pillarHeight = (spike.method_13964() - 73) / 3;
                    if (pillarHeight == 10) {
                        pillarHeight = 9;
                    }
                    ((IEndSpike)spike).setCrystalYOffsetFromPillarHeight(pillarHeight);
                    int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
                    int crystalY = topY + ((IEndSpike)spike).getCrystalYOffset() - 1;
                    if (isFirstTickForSpike) {
                        for (class_1511 crystal : summoningCrystals) {
                            crystal.method_6837(new class_2338(spike.method_13966(), crystalY, spike.method_13967()));
                        }
                    } else {
                        serverLevel.method_8437(null, (double)((float)spike.method_13966() + 0.5f), (double)crystalY, (double)((float)spike.method_13967() + 0.5f), 5.0f, class_1937.class_7867.field_40889);
                        serverLevel.method_18456().forEach(player -> {
                            serverLevel.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() - 5.0f), (double)crystalY, (double)((float)spike.method_13967() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() - 5.0f), (double)crystalY, (double)((float)spike.method_13967() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() + 5.0f), (double)crystalY, (double)((float)spike.method_13967() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.method_14166(player, (class_2394)class_2398.field_11221, true, (double)((float)spike.method_13966() + 5.0f), (double)crystalY, (double)((float)spike.method_13967() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            if (player.method_5649((double)spike.method_13966(), (double)crystalY, (double)spike.method_13967()) > 32.0) {
                                serverLevel.method_8396(null, new class_2338(spike.method_13966(), crystalY, spike.method_13967()), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15254, 24.0f, 1.0f);
                            }
                        });
                        int resetRadius = 11;
                        int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
                        for (class_2338 blockPos : class_2338.method_10097((class_2338)new class_2338(spike.method_13966() - resetRadius, spike.method_13964() - verticalRadius, spike.method_13967() - resetRadius), (class_2338)new class_2338(spike.method_13966() + resetRadius, spike.method_13964() + verticalRadius, spike.method_13967() + resetRadius))) {
                            if (serverLevel.method_8320(blockPos).method_27852(class_2246.field_10471)) continue;
                            serverLevel.method_8650(blockPos, false);
                        }
                        class_3666 spikeConfig = new class_3666(true, (List)ImmutableList.of((Object)spike), new class_2338(0, 128, 0));
                        class_3031.field_13522.method_40163((class_3037)spikeConfig, (class_5281)serverLevel, serverLevel.method_14178().method_12129(), class_5819.method_43047(), new class_2338(spike.method_13966(), 45, spike.method_13967()));
                    }
                } else if (isFirstTickForSpike) {
                    ((IBetterDragonFight)dragonFight).advanceRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON("summoning_dragon"){

        @Override
        public void tick(class_3218 serverLevel, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer) {
            int totalPhaseTime = 100;
            if (phaseTimer >= totalPhaseTime) {
                ((IBetterDragonFight)dragonFight).advanceRespawnStage(END);
                dragonFight.method_12524();
                for (class_1511 crystal : summoningCrystals) {
                    crystal.method_6837(null);
                    serverLevel.method_8437((class_1297)crystal, crystal.method_23317(), crystal.method_23318(), crystal.method_23321(), 6.0f, class_1937.class_7867.field_40888);
                    crystal.method_31472();
                }
            } else if (phaseTimer >= 80) {
                DragonRespawnStage.broadcastDragonGrowlSound(serverLevel);
            } else if (phaseTimer == 0) {
                for (class_1511 crystal : summoningCrystals) {
                    crystal.method_6837(new class_2338(0, 128, 0));
                }
            } else if (phaseTimer < 5) {
                DragonRespawnStage.broadcastDragonGrowlSound(serverLevel);
            }
        }
    }
    ,
    END("end"){

        @Override
        public void tick(class_3218 serverLevel, class_2881 dragonFight, List<class_1511> summoningCrystals, int phaseTimer) {
        }

        @Override
        public void onStart(class_3218 serverLevel, IBetterDragonFight dragonFight) {
            class_2338 portalPos = ((EndDragonFightAccessor)((Object)dragonFight)).getPortalLocation();
            dragonFight.setDragonRespawnStage(null);
            ((EndDragonFightAccessor)((Object)dragonFight)).setDragonKilled(false);
            class_1510 newDragon = ((EndDragonFightAccessor)((Object)dragonFight)).invokeCreateNewDragon();
            if (((EndDragonFightAccessor)((Object)dragonFight)).getPreviouslyKilled()) {
                for (class_3222 serverPlayer : ((EndDragonFightAccessor)((Object)dragonFight)).getDragonEvent().method_14092()) {
                    class_174.field_1182.method_9124(serverPlayer, (class_1297)newDragon);
                }
            }
            ExitPortalUtils.spawnPortal(dragonFight, serverLevel, false, false, true);
            serverLevel.method_8437(null, (double)portalPos.method_10263(), (double)(portalPos.method_10264() + 20), (double)portalPos.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            serverLevel.method_18456().forEach(player -> {
                serverLevel.method_14166(player, (class_2394)class_2398.field_11221, true, (double)portalPos.method_10263(), (double)(portalPos.method_10264() + 20), (double)portalPos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
                if (player.method_5649((double)portalPos.method_10263(), (double)(portalPos.method_10264() + 20), (double)portalPos.method_10260()) > 32.0) {
                    serverLevel.method_8396(null, portalPos.method_10086(20), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15254, 24.0f, 1.0f);
                }
            });
            if (dragonFight.hasDragonEverSpawned()) {
                ExitPortalUtils.spawnPortal(dragonFight, serverLevel, false, true, true);
                serverLevel.method_8437(null, (double)portalPos.method_10263(), (double)portalPos.method_10264(), (double)portalPos.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            }
            int dragonKills = class_3532.method_15340((int)dragonFight.getNumTimesDragonKilled(), (int)0, (int)10);
            float cryingChance = class_3532.method_16439((float)((float)dragonKills / 10.0f), (float)0.0f, (float)0.5f);
            ArrayList existingGateways = new ArrayList(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            existingGateways.removeAll((Collection<?>)((EndDragonFightAccessor)((Object)dragonFight)).getGateways());
            existingGateways.forEach(gateway -> {
                int x = class_3532.method_15357((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                int z = class_3532.method_15357((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                class_2338 gatewayPos = new class_2338(x, 75, z);
                class_5819 gatewayRandom = class_5819.method_43049((long)class_3532.method_15389((class_2382)gatewayPos));
                class_2338.method_10097((class_2338)gatewayPos.method_10069(-1, -4, -1), (class_2338)gatewayPos.method_10069(1, 4, 1)).forEach(pos -> {
                    if (serverLevel.method_8320(pos).method_27852(class_2246.field_10540) && gatewayRandom.method_43057() < cryingChance) {
                        serverLevel.method_8501(pos, class_2246.field_22423.method_9564());
                    }
                });
            });
            class_2338 platformPos = class_3218.field_25144;
            class_5819 platformRandom = class_5819.method_43049((long)class_3532.method_15389((class_2382)platformPos));
            class_2338.method_10097((class_2338)platformPos.method_10069(-3, -15, -3), (class_2338)platformPos.method_10069(3, 4, 3)).forEach(pos -> {
                if (serverLevel.method_8320(pos).method_27852(class_2246.field_10540) && platformRandom.method_43057() < cryingChance) {
                    serverLevel.method_8501(pos, class_2246.field_22423.method_9564());
                }
            });
            dragonFight.setHasDragonEverSpawned(true);
        }
    };

    public static final class_3542.class_7292<DragonRespawnStage> CODEC;
    private final String name;

    @Nullable
    public static DragonRespawnStage byName(@Nullable String name) {
        return (DragonRespawnStage)CODEC.method_42633(name);
    }

    private DragonRespawnStage(String name) {
        this.name = name.toLowerCase();
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    private static void broadcastDragonGrowlSound(class_3218 level) {
        level.method_20290(3001, new class_2338(0, 128, 0), 0);
    }

    public abstract void tick(class_3218 var1, class_2881 var2, List<class_1511> var3, int var4);

    public void onStart(class_3218 serverLevel, IBetterDragonFight dragonFight) {
        dragonFight.setDragonRespawnStage(this);
    }

    static {
        CODEC = class_3542.method_28140(DragonRespawnStage::values);
    }
}

