/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.util;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterSpikeFeature;
import com.yungnickyoung.minecraft.betterendisland.world.util.WorldgenUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3532;
import net.minecraft.class_3666;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class EndSpikeUtils {
    public static void resetSpikes(class_3218 serverLevel, List<class_3310.class_3181> spikes) {
        spikes.forEach(spike -> {
            int resetRadius = 11;
            int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
            for (class_2338 blockPos : class_2338.method_10097((class_2338)new class_2338(spike.method_13966() - resetRadius, spike.method_13964() - verticalRadius, spike.method_13967() - resetRadius), (class_2338)new class_2338(spike.method_13966() + resetRadius, spike.method_13964() + verticalRadius, spike.method_13967() + resetRadius))) {
                if (serverLevel.method_8320(blockPos).method_27852(class_2246.field_10471)) continue;
                serverLevel.method_8650(blockPos, false);
            }
            class_3666 spikeConfig = new class_3666(true, (List)ImmutableList.of((Object)spike), null);
            BetterSpikeFeature.placeSpike((class_5425)serverLevel, class_5819.method_43047(), spikeConfig, spike, true);
        });
    }

    public static void removeVanillaPillars(class_3218 serverLevel) {
        int obsidianRemoved = 0;
        class_5819 randomSource = class_5819.method_43049((long)serverLevel.method_8412());
        long seed = randomSource.method_43055() & 0xFFFFL;
        IntArrayList indexes = class_156.method_43251((IntStream)IntStream.range(0, 10), (class_5819)class_5819.method_43049((long)seed));
        for (int i = 0; i < 10; ++i) {
            int x = class_3532.method_15357((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = class_3532.method_15357((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = indexes.get(i);
            int radius = 2 + index / 3;
            int height = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            class_238 topBoundingBox = new class_238((double)(x - radius), (double)class_2874.field_28136, (double)(z - radius), (double)(x + radius), (double)class_2874.field_28135, (double)(z + radius));
            serverLevel.method_18467(class_1511.class, topBoundingBox).forEach(class_1297::method_31472);
            for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(x - radius, serverLevel.method_31607(), z - radius), (class_2338)new class_2338(x + radius, height + 20, z + radius))) {
                class_2680 blockState;
                if (!(pos.method_40081((double)x, (double)pos.method_10264(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = serverLevel.method_8320(pos)).method_27852(class_2246.field_10540) && !blockState.method_27852(class_2246.field_9987)) continue;
                serverLevel.method_8501(pos, class_2246.field_10124.method_9564());
                if (!blockState.method_27852(class_2246.field_10540)) continue;
                ++obsidianRemoved;
            }
            if (obsidianRemoved > 10) {
                int offset = radius + 1;
                int topY = -1;
                int surfaceY = WorldgenUtils.getSurfacePosAt((class_1937)serverLevel, x - offset, z - offset);
                if (surfaceY > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((class_1937)serverLevel, x - offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((class_1937)serverLevel, x + offset, z - offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getSurfacePosAt((class_1937)serverLevel, x + offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                int bottomY = 255;
                surfaceY = WorldgenUtils.getLowestBlockPosAt((class_1937)serverLevel, x - offset, z - offset);
                if (surfaceY < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((class_1937)serverLevel, x - offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((class_1937)serverLevel, x + offset, z - offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = WorldgenUtils.getLowestBlockPosAt((class_1937)serverLevel, x + offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if (topY != -1 && bottomY != 255) {
                    for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(x - radius, bottomY, z - radius), (class_2338)new class_2338(x + radius, topY, z + radius))) {
                        class_2680 blockState;
                        if (!(pos.method_40081((double)x, (double)pos.method_10264(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = serverLevel.method_8320(pos)).method_27852(class_2246.field_10124) || pos.method_10264() > topY || pos.method_10264() < bottomY) continue;
                        serverLevel.method_8501(pos, class_2246.field_10471.method_9564());
                    }
                }
            }
            if (!isGuarded) continue;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int fenceX = -2; fenceX <= 2; ++fenceX) {
                for (int fenceZ = -2; fenceZ <= 2; ++fenceZ) {
                    for (int fenceY = 0; fenceY <= 3; ++fenceY) {
                        if (class_3532.method_15382((int)fenceX) != 2 && class_3532.method_15382((int)fenceZ) != 2 && fenceY != 3) continue;
                        mutable.method_10103(x + fenceX, height + fenceY, z + fenceZ);
                        serverLevel.method_8501((class_2338)mutable, class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }
}

