/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block.entity;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.CommonAbstractions;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.barteringstation.world.level.block.entity.BarteringStationAnimationController;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_4140;
import net.minecraft.class_4836;
import net.minecraft.class_4838;
import net.minecraft.class_5250;
import net.minecraft.class_5418;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BarteringStationBlockEntity
extends class_2624
implements class_1278,
ListBackedContainer,
TickingBlockEntity {
    public static final class_5250 CONTAINER_BARTERING_STATION = class_2561.method_43471((String)"container.bartering_station");
    public static final String TAG_DELAY = BarteringStation.id("delay").toString();
    public static final int ALL_SLOTS = 21;
    public static final int CURRENCY_SLOTS = 6;
    public static final int DATA_SLOTS = 2;
    private static final int[] SLOTS_FOR_INPUT = (int[])class_156.method_654((Object)new int[6], arr -> Arrays.setAll(arr, IntUnaryOperator.identity()));
    private static final int[] SLOTS_FOR_OUTPUT = (int[])class_156.method_654((Object)new int[15], arr -> Arrays.setAll(arr, i -> i + 6));
    private final BarteringStationAnimationController animationController;
    private final class_3913 dataAccess;
    private final class_2371<class_1799> items = class_2371.method_10213((int)21, (Object)class_1799.field_8037);
    private int barterDelay;
    private int nearbyPiglins;

    public BarteringStationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.comp_349(), blockPos, blockState);
        this.animationController = new BarteringStationAnimationController(blockPos);
        this.dataAccess = new class_3913(){

            public int method_17390(int id) {
                return switch (id) {
                    case 0 -> BarteringStationBlockEntity.this.getBarterDelay();
                    case 1 -> BarteringStationBlockEntity.this.nearbyPiglins;
                    default -> throw new IndexOutOfBoundsException(id);
                };
            }

            public void method_17391(int id, int data) {
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public int getBarterDelay() {
        return Math.min(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay, this.barterDelay);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.items.clear();
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        this.barterDelay = tag.method_10568(TAG_DELAY);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        tag.method_10575(TAG_DELAY, (short)this.barterDelay);
    }

    protected class_2561 method_17823() {
        return CONTAINER_BARTERING_STATION;
    }

    protected class_2371<class_1799> method_11282() {
        return this.getContainerItems();
    }

    protected void method_11281(class_2371<class_1799> items) {
        ContainerMenuHelper.copyItemsIntoList(items, this.getContainerItems());
    }

    protected class_1703 method_5465(int id, class_1661 inventory) {
        return new BarteringStationMenu(id, inventory, (class_1263)this, this.dataAccess);
    }

    public void clientTick() {
        this.animationController.tick(this.method_10997());
    }

    public void serverTick() {
        int totalBarterDelay;
        boolean tryPerformBarter;
        if (this.barterDelay > 0) {
            --this.barterDelay;
        }
        boolean bl = tryPerformBarter = this.barterDelay % (totalBarterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay) == 0;
        if (tryPerformBarter || this.barterDelay % (totalBarterDelay / 4) == 0) {
            List<class_4836> piglins = BarteringStationBlockEntity.findNearbyPiglins(this.method_10997(), this.method_11016());
            this.nearbyPiglins = piglins.size();
            if (tryPerformBarter) {
                this.barterDelay = totalBarterDelay * 2;
                this.barterWithPiglins(this.method_11016(), piglins);
            }
        }
    }

    private static List<class_4836> findNearbyPiglins(class_1937 level, class_2338 pos) {
        class_243 vec3 = class_243.method_24953((class_2382)pos);
        int horizontalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).horizontalRange;
        int verticalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).verticalRange;
        return level.method_8390(class_4836.class, new class_238(vec3.method_1031((double)(-horizontalRange), (double)(-verticalRange), (double)(-horizontalRange)), vec3.method_1031((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), class_5418::method_30236);
    }

    private void barterWithPiglins(class_2338 pos, List<class_4836> piglins) {
        if (piglins.isEmpty() || this.findFreeResponseSlot().isEmpty()) {
            return;
        }
        int currentPiglin = 0;
        block0: for (int i = 0; i < 6; ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            while (currentPiglin < piglins.size()) {
                if (!BarteringStationBlockEntity.mobInteract(piglins.get(currentPiglin++), stack, pos)) continue;
                this.method_5431();
                this.barterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
                continue block0;
            }
        }
    }

    private OptionalInt findFreeResponseSlot() {
        for (int i = 6; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static boolean mobInteract(class_4836 piglin, class_1799 itemStack, class_2338 blockPos) {
        if (class_4838.method_27086((class_4836)piglin, (class_1799)itemStack)) {
            class_1799 currencyStack = itemStack.method_7971(1);
            class_4838.method_30089((class_4836)piglin, (class_1799)currencyStack);
            BarteringStationBlockEntity.admireGoldItem((class_1309)piglin);
            class_4838.method_24781((class_4836)piglin);
            ((BarteringStationCapability)ModRegistry.BARTERING_STATION_CAPABILITY.get((Object)piglin)).setBarteringStationPos(blockPos);
            return true;
        }
        return false;
    }

    private static void admireGoldItem(class_1309 livingEntity) {
        livingEntity.method_18868().method_24525(class_4140.field_22334, (Object)true, (long)(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay / 2));
    }

    public BarteringStationAnimationController getAnimationController() {
        return this.animationController;
    }

    public int[] method_5494(class_2350 direction) {
        return direction == class_2350.field_11033 ? SLOTS_FOR_OUTPUT : SLOTS_FOR_INPUT;
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemStack);
    }

    public boolean method_5493(int index, class_1799 itemStack, class_2350 direction) {
        return true;
    }

    public class_2371<class_1799> getContainerItems() {
        return this.items;
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index >= 0 && index < 6 && CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
    }

    public boolean placeBarterResponseItem(class_1799 stack) {
        while (!stack.method_7960()) {
            OptionalInt slot = this.findResponseSlotWithSpace(stack);
            if (slot.isEmpty()) {
                slot = this.findFreeResponseSlot();
            }
            if (!slot.isPresent()) break;
            this.mergeStackToSlot(stack, slot.getAsInt());
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    private OptionalInt findResponseSlotWithSpace(class_1799 stack) {
        for (int i = 6; i < this.method_5439(); ++i) {
            if (!this.hasSpaceForItem(this.method_5438(i), stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void mergeStackToSlot(class_1799 stackToMerge, int targetSlot) {
        class_1799 stackToInsert;
        class_1799 stackInSlot = this.method_5438(targetSlot);
        if (stackInSlot.method_7960()) {
            stackToInsert = stackToMerge.method_51164();
        } else {
            stackToInsert = stackInSlot.method_7972();
            int transferAmount = stackToMerge.method_7947();
            transferAmount = Math.min(transferAmount, stackToInsert.method_7914() - stackToInsert.method_7947());
            stackToInsert.method_7933(transferAmount);
            stackToMerge.method_7934(transferAmount);
        }
        this.method_5447(targetSlot, stackToInsert);
    }

    private boolean hasSpaceForItem(class_1799 stack1, class_1799 stack2) {
        return !stack1.method_7960() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2) && stack1.method_7946() && stack1.method_7947() < stack1.method_7914() && stack1.method_7947() < this.method_5444();
    }
}

