/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.opennbs.NBSFileUtils;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;

public class EmoteSerializer {
    public static void serializeEmotes(UUIDMap<KeyframeAnimation> emotes, Path externalEmotes) {
        if (!Files.isDirectory(externalEmotes, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(externalEmotes, FileVisitOption.FOLLOW_LINKS);){
            ((Stream)paths.filter(file -> AnimationFormat.byFileName((String)file.getFileName().toString()).getExtension() != null).parallel()).forEach(file -> {
                String folderPath = externalEmotes.relativize(file.getParent()).normalize().toString().replace(File.separator, "/");
                if (folderPath.startsWith("server") || folderPath.contains("_export")) {
                    return;
                }
                emotes.addAll(EmoteSerializer.serializeExternalEmote(file));
            });
        }
        catch (Throwable e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Failed to walk emotes!", e);
        }
    }

    public static List<KeyframeAnimation> serializeExternalEmote(Path file) {
        List<KeyframeAnimation> list;
        block28: {
            String fileName = file.getFileName().toString();
            String baseFileName = EmoteSerializer.getBaseName(fileName);
            InputStream reader = Files.newInputStream(file, new OpenOption[0]);
            try {
                Path song;
                List<KeyframeAnimation> emotes = UniversalEmoteSerializer.readData(reader, fileName);
                Path icon = file.getParent().resolve(baseFileName + ".png");
                if (Files.isRegularFile(icon, new LinkOption[0])) {
                    try (InputStream iconStream = Files.newInputStream(icon, new OpenOption[0]);){
                        ByteBuffer byteBuffer = MathHelper.readFromIStream((InputStream)iconStream);
                        for (KeyframeAnimation emote : emotes) {
                            emote.extraData.put("iconData", byteBuffer);
                        }
                    }
                    catch (Throwable th) {
                        EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while reading icon: " + String.valueOf(icon.getFileName()), th);
                    }
                }
                if (Files.isRegularFile(song = file.getParent().resolve(baseFileName + ".nbs"), new LinkOption[0]) && emotes.size() == 1) {
                    try (DataInputStream bis = new DataInputStream(Files.newInputStream(song, new OpenOption[0]));){
                        emotes.getFirst().extraData.put("song", NBSFileUtils.read((DataInputStream)bis));
                    }
                    catch (Throwable th) {
                        EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while reading song: " + String.valueOf(song.getFileName()), th);
                    }
                }
                list = emotes;
                if (reader == null) break block28;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable th) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, "Error while importing external emote: " + String.valueOf(file.getFileName()), th);
                    return Collections.emptyList();
                }
            }
            reader.close();
        }
        return list;
    }

    private static String getBaseName(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            fileName = fileName.substring(0, i);
        }
        return fileName;
    }
}

