/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.AbstractBananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class BananaClusterPlantBlock
extends AbstractBananaClusterBlock
implements class_2256 {
    public static final MapCodec<BananaClusterPlantBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BananaClusterBlock.Type.CODEC.fieldOf("type").forGetter(BananaClusterPlantBlock::getClusterType), (App)BananaClusterPlantBlock.method_54096()).apply((Applicative)instance, BananaClusterPlantBlock::new));
    private static final Map<class_2350, class_265> SHAPES = Map.of(class_2350.field_11043, class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), class_2350.field_11039, class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0), class_2350.field_11035, class_2248.method_9541((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0), class_2350.field_11034, class_2248.method_9541((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0));
    public static final class_2754<HangingType> HANGING = class_2754.method_11850((String)"hanging", HangingType.class);
    private final BananaClusterBlock.Type type;

    public BananaClusterPlantBlock(BananaClusterBlock.Type type, class_4970.class_2251 properties) {
        super(properties);
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(HANGING, (Comparable)((Object)HangingType.NONE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    public boolean method_9542(class_2680 state) {
        return this.type != BananaClusterBlock.Type.RIPE;
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE && BananaClusterBlock.canClusterPlantGrow((class_1937)level, pos) && random.method_43048(10) == 0) {
            level.method_8652(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.method_34725(state), 3);
        }
    }

    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state) {
        return state.method_27852(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT);
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return random.method_43048(6) == 0;
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE) {
            level.method_8652(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.method_34725(state), 3);
        }
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)this.type.block().get());
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11036 && neighborState.method_26164(FOTTags.Blocks.BANANA_CLUSTER_PLANTS)) {
            if (!neighborState.method_27852(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && state.method_11654(HANGING) == HangingType.SMALL_CLUSTER) {
                return (class_2680)state.method_11657(HANGING, (Comparable)((Object)HangingType.NONE));
            }
            return state.method_11654(HANGING) == HangingType.STEM || state.method_11654(HANGING) == HangingType.SMALL_CLUSTER ? state : (class_2680)state.method_11657(HANGING, (Comparable)((Object)HangingType.NONE));
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean method_9522(class_2680 state, class_2680 adjacentState, class_2350 direction) {
        return adjacentState.method_26164(FOTTags.Blocks.BANANA_CLUSTER_PLANTS) && !adjacentState.method_27852(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && direction.method_10166().method_10178();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)field_11177));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, HANGING, WATERLOGGED});
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    public BananaClusterBlock.Type getClusterType() {
        return this.type;
    }

    public static enum HangingType implements class_3542
    {
        NONE,
        SMALL_CLUSTER,
        STEM;

        public static final class_3542.class_7292<HangingType> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(HangingType::values);
        }
    }
}

