/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class CompositeSpawnCondition
implements SpawnCondition {
    protected final List<SpawnCondition> terms;
    private final Predicate<SpawnConditionContext> composedPredicate;

    protected CompositeSpawnCondition(List<SpawnCondition> terms, Predicate<SpawnConditionContext> composedPredicate) {
        this.terms = terms;
        this.composedPredicate = composedPredicate;
    }

    protected static <T extends CompositeSpawnCondition> MapCodec<T> createCodec(Function<List<SpawnCondition>, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)FOTSpawnConditions.DIRECT_CODEC.listOf().fieldOf("terms").forGetter(compositeSpawnCondition -> compositeSpawnCondition.terms)).apply((Applicative)instance, factory));
    }

    protected static <T extends CompositeSpawnCondition> Codec<T> createInlineCodec(Function<List<SpawnCondition>, T> factory) {
        return FOTSpawnConditions.DIRECT_CODEC.listOf().xmap(factory, compositeSpawnCondition -> compositeSpawnCondition.terms);
    }

    @Override
    public final boolean test(SpawnConditionContext context) {
        return this.composedPredicate.test(context);
    }

    public static abstract class Builder
    implements SpawnCondition.Builder {
        private final ImmutableList.Builder<SpawnCondition> terms = ImmutableList.builder();

        protected Builder(SpawnCondition.Builder ... conditions) {
            for (SpawnCondition.Builder builder : conditions) {
                this.terms.add((Object)builder.build());
            }
        }

        public void addTerm(SpawnCondition.Builder condition) {
            this.terms.add((Object)condition.build());
        }

        @Override
        public SpawnCondition build() {
            return this.create((List<SpawnCondition>)this.terms.build());
        }

        protected abstract SpawnCondition create(List<SpawnCondition> var1);
    }
}

