/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import java.util.Optional;
import net.minecraft.class_3218;

public record RainingCondition(Optional<Boolean> thundering) implements SpawnCondition
{
    public static final MapCodec<RainingCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("thundering").forGetter(RainingCondition::thundering)).apply((Applicative)instance, RainingCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.IS_RAINING;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        class_3218 level = context.level();
        return level.method_8419() || this.thundering.isPresent() && this.thundering.get().booleanValue() == level.method_8546();
    }

    public static Builder raining() {
        return new Builder();
    }

    public static class Builder
    implements SpawnCondition.Builder {
        private Optional<Boolean> thundering = Optional.empty();

        public Builder thundering(boolean thundering) {
            this.thundering = Optional.of(thundering);
            return this;
        }

        @Override
        public RainingCondition build() {
            return new RainingCondition(this.thundering);
        }
    }
}

