/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot;

import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.loot.function.FOTLootItem;
import com.stevekung.fishofthieves.loot.function.FOTTagEntry;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_156;
import net.minecraft.class_165;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_215;
import net.minecraft.class_2680;
import net.minecraft.class_3735;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8551;
import net.minecraft.class_8567;
import net.minecraft.class_91;
import net.minecraft.class_9356;
import net.minecraft.class_9360;
import net.minecraft.class_9361;
import net.minecraft.class_9383;
import net.minecraft.class_9636;

public class FOTLootManager {
    public static void dropWorms(List<class_1799> droppedList, class_2680 blockState, class_9383.class_9385 holder, class_8567 lootParams) {
        if (FishOfThieves.CONFIG.general.enableEarthwormsDrop && blockState.method_26164(FOTTags.Blocks.EARTHWORMS_DROPS) && !blockState.method_26164(FOTTags.Blocks.EARTHWORMS_DROP_BLACKLIST)) {
            droppedList.addAll((Collection<class_1799>)holder.method_58295(FOTLootTables.Blocks.EARTHWORMS_DROPS).method_51878(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableGrubsDrop && blockState.method_26164(FOTTags.Blocks.GRUBS_DROPS)) {
            droppedList.addAll((Collection<class_1799>)holder.method_58295(FOTLootTables.Blocks.GRUBS_DROPS).method_51878(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableLeechesDrop && blockState.method_26164(FOTTags.Blocks.LEECHES_DROPS)) {
            droppedList.addAll((Collection<class_1799>)holder.method_58295(FOTLootTables.Blocks.LEECHES_DROPS).method_51878(lootParams));
        }
    }

    public static Map<class_5321<class_52>, BiFunction<class_55.class_56, class_7225.class_7874, class_55.class_56>> getInjectedLootTableMap() {
        return (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(class_39.field_19067, (builder, provider) -> FOTLootManager.getFishermanGiftLoot(builder));
            map.put(class_39.field_795, FOTLootManager::getFishingLoot);
            map.put(class_1299.field_6042.method_16351(), FOTLootManager::getPolarBearLoot);
            map.put(class_1299.field_6087.method_16351(), FOTLootManager::getDolphinLoot);
            map.put(class_39.field_43356, (builder, provider) -> FOTLootManager.getOceanRuinsArchaeologyLoot(builder));
            map.put(class_39.field_43357, (builder, provider) -> FOTLootManager.getOceanRuinsArchaeologyLoot(builder));
        });
    }

    public static Map<class_5321<class_52>, BiFunction<class_55.class_56, class_7225.class_7874, class_55.class_56>> getInjectedLootPoolMap() {
        return (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(class_1299.field_6118.method_16351(), (builder, provider) -> FOTLootManager.getGuardianLoot(builder, provider, false));
            map.put(class_1299.field_6086.method_16351(), (builder, provider) -> FOTLootManager.getGuardianLoot(builder, provider, true));
            map.put(class_39.field_18007, (builder, provider) -> FOTLootManager.getVillageFisherLoot(builder));
            map.put(class_39.field_251, (builder, provider) -> FOTLootManager.getBuriedTreasureLoot(builder));
            map.put(class_39.field_880, (builder, provider) -> FOTLootManager.getShipwreckSupplyLoot(builder));
            map.put(class_39.field_803, FOTLootManager::getJungleTempleLoot);
        });
    }

    public static class_55.class_56 getFishermanGiftLoot(class_55.class_56 builder) {
        return builder.method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.SPLASHTAIL)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.PONDIE)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.ISLEHOPPER)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.ANCIENTSCALE)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.PLENTIFIN)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.WILDSPLASH)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.DEVILFISH)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.BATTLEGILL)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.WRECKER)).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.STORMFISH).method_421(FOTLootItemConditions.THUNDERING));
    }

    public static class_55.class_56 getFishingLoot(class_55.class_56 builder, class_7225.class_7874 provider) {
        class_7225.class_7226 structureLookup = provider.method_46762(class_7924.field_41246);
        class_7225.class_7226 biomeLookup = provider.method_46762(class_7924.field_41236);
        return builder.method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.SPLASHTAIL).method_437(50).method_421(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_SPLASHTAILS))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.PONDIE).method_437(50).method_421(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_PONDIES))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.ISLEHOPPER).method_437(40).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_ISLEHOPPERS))).and((class_5341.class_210)FOTLootItemConditions.COAST_CONTINENTALNESS.and((class_5341.class_210)FOTLootItemConditions.LOW_PEAKTYPE.method_893(FOTLootItemConditions.MID_PEAKTYPE).method_893(FOTLootItemConditions.VALLEY_PEAKTYPE))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.ANCIENTSCALE).method_437(40).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_ANCIENTSCALES))).method_893(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_35277((class_6885)structureLookup.method_46735(FOTTags.Structures.ANCIENTSCALES_SPAWN_IN)))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.PLENTIFIN).method_437(45).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_PLENTIFINS))).method_893(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_35277((class_6885)structureLookup.method_46735(FOTTags.Structures.PLENTIFINS_SPAWN_IN)))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.WILDSPLASH).method_437(45).method_421(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_WILDSPLASH))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.DEVILFISH).method_437(35).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_DEVILFISH))).and((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_35278(class_2096.class_2099.method_35286((double)0.0))).and(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.DEVILFISH_CANNOT_SPAWN))).method_16780())))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.BATTLEGILL).method_437(35).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_BATTLEGILLS))).and((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_35277((class_6885)structureLookup.method_46735(FOTTags.Structures.BATTLEGILLS_SPAWN_IN))).method_893(FOTLootItemConditions.HAS_RAIDS)))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.WRECKER).method_437(20).method_421((class_5341.class_210)class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_35277((class_6885)structureLookup.method_46735(FOTTags.Structures.WRECKERS_SPAWN_IN))).and(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_WRECKERS)))))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.STORMFISH).method_437(20).method_421((class_5341.class_210)FOTLootItemConditions.THUNDERING.and(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)biomeLookup.method_46735(FOTTags.Biomes.SPAWNS_STORMFISH))))));
    }

    public static class_55.class_56 getGuardianLoot(class_55.class_56 builder, class_7225.class_7874 provider, boolean elder) {
        int weight = elder ? 3 : 2;
        return builder.method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.SPLASHTAIL).method_437(weight).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.BATTLEGILL).method_437(weight).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))));
    }

    public static class_55.class_56 getDolphinLoot(class_55.class_56 builder, class_7225.class_7874 provider) {
        return builder.method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.SPLASHTAIL).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.ANCIENTSCALE).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.PLENTIFIN).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.WILDSPLASH).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider)))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.STORMFISH).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_421(FOTLootItemConditions.THUNDERING));
    }

    public static class_55.class_56 getPolarBearLoot(class_55.class_56 builder, class_7225.class_7874 provider) {
        return builder.method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.SPLASHTAIL).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(10).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.ANCIENTSCALE).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(6).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.PLENTIFIN).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(6).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.WILDSPLASH).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(6).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_351((class_79.class_80)FOTLootItem.lootTableItem((class_1935)FOTItems.WRECKER).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)))).method_351(FOTLootItem.lootTableItem((class_1935)FOTItems.STORMFISH).method_438((class_117.class_118)class_165.method_724().method_524((class_5341.class_210)FOTLootManager.shouldSmeltLoot(provider))).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)provider, (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_421(FOTLootItemConditions.THUNDERING));
    }

    public static class_55.class_56 getOceanRuinsArchaeologyLoot(class_55.class_56 builder) {
        return builder.method_351((class_79.class_80)class_77.method_411((class_1935)FOTBlocks.FISH_BONE)).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.STORMFISH_POTTERY_SHERD)).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.KRAKEN_POTTERY_SHERD)).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.MEGALODON_POTTERY_SHERD));
    }

    public static class_55.class_56 getVillageFisherLoot(class_55.class_56 builder) {
        return builder.method_351((class_79.class_80)FOTTagEntry.expandTag(FOTTags.Items.THIEVES_FISH).method_437(1).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)5.0f))));
    }

    public static class_55.class_56 getBuriedTreasureLoot(class_55.class_56 builder) {
        return builder.method_352((class_5658)class_44.method_32448((float)2.0f)).method_351((class_79.class_80)class_91.method_445(FOTTags.Items.COOKED_THIEVES_FISH).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)5.0f))));
    }

    public static class_55.class_56 getShipwreckSupplyLoot(class_55.class_56 builder) {
        return builder.method_352((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.BANANA).method_437(9).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)6.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.COCONUT).method_437(7).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)4.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.POMEGRANATE).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.MANGO).method_437(4).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.PINEAPPLE).method_437(2).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))));
    }

    public static class_55.class_56 getJungleTempleLoot(class_55.class_56 builder, class_7225.class_7874 provider) {
        class_7225.class_7226 biomeLookup = provider.method_46762(class_7924.field_41236);
        return builder.method_352((class_5658)class_5662.method_32462((float)1.0f, (float)2.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.BANANA).method_437(9).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)2.0f, (float)8.0f)))).method_356(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{biomeLookup.method_46747(FOTBiomes.TROPICAL_ISLAND)})))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.POMEGRANATE).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)6.0f)))).method_356(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{biomeLookup.method_46747(FOTBiomes.TROPICAL_ISLAND)})))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.MANGO).method_437(4).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)4.0f)))).method_356(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{biomeLookup.method_46747(FOTBiomes.TROPICAL_ISLAND)})))).method_351((class_79.class_80)class_77.method_411((class_1935)FOTItems.PINEAPPLE).method_437(2).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)))).method_356(class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_9024((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{biomeLookup.method_46747(FOTBiomes.TROPICAL_ISLAND)}))));
    }

    public static class_8551.class_8552 shouldSmeltLoot(class_7225.class_7874 provider) {
        class_7225.class_7226 registryLookup = provider.method_46762(class_7924.field_41265);
        return class_8551.method_51727((class_5341.class_210[])new class_5341.class_210[]{class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8919(class_2040.class_2041.method_8897().method_8898(Boolean.valueOf(true)))), class_215.method_917((class_47.class_50)class_47.class_50.field_939, (class_2048.class_2049)class_2048.class_2049.method_8916().method_53141(class_3735.class_5278.method_27965().method_35195(class_2073.class_2074.method_8973().method_58179(class_9361.field_49807, (class_9360)class_9356.method_58173(List.of(new class_2035((class_6885)registryLookup.method_46735(class_9636.field_51552), class_2096.class_2100.field_9708)))))))});
    }
}

