/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3470;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3793;
import net.minecraft.class_3818;
import net.minecraft.class_3821;
import net.minecraft.class_3824;
import net.minecraft.class_3825;
import net.minecraft.class_3826;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6378;
import net.minecraft.class_6625;

public class GuardianFruitTreePiece
extends class_3470 {
    private float fruitChance;

    public GuardianFruitTreePiece(class_3485 structureTemplateManager, class_2338 templatePosition, class_2960 location, class_2470 rotation, class_2415 mirror, class_2338 pivotPos, float fruitChance) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, 0, structureTemplateManager, location, location.toString(), GuardianFruitTreePiece.makeSettings(mirror, rotation, pivotPos), templatePosition);
        this.fruitChance = fruitChance;
    }

    public GuardianFruitTreePiece(class_3485 structureTemplateManager, class_2487 tag) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, tag, structureTemplateManager, resourceLocation -> GuardianFruitTreePiece.makeSettings(structureTemplateManager, tag, resourceLocation));
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        super.method_14943(context, tag);
        tag.method_10582("Rotation", this.field_15434.method_15113().name());
        tag.method_10582("Mirror", this.field_15434.method_15114().name());
    }

    private static class_3492 makeSettings(class_3485 structureTemplateManager, class_2487 tag, class_2960 location) {
        class_3499 structureTemplate = structureTemplateManager.method_15091(location);
        class_2338 blockPos = new class_2338(structureTemplate.method_15160().method_10263() / 2, 0, structureTemplate.method_15160().method_10260() / 2);
        return GuardianFruitTreePiece.makeSettings(class_2415.valueOf((String)tag.method_10558("Mirror")), class_2470.valueOf((String)tag.method_10558("Rotation")), blockPos);
    }

    private static class_3492 makeSettings(class_2415 mirror, class_2470 rotation, class_2338 pos) {
        class_3793 blockIgnoreProcessor = class_3793.field_16718;
        ArrayList list = Lists.newArrayList();
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(class_2246.field_10135, 0.1f, (class_2680)FOTBlocks.PRISMARIZED_LOG.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(class_2246.field_10135, 0.1f, (class_2680)FOTBlocks.PRISMARIZED_LOG.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(class_2246.field_10135, 0.03f, class_2246.field_10092));
        return new class_3492().method_15123(rotation).method_15125(mirror).method_15119(pos).method_16184((class_3491)blockIgnoreProcessor).method_16184((class_3491)new class_3826((List)list)).method_16184((class_3491)new class_6378(class_3481.field_33757));
    }

    public void method_14931(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 pos) {
        class_3341 boundingBox = this.field_15433.method_16187(this.field_15434, this.field_15432);
        if (box.method_14662((class_2382)boundingBox.method_22874())) {
            box.method_35412(boundingBox);
            super.method_14931(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadPrismarine(random, (class_1936)level);
            this.addPrismarineDripColumnsBelow(random, (class_1936)level);
        }
    }

    protected void method_15026(String name, class_2338 pos, class_5425 level, class_5819 random, class_3341 box) {
        if (name.equals("guardian_fruit_block") && random.method_43057() <= this.fruitChance) {
            level.method_8652(pos, FOTBlocks.GUARDIAN_FRUIT.method_9564(), 2);
        }
    }

    private void addPrismarineDripColumnsBelow(class_5819 random, class_1936 level) {
        for (int i = this.field_15315.method_35415() + 1; i < this.field_15315.method_35418(); ++i) {
            for (int j = this.field_15315.method_35417() + 1; j < this.field_15315.method_35420(); ++j) {
                class_2338 blockPos = new class_2338(i, this.field_15315.method_35416(), j);
                if (!level.method_8320(blockPos).method_27852(class_2246.field_10135)) continue;
                this.addPrismarineDripColumn(random, level, blockPos.method_10074());
            }
        }
    }

    private void addPrismarineDripColumn(class_5819 random, class_1936 level, class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        this.placeDecoratedBlocksOrMagma(random, level, (class_2338)mutableBlockPos);
        for (int i = 8; i > 0 && random.method_43057() < 0.5f; --i) {
            mutableBlockPos.method_10098(class_2350.field_11033);
            this.placeDecoratedBlocksOrMagma(random, level, (class_2338)mutableBlockPos);
        }
    }

    private void spreadPrismarine(class_5819 random, class_1936 level) {
        class_2338 blockPos = this.field_15315.method_22874();
        int i = blockPos.method_10263();
        int j = blockPos.method_10260();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = fs.length;
        int l = (this.field_15315.method_35414() + this.field_15315.method_14663()) / 2;
        int m = random.method_43048(Math.max(1, 8 - l / 2));
        class_2338.class_2339 mutableBlockPos = class_2338.field_10980.method_25503();
        for (int o = i - k; o <= i + k; ++o) {
            for (int p = j - k; p <= j + k; ++p) {
                int q = Math.abs(o - i) + Math.abs(p - j);
                int r = Math.max(0, q + m);
                if (r >= k) continue;
                float f = fs[r];
                if (!(random.method_43058() < (double)f)) continue;
                int s = GuardianFruitTreePiece.getSurfaceY(level, o, p);
                int t = Math.min(this.field_15315.method_35416(), s);
                mutableBlockPos.method_10103(o, t, p);
                if (Math.abs(t - this.field_15315.method_35416()) > 3 || !this.canBlockBeReplaced(level, (class_2338)mutableBlockPos)) continue;
                this.placeDecoratedBlocksOrMagma(random, level, (class_2338)mutableBlockPos);
                this.addPrismarineDripColumn(random, level, mutableBlockPos.method_10074());
            }
        }
    }

    private boolean canBlockBeReplaced(class_1936 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        return !blockState.method_27852(class_2246.field_10124) && !blockState.method_26164(class_3481.field_33757);
    }

    private void placeDecoratedBlocksOrMagma(class_5819 random, class_1936 level, class_2338 pos) {
        if (random.method_43057() < 0.03f) {
            level.method_8652(pos, class_2246.field_10092.method_9564(), 3);
        } else if (random.method_43057() < 0.1f) {
            level.method_8652(pos, (class_2680)FOTBlocks.PRISMARIZED_LOG.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)(random.method_43056() ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)), 3);
        } else {
            level.method_8652(pos, class_2246.field_10135.method_9564(), 3);
        }
    }

    private static int getSurfaceY(class_1936 level, int x, int z) {
        return level.method_8624(class_2902.class_2903.field_13195, x, z) - 1;
    }

    private static class_3821 getBlockReplaceRule(class_2248 block, float probability, class_2248 replaceBlock) {
        return new class_3821((class_3825)new class_3824(block, probability), (class_3825)class_3818.field_16868, replaceBlock.method_9564());
    }

    private static class_3821 getBlockReplaceRule(class_2248 block, float probability, class_2680 blockState) {
        return new class_3821((class_3825)new class_3824(block, probability), (class_3825)class_3818.field_16868, blockState);
    }
}

