/*
 * Decompiled with CFR 0.152.
 */
package yourdailymodder.weaponmaster.gui.slider;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import yourdailymodder.weaponmaster.gui.DetailedSettingsScreen;
import yourdailymodder.weaponmaster.gui.UniqueItemSettingScreen;
import yourdailymodder.weaponmaster.gui.slider.NewAbstractSlider;

public class NewForgeSlider
extends NewAbstractSlider {
    public class_2561 prefix;
    public class_2561 suffix;
    public double minValue;
    public double maxValue;
    public double stepSize;
    public boolean drawString;
    public final DecimalFormat format;

    public NewForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        this.visible = false;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    public NewForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    public void setData() {
        if (class_310.method_1551().field_1755.getClass() == DetailedSettingsScreen.class) {
            DetailedSettingsScreen.setData();
        } else if (class_310.method_1551().field_1755.getClass() == UniqueItemSettingScreen.class) {
            UniqueItemSettingScreen.setData();
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    public void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    public void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!class_3532.method_20390((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    @Override
    public void updateMessage() {
        if (this.drawString) {
            this.setMessage((class_2561)class_2561.method_43470((String)"").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.setMessage((class_2561)class_2561.method_43473());
        }
    }

    @Override
    public void applyValue() {
    }

    public void method_46421(int p_265236_) {
        this.x = p_265236_;
    }

    public void method_46419(int p_265404_) {
        this.y = p_265404_;
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    public void method_48206(Consumer<class_339> p_265082_) {
    }
}

