/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.elementalmaces;

import dev.foxgirl.elementalmaces.items.AbstractElementalMaceItem;
import dev.foxgirl.elementalmaces.items.EnderMaceItem;
import dev.foxgirl.elementalmaces.items.ResonatingMaceItem;
import dev.foxgirl.elementalmaces.items.SmoulderingMaceItem;
import dev.foxgirl.elementalmaces.items.WitheringMaceItem;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_8111;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ElementalMaces {
    public static final Logger LOGGER = LogManager.getLogger();
    public final LoaderAdapter loader;
    public final ItemRegisterAdapter items;
    public final Supplier<AbstractElementalMaceItem> resonatingMace;
    public final Supplier<AbstractElementalMaceItem> witheringMace;
    public final Supplier<AbstractElementalMaceItem> enderMace;
    public final Supplier<AbstractElementalMaceItem> smoulderingMace;
    public final Supplier<class_1792> resonatingRod;
    public final Supplier<class_1792> witheringRod;

    public ElementalMaces(LoaderAdapter loader) {
        LOGGER.info("Setting up Elemental Maces...");
        this.loader = loader;
        this.items = loader.createItemRegister("elementalmaces");
        this.resonatingMace = this.items.add("resonating_mace", ResonatingMaceItem::new);
        this.witheringMace = this.items.add("withering_mace", WitheringMaceItem::new);
        this.enderMace = this.items.add("ender_mace", EnderMaceItem::new);
        this.smoulderingMace = this.items.add("smouldering_mace", SmoulderingMaceItem::new);
        this.resonatingRod = this.items.add("resonating_rod", () -> new class_1792(new class_1792.class_1793()));
        this.witheringRod = this.items.add("withering_rod", () -> new class_1792(new class_1792.class_1793()));
    }

    public List<AbstractElementalMaceItem> getMaceItems() {
        return Arrays.asList(this.resonatingMace.get(), this.witheringMace.get(), this.enderMace.get(), this.smoulderingMace.get());
    }

    public List<class_1792> getRodItems() {
        return Arrays.asList(this.resonatingRod.get(), this.witheringRod.get());
    }

    public void registerItems() {
        LOGGER.info("Registering items...");
        this.items.register();
    }

    public void registerMace3DModels() {
        if (!this.loader.isDedicatedServer() && this.loader.isModLoaded("mace3d")) {
            LOGGER.info("Registering external 3D mace models");
            try {
                MethodHandle registerModelMethod = MethodHandles.lookup().findStatic(Class.forName("dev.foxgirl.mace3d.Mace3D"), "registerExternalMaceModel", MethodType.methodType(Void.TYPE, class_1792.class, class_2960.class, class_2960.class));
                for (AbstractElementalMaceItem item : this.getMaceItems()) {
                    class_2960 id = this.items.getID((class_1792)item);
                    registerModelMethod.invoke(item, id, id.method_48331("_in_hand"));
                }
            }
            catch (Throwable cause) {
                LOGGER.error("Failed to register external 3D mace models", cause);
            }
        } else {
            LOGGER.info("Skipping external 3D mace models, 'mace3d' is not loaded");
        }
    }

    public void registerAll() {
        this.registerItems();
        this.registerMace3DModels();
    }

    public boolean shouldIgnoreDamage(class_1309 entity, class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) && entity.method_24518((class_1792)this.smoulderingMace.get())) {
            return true;
        }
        return source.method_49708(class_8111.field_42350) && entity.method_24518((class_1792)this.witheringMace.get());
    }

    public static interface LoaderAdapter {
        public ItemRegisterAdapter createItemRegister(String var1);

        public boolean isModLoaded(String var1);

        public boolean isDedicatedServer();
    }

    public static interface ItemRegisterAdapter {
        public class_2960 getID(class_1792 var1);

        public class_1792 getItem(class_2960 var1);

        public <T extends class_1792> Supplier<T> add(String var1, Supplier<T> var2);

        public void register();
    }
}

