/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.ender_pack.core.block.type;

import com.mojang.serialization.MapCodec;
import forge.com.cursee.ender_pack.core.block.IRotatable;
import forge.com.cursee.ender_pack.core.block.entity.type.EnderPackBlockEntity;
import forge.com.cursee.ender_pack.core.registry.ModBlockEntities;
import forge.com.cursee.ender_pack.core.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderPackBlock
extends BaseEntityBlock
implements IRotatable {
    public static final MapCodec<EnderPackBlock> CODEC = EnderPackBlock.simpleCodec(EnderPackBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public EnderPackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderPackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : EnderPackBlock.createTickerHelper(type, ModBlockEntities.ENDER_PACK, EnderPackBlockEntity::tick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (VoxelShape)SHAPE.get(blockState.getValue((Property)FACING));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.ENDER_PACK);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            level.destroyBlock(pos, false);
            if (!player.isCreative()) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.ENDER_PACK)));
            }
            return InteractionResult.PASS;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerX) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderPack")));
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            level.destroyBlock(pos, false);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.ENDER_PACK)));
            return ItemInteractionResult.FAIL;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerX) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderPack")));
        return ItemInteractionResult.FAIL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int particleIndex = 0; particleIndex < 3; ++particleIndex) {
            int xModifier = random.nextInt(2) * 2 - 1;
            int zModifier = random.nextInt(2) * 2 - 1;
            double posX = (double)pos.getX() + 0.5 + 0.25 * (double)xModifier;
            double posY = (float)pos.getY() + random.nextFloat();
            double posZ = (double)pos.getZ() + 0.5 + 0.25 * (double)zModifier;
            double speedX = random.nextFloat() * (float)xModifier;
            double speedY = ((double)random.nextFloat() - 0.5) * 0.125;
            double speedZ = random.nextFloat() * (float)zModifier;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, posX, posY, posZ, speedX, speedY, speedZ);
        }
    }
}

